DROP VIEW rv_m_transaction;

CREATE OR REPLACE VIEW rv_m_transaction
AS
  SELECT t.ad_client_id,
         t.ad_org_id,
         t.movementdate,
         t.movementqty,
         t.m_product_id,
         t.m_locator_id,
         t.m_attributesetinstance_id,
         p.m_product_category_id,
         p.value,
         po.c_bpartner_id,
         po.pricepo,
         po.pricelastpo,
         po.pricelist,
         t.c_projectissue_id,
         t.created                   AS m_transaction_created,
         t.createdby                 AS m_transaction_createdby,
         t.isactive                  AS m_transaction_isactive,
         t.m_inoutline_id,
         t.movementtype,
         t.m_productionline_id,
         t.m_transaction_id,
         t.pp_cost_collector_id,
         t.updated                   AS m_transation_updated,
         t.updatedby                 AS m_transation_updatedby,
         p.ad_org_id                 AS m_product_ad_org_id,
         p.classification,
         p.copyfrom                  AS m_product_copyfrom,
         p.created                   AS m_product_created,
         p.createdby                 AS m_product_createdby,
         p.c_revenuerecognition_id,
         p.c_subscriptiontype_id,
         p.c_taxcategory_id,
         p.c_uom_id                  AS m_product_c_uom_id,
         p.description               AS m_product_description,
         p.descriptionurl,
         p.discontinued              AS m_product_discontinued,
         p.discontinuedat            AS m_product_discontinuedat,
         p.documentnote,
         p.group1,
         p.group2,
         p.guaranteedays,
         p.guaranteedaysmin,
         p.help,
         p.imageurl,
         p.isactive                  AS m_product_isactive,
         p.isdropship,
         p.isexcludeautodelivery,
         p.isinvoiceprintdetails,
         p.ispicklistprintdetails,
         p.ispurchased,
         p.isselfservice,
         p.issold,
         p.isstocked,
         p.issummary                 AS m_product_issummary,
         p.isverified,
         p.iswebstorefeatured,
         p.lowlevel,
         p.m_attributeset_id         AS m_product_m_attributeset_id,
         p.m_attributesetinstance_id AS m_product_m_asi_id,
         p.m_freightcategory_id,
         p.m_locator_id              AS m_product_m_locator_id,
         p.name                      AS m_product_name,
         p.processing                AS m_product_processing,
         p.producttype,
         p.r_mailtext_id,
         p.salesrep_id               AS m_product_salesrep_id,
         p.s_expensetype_id,
         p.shelfdepth,
         p.shelfheight,
         p.shelfwidth,
         p.sku,
         p.s_resource_id,
         p.unitsperpack,
         p.unitsperpallet,
         p.upc                       AS m_product_upc,
         p.updated                   AS m_product_updated,
         p.updatedby                 AS m_product_updatedby,
         p.versionno,
         p.volume,
         p.weight,
         po.ad_org_id                AS m_product_po_ad_org_id,
         po.c_currency_id            AS m_product_po_c_currency_id,
         po.costperorder,
         po.created                  AS m_product_po_created,
         po.createdby                AS m_product_po_createdby,
         po.c_uom_id                 AS m_product_po_c_uom_id,
         po.deliverytime_actual,
         po.deliverytime_promised,
         po.discontinued             AS m_product_po_discontinued,
         po.discontinuedat           AS m_product_po_discontinuedat,
         po.isactive                 AS m_product_po_isactive,
         po.iscurrentvendor,
         po.manufacturer,
         po.m_product_id             AS m_product_po_m_product_id,
         po.order_min,
         po.order_pack,
         po.priceeffective,
         po.pricelastinv,
         po.qualityrating,
         po.royaltyamt,
         po.upc                      AS m_product_po_upc,
         po.updated                  AS m_product_po_updated,
         po.updatedby                AS m_product_po_updatedby,
         po.vendorcategory,
         po.vendorproductno
  FROM   m_transaction t
         JOIN m_product p
           ON t.m_product_id = p.m_product_id
         JOIN m_product_po po
           ON t.m_product_id = po.m_product_id
  WHERE  po.iscurrentvendor = 'Y'
;

