 -- upgrading database from compiere 253a to 253b 
 -- Written by Karsten Thiemann, kt@schaeffer-ag.de
 -- Feel free to change everything you want, but you are using it at your own risk!
 
 -- This script changes the db structure by adding missing tables and columns.
 -- It also adds lines to some of the new tables.
 
 -- Your data is left unchaged - with the following exceptions: .
 -- ALL ENTRIES IN PA_ACHIEVEMENT, PA_MEASURE, PA_GOAL,
 -- PA_MEASURECALC AND T_INVENTORYVALUE ARE DELETED
 -- If you have CUSTOM DATA in there please do a backup and reapply it after migration.
 -- The code for the deletion is marked with BEWARE
 
 -- CUSTOM DATA means data from your client not from GardeWorld or System: 
 -- select * from PA_MEASURE where AD_Client_ID!=11 and AD_Client_ID!=0;
 -- select * from PA_MEASURECALC where AD_Client_ID!=11 and AD_Client_ID!=0;
 -- select * from T_INVENTORYVALUE where AD_Client_ID!=11 and AD_Client_ID!=0;
 -- If you get some lines, you have custom data...
 
--  Please review the setting of the DEFAULT VALUES for some of the
 -- added columns. They are marked with REPLACE_ME so just use the search function
 -- of your editor. So just follow the instructions there.
 
DELETE FROM PA_ACHIEVEMENT;
DELETE from PA_GOAL;
 
  CREATE TABLE "AD_CLIENTSHARE" 
   (	"AD_CLIENTSHARE_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"DESCRIPTION" NVARCHAR2(255), 
	"AD_TABLE_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"SHARETYPE" CHAR(1 BYTE) NOT NULL ENABLE, 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "AD_CLIENTSHARE_KEY" PRIMARY KEY ("AD_CLIENTSHARE_ID") ENABLE, 
	 CONSTRAINT "ADCLIENT_ADCLIENTSHARE" FOREIGN KEY ("AD_CLIENT_ID")
	  REFERENCES "AD_CLIENT" ("AD_CLIENT_ID") ENABLE, 
	 CONSTRAINT "ADORG_ADCLIENTSHARE" FOREIGN KEY ("AD_ORG_ID")
	  REFERENCES "AD_ORG" ("AD_ORG_ID") ENABLE, 
	 CONSTRAINT "ADTABLE_ADCLIENTSHARE" FOREIGN KEY ("AD_TABLE_ID")
	  REFERENCES "AD_TABLE" ("AD_TABLE_ID") ENABLE
   ) ;
 
CREATE UNIQUE INDEX "AD_CLIENTSHARE_TABLE" ON "AD_CLIENTSHARE" ("AD_CLIENT_ID", "AD_TABLE_ID") ;


 CREATE TABLE "R_ISSUESYSTEM" 
   (	"R_ISSUESYSTEM_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"DBADDRESS" NVARCHAR2(255) NOT NULL ENABLE, 
	"STATISTICSINFO" NVARCHAR2(60), 
	"PROFILEINFO" NVARCHAR2(60), 
	"SYSTEMSTATUS" CHAR(1 BYTE) NOT NULL ENABLE, 
	"A_ASSET_ID" NUMBER(10,0), 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "R_ISSUESYSTEM_KEY" PRIMARY KEY ("R_ISSUESYSTEM_ID") ENABLE
   ) ;
 

  CREATE UNIQUE INDEX "R_ISSUESYSTEM_ADDRESS" ON "R_ISSUESYSTEM" ("DBADDRESS") ;

  CREATE TABLE "R_ISSUEUSER" 
   (	"R_ISSUEUSER_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"USERNAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"DESCRIPTION" NVARCHAR2(255), 
	"AD_USER_ID" NUMBER(10,0), 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "R_ISSUEUSER_KEY" PRIMARY KEY ("R_ISSUEUSER_ID") ENABLE, 
	 CONSTRAINT "ADUSER_RISSUEUSER" FOREIGN KEY ("AD_USER_ID")
	  REFERENCES "AD_USER" ("AD_USER_ID") ENABLE
   ) ;

  CREATE UNIQUE INDEX "R_ISSUEUSER_EMAIL" ON "R_ISSUEUSER" ("USERNAME", "AD_CLIENT_ID") ;
  
    CREATE TABLE "R_ISSUESTATUS" 
     (	"R_ISSUESTATUS_ID" NUMBER(10,0) NOT NULL ENABLE, 
  	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
  	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
  	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
  	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
  	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
  	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
  	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
  	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
  	"DESCRIPTION" NVARCHAR2(255), 
  	 CHECK (IsActive in ('Y','N')) ENABLE, 
  	 CONSTRAINT "R_ISSUESTATUS_KEY" PRIMARY KEY ("R_ISSUESTATUS_ID") ENABLE
   ) ;
   
     CREATE TABLE "R_ISSUEPROJECT" 
      (	"R_ISSUEPROJECT_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
   	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
   	"DESCRIPTION" NVARCHAR2(255), 
   	"A_ASSET_ID" NUMBER(10,0), 
   	"C_PROJECT_ID" NUMBER(10,0), 
   	"STATISTICSINFO" NVARCHAR2(60), 
   	"PROFILEINFO" NVARCHAR2(60), 
   	"SYSTEMSTATUS" CHAR(1 BYTE) NOT NULL ENABLE, 
   	 CHECK (IsActive in ('Y','N')) ENABLE, 
   	 CONSTRAINT "R_ISSUEPROJECT_KEY" PRIMARY KEY ("R_ISSUEPROJECT_ID") ENABLE, 
   	 CONSTRAINT "AASSET_RISSUEPROJECT" FOREIGN KEY ("A_ASSET_ID")
   	  REFERENCES "A_ASSET" ("A_ASSET_ID") ENABLE, 
   	 CONSTRAINT "CPROJECT_RISSUEPROJECT" FOREIGN KEY ("C_PROJECT_ID")
   	  REFERENCES "C_PROJECT" ("C_PROJECT_ID") ENABLE
      ) ;
    
   
     CREATE INDEX "R_ISSUEPROJECT_NAME" ON "R_ISSUEPROJECT" ("NAME") ;
   
     CREATE TABLE "R_ISSUERECOMMENDATION" 
      (	"R_ISSUERECOMMENDATION_ID" CHAR(1 BYTE) DEFAULT 'N' NOT NULL ENABLE, 
   	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
   	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
   	"DESCRIPTION" NVARCHAR2(255), 
   	"HELP" NVARCHAR2(2000), 
   	 CHECK (IsActive in ('Y','N')) ENABLE, 
   	 CONSTRAINT "R_ISSUERECOMMENDATION_KEY" PRIMARY KEY ("R_ISSUERECOMMENDATION_ID") ENABLE
   ) ;
   
   CREATE TABLE "R_ISSUEKNOWN" 
   (	"R_ISSUEKNOWN_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"ISSUESUMMARY" NVARCHAR2(255) NOT NULL ENABLE, 
	"RELEASENO" CHAR(4 BYTE) NOT NULL ENABLE, 
	"SOURCECLASSNAME" NVARCHAR2(60), 
	"SOURCEMETHODNAME" NVARCHAR2(60), 
	"LOGGERNAME" NVARCHAR2(60), 
	"LINENO" NUMBER(10,0) DEFAULT 0, 
	"DESCRIPTION" NVARCHAR2(255), 
	"ISSUESTATUS" NVARCHAR2(2000), 
	"R_ISSUERECOMMENDATION_ID" CHAR(1 BYTE), 
	"R_ISSUESTATUS_ID" NUMBER(10,0), 
	"R_REQUEST_ID" NUMBER(10,0), 
	"PROCESSING" CHAR(1 BYTE), 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "R_KNOWNISSUE_KEY" PRIMARY KEY ("R_ISSUEKNOWN_ID") ENABLE, 
	 CONSTRAINT "RISSUEREC_RISSUEKNOWN" FOREIGN KEY ("R_ISSUERECOMMENDATION_ID")
	  REFERENCES "R_ISSUERECOMMENDATION" ("R_ISSUERECOMMENDATION_ID") ENABLE, 
	 CONSTRAINT "RISSUESTATUS_RISSUEKNOWN" FOREIGN KEY ("R_ISSUESTATUS_ID")
	  REFERENCES "R_ISSUESTATUS" ("R_ISSUESTATUS_ID") ENABLE, 
	 CONSTRAINT "RREQUEST_RISSUEKNOWN" FOREIGN KEY ("R_REQUEST_ID")
	  REFERENCES "R_REQUEST" ("R_REQUEST_ID") ENABLE
   ) ;
 
CREATE UNIQUE INDEX "R_KNOWNISSUE_ALT" ON "R_ISSUEKNOWN" ("ISSUESUMMARY", "RELEASENO", "SOURCECLASSNAME", "SOURCEMETHODNAME", "LOGGERNAME", "LINENO")  ;  
   
  CREATE TABLE "R_ISSUESOURCE" 
   (	"R_ISSUESOURCE_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"R_ISSUESYSTEM_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"R_ISSUEPROJECT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"R_ISSUEUSER_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"STATISTICSINFO" NVARCHAR2(60), 
	"PROFILEINFO" NVARCHAR2(60), 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "R_ISSUESOURCE_KEY" PRIMARY KEY ("R_ISSUESOURCE_ID") ENABLE, 
	 CONSTRAINT "RISSUEPROJECT_RISSUESOURCE" FOREIGN KEY ("R_ISSUEPROJECT_ID")
	  REFERENCES "R_ISSUEPROJECT" ("R_ISSUEPROJECT_ID") ENABLE, 
	 CONSTRAINT "RISSUESYSTEM_RISSUESOURCE" FOREIGN KEY ("R_ISSUESYSTEM_ID")
	  REFERENCES "R_ISSUESYSTEM" ("R_ISSUESYSTEM_ID") ENABLE, 
	 CONSTRAINT "RISSUEUSER_RISSUESOURCE" FOREIGN KEY ("R_ISSUEUSER_ID")
	  REFERENCES "R_ISSUEUSER" ("R_ISSUEUSER_ID") ENABLE
   ) ;

  CREATE UNIQUE INDEX "R_ISSUESOURCE_SPO" ON "R_ISSUESOURCE" ("R_ISSUESYSTEM_ID", "R_ISSUEPROJECT_ID", "R_ISSUEUSER_ID") ;


  CREATE TABLE "AD_ISSUE" 
   (	"AD_ISSUE_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"RELEASENO" CHAR(4 BYTE) NOT NULL ENABLE, 
	"VERSION" NVARCHAR2(40) NOT NULL ENABLE, 
	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"USERNAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"SUPPORTEMAIL" NVARCHAR2(60), 
	"DBADDRESS" NVARCHAR2(255), 
	"LOCAL_HOST" NVARCHAR2(120), 
	"OPERATINGSYSTEMINFO" NVARCHAR2(255) DEFAULT NULL, 
	"RELEASETAG" NVARCHAR2(60), 
	"DATABASEINFO" NVARCHAR2(255) DEFAULT NULL, 
	"JAVAINFO" NVARCHAR2(255) DEFAULT NULL, 
	"REMOTE_ADDR" NVARCHAR2(60), 
	"REMOTE_HOST" NVARCHAR2(120), 
	"ISSUESUMMARY" NVARCHAR2(2000) DEFAULT NULL NOT NULL ENABLE, 
	"COMMENTS" NVARCHAR2(2000), 
	"SOURCECLASSNAME" NVARCHAR2(60), 
	"SOURCEMETHODNAME" NVARCHAR2(60), 
	"LOGGERNAME" NVARCHAR2(60), 
	"LINENO" NUMBER(10,0) DEFAULT 0, 
	"STACKTRACE" NVARCHAR2(2000), 
	"ERRORTRACE" NVARCHAR2(2000), 
	"RECORD_ID" NUMBER(10,0), 
	"REQUESTDOCUMENTNO" NVARCHAR2(30), 
	"A_ASSET_ID" NUMBER(10,0), 
	"R_REQUEST_ID" NUMBER(10,0), 
	"RESPONSETEXT" NVARCHAR2(2000), 
	"PROCESSING" CHAR(1 BYTE), 
	"PROCESSED" CHAR(1 BYTE) DEFAULT 'N' NOT NULL ENABLE, 
	"ISVANILLASYSTEM" CHAR(1 BYTE) DEFAULT 'N' 
                          , 
	"ISREPRODUCIBLE" CHAR(1 BYTE) DEFAULT 'N' 
                          , 
	"R_ISSUEKNOWN_ID" NUMBER(10,0), 
	"STATISTICSINFO" NVARCHAR2(255) DEFAULT NULL, 
	"PROFILEINFO" NVARCHAR2(255) DEFAULT NULL, 
	"SYSTEMSTATUS" CHAR(1 BYTE) NOT NULL ENABLE, 
	"R_ISSUEPROJECT_ID" NUMBER(10,0), 
	"R_ISSUEUSER_ID" NUMBER(10,0), 
	"R_ISSUESYSTEM_ID" NUMBER(10,0), 
	"ISSUESOURCE" CHAR(1 BYTE), 
	"AD_WINDOW_ID" NUMBER(10,0), 
	"AD_PROCESS_ID" NUMBER(10,0), 
	"AD_FORM_ID" NUMBER(10,0), 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CHECK (Processed in ('Y','N')) ENABLE, 
	 CHECK (IsVanillaSystem in ('Y','N')) ENABLE, 
	 CHECK (IsReproducible in ('Y','N')) ENABLE, 
	 CONSTRAINT "AD_ISSUE_KEY" PRIMARY KEY ("AD_ISSUE_ID") ENABLE, 
	 CONSTRAINT "AASSET_ADISSUE" FOREIGN KEY ("A_ASSET_ID")
	  REFERENCES "A_ASSET" ("A_ASSET_ID") ON DELETE SET NULL ENABLE, 
	 CONSTRAINT "ADFORM_ADISSUE" FOREIGN KEY ("AD_FORM_ID")
	  REFERENCES "AD_FORM" ("AD_FORM_ID") ON DELETE SET NULL ENABLE, 
	 CONSTRAINT "ADPROCESS_ADISSUE" FOREIGN KEY ("AD_PROCESS_ID")
	  REFERENCES "AD_PROCESS" ("AD_PROCESS_ID") ON DELETE SET NULL ENABLE, 
	 CONSTRAINT "ADWINDOW_ADISSUE" FOREIGN KEY ("AD_WINDOW_ID")
	  REFERENCES "AD_WINDOW" ("AD_WINDOW_ID") ON DELETE SET NULL ENABLE, 
	 CONSTRAINT "RISSUEPROJECT_ADISSUE" FOREIGN KEY ("R_ISSUEPROJECT_ID")
	  REFERENCES "R_ISSUEPROJECT" ("R_ISSUEPROJECT_ID") ENABLE, 
	 CONSTRAINT "RISSUESYSTEM_AD_ISSUE" FOREIGN KEY ("R_ISSUESYSTEM_ID")
	  REFERENCES "R_ISSUESYSTEM" ("R_ISSUESYSTEM_ID") ENABLE, 
	 CONSTRAINT "RISSUEUSER_ADISSUE" FOREIGN KEY ("R_ISSUEUSER_ID")
	  REFERENCES "R_ISSUEUSER" ("R_ISSUEUSER_ID") ENABLE, 
	 CONSTRAINT "RKNOWNISSUE_ADISSUE" FOREIGN KEY ("R_ISSUEKNOWN_ID")
	  REFERENCES "R_ISSUEKNOWN" ("R_ISSUEKNOWN_ID") ENABLE, 
	 CONSTRAINT "RREQUEST_ADISSUE" FOREIGN KEY ("R_REQUEST_ID")
	  REFERENCES "R_REQUEST" ("R_REQUEST_ID") ON DELETE SET NULL ENABLE
   ) ;
 

   COMMENT ON TABLE "AD_ISSUE"  IS 'Compiere Automatic Issue Reporting';
 

  CREATE TABLE "C_SUBACCT" 
   (	"C_SUBACCT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"VALUE" NVARCHAR2(40) NOT NULL ENABLE, 
	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"DESCRIPTION" NVARCHAR2(255), 
	"HELP" NVARCHAR2(2000), 
	"C_ELEMENTVALUE_ID" NUMBER(10,0) NOT NULL ENABLE, 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "C_SUBACCT_KEY" PRIMARY KEY ("C_SUBACCT_ID") ENABLE, 
	 CONSTRAINT "CELEMENTVALUE_CSUBACCT" FOREIGN KEY ("C_ELEMENTVALUE_ID")
	  REFERENCES "C_ELEMENTVALUE" ("C_ELEMENTVALUE_ID") ON DELETE CASCADE ENABLE
   ) ;
   
     CREATE TABLE "PA_GOALRESTRICTION" 
      (	"PA_GOALRESTRICTION_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
   	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
   	"GOALRESTRICTIONTYPE" CHAR(1 BYTE) NOT NULL ENABLE, 
   	"PA_GOAL_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"C_BPARTNER_ID" NUMBER(10,0), 
   	"M_PRODUCT_ID" NUMBER(10,0), 
   	"ORG_ID" NUMBER(10,0), 
   	"C_BP_GROUP_ID" NUMBER(10,0), 
   	"M_PRODUCT_CATEGORY_ID" NUMBER(10,0), 
   	 CHECK (IsActive in ('Y','N')) ENABLE, 
   	 CONSTRAINT "PA_GOALRESTRICTION_KEY" PRIMARY KEY ("PA_GOALRESTRICTION_ID") ENABLE, 
   	 CONSTRAINT "ADORG2_PAGOALRESTRICTION" FOREIGN KEY ("ORG_ID")
   	  REFERENCES "AD_ORG" ("AD_ORG_ID") ENABLE, 
   	 CONSTRAINT "ADORG_PAGOALRESTRICTION" FOREIGN KEY ("AD_ORG_ID")
   	  REFERENCES "AD_ORG" ("AD_ORG_ID") ENABLE, 
   	 CONSTRAINT "CBPARTNER_PAGOALRESTRICTION" FOREIGN KEY ("C_BPARTNER_ID")
   	  REFERENCES "C_BPARTNER" ("C_BPARTNER_ID") ENABLE, 
   	 CONSTRAINT "CBPGROUP_PAGOALRESTRICTION" FOREIGN KEY ("C_BP_GROUP_ID")
   	  REFERENCES "C_BP_GROUP" ("C_BP_GROUP_ID") ENABLE, 
   	 CONSTRAINT "MPRODUCTCAT_PAGOALRESTRICTION" FOREIGN KEY ("M_PRODUCT_CATEGORY_ID")
   	  REFERENCES "M_PRODUCT_CATEGORY" ("M_PRODUCT_CATEGORY_ID") ENABLE, 
   	 CONSTRAINT "MPRODUCT_PAGOALRESTRICTION" FOREIGN KEY ("M_PRODUCT_ID")
   	  REFERENCES "M_PRODUCT" ("M_PRODUCT_ID") ENABLE, 
   	 CONSTRAINT "PAGOAL_PAGOALRESTRICTION" FOREIGN KEY ("PA_GOAL_ID")
   	  REFERENCES "PA_GOAL" ("PA_GOAL_ID") ENABLE
   ) ;
   
     CREATE TABLE "R_MAILTEXT_TRL" 
      (	"R_MAILTEXT_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_LANGUAGE" VARCHAR2(6 BYTE) NOT NULL ENABLE, 
   	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
   	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"ISTRANSLATED" CHAR(1 BYTE) DEFAULT 'N' NOT NULL ENABLE, 
   	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
   	"MAILHEADER" NVARCHAR2(2000) NOT NULL ENABLE, 
   	"MAILTEXT" NVARCHAR2(2000) NOT NULL ENABLE, 
   	"MAILTEXT2" NVARCHAR2(2000), 
   	"MAILTEXT3" NVARCHAR2(2000), 
   	 CHECK (IsActive in ('Y','N')) ENABLE, 
   	 CHECK (IsTranslated in ('Y','N')) ENABLE, 
   	 CONSTRAINT "R_MAILTEXT_TRL_KEY" PRIMARY KEY ("R_MAILTEXT_ID", "AD_LANGUAGE") ENABLE, 
   	 CONSTRAINT "ADLANGUAGE_RMAILTEXTTRL" FOREIGN KEY ("AD_LANGUAGE")
   	  REFERENCES "AD_LANGUAGE" ("AD_LANGUAGE") ENABLE, 
   	 CONSTRAINT "RMAILTEXT_RMAILTEXTTRL" FOREIGN KEY ("R_MAILTEXT_ID")
   	  REFERENCES "R_MAILTEXT" ("R_MAILTEXT_ID") ON DELETE CASCADE ENABLE
   ) ;

  CREATE TABLE "PA_COLORSCHEMA" 
   (	"PA_COLORSCHEMA_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"DESCRIPTION" NVARCHAR2(255), 
	"MARK1PERCENT" NUMBER(10,0) DEFAULT 0 NOT NULL ENABLE, 
	"AD_PRINTCOLOR1_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"MARK2PERCENT" NUMBER(10,0) DEFAULT 0 NOT NULL ENABLE, 
	"AD_PRINTCOLOR2_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"MARK3PERCENT" NUMBER(10,0) DEFAULT 0, 
	"AD_PRINTCOLOR3_ID" NUMBER(10,0), 
	"MARK4PERCENT" NUMBER(10,0) DEFAULT 0, 
	"AD_PRINTCOLOR4_ID" NUMBER(10,0), 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "PA_COLORSCHEMA_KEY" PRIMARY KEY ("PA_COLORSCHEMA_ID") ENABLE, 
	 CONSTRAINT "ADPRINTCOLOR1_PACOLORSCHEMA" FOREIGN KEY ("AD_PRINTCOLOR1_ID")
	  REFERENCES "AD_PRINTCOLOR" ("AD_PRINTCOLOR_ID") ENABLE, 
	 CONSTRAINT "ADPRINTCOLOR2_PACOLORSCHEMA" FOREIGN KEY ("AD_PRINTCOLOR2_ID")
	  REFERENCES "AD_PRINTCOLOR" ("AD_PRINTCOLOR_ID") ENABLE, 
	 CONSTRAINT "ADPRINTCOLOR3_PACOLORSCHEMA" FOREIGN KEY ("AD_PRINTCOLOR3_ID")
	  REFERENCES "AD_PRINTCOLOR" ("AD_PRINTCOLOR_ID") ENABLE, 
	 CONSTRAINT "ADPRINTCOLOR4_PACOLORSCHEMA" FOREIGN KEY ("AD_PRINTCOLOR4_ID")
	  REFERENCES "AD_PRINTCOLOR" ("AD_PRINTCOLOR_ID") ENABLE
   ) ;
   
   /* INSERTING into PA_COLORSCHEMA */
   Insert into "PA_COLORSCHEMA" ("PA_COLORSCHEMA_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","MARK1PERCENT","AD_PRINTCOLOR1_ID","MARK2PERCENT","AD_PRINTCOLOR2_ID","MARK3PERCENT","AD_PRINTCOLOR3_ID","MARK4PERCENT","AD_PRINTCOLOR4_ID") values (101,0,0,'Y',to_date('31.12.05','DD.MM.RR'),100,to_date('31.12.05','DD.MM.RR'),100,'Green (50) - Yellow (100) - Red','< 100% is the goal',50,103,100,113,9999,102,0,null);
   Insert into "PA_COLORSCHEMA" ("PA_COLORSCHEMA_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","MARK1PERCENT","AD_PRINTCOLOR1_ID","MARK2PERCENT","AD_PRINTCOLOR2_ID","MARK3PERCENT","AD_PRINTCOLOR3_ID","MARK4PERCENT","AD_PRINTCOLOR4_ID") values (100,0,0,'Y',to_date('23.12.05','DD.MM.RR'),100,to_date('31.12.05','DD.MM.RR'),100,'Red (50) - Yellow (100) - Green','>= 100% is the goal',50,102,100,113,9999,103,0,null);


  CREATE TABLE "PA_RATIO" 
   (	"PA_RATIO_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"DESCRIPTION" NVARCHAR2(255), 
	"HELP" NVARCHAR2(2000), 
	"C_ACCTSCHEMA_ID" NUMBER(10,0) NOT NULL ENABLE, 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "PA_RATIO_KEY" PRIMARY KEY ("PA_RATIO_ID") ENABLE, 
	 CONSTRAINT "CACCTSCHEMA_PARATIO" FOREIGN KEY ("C_ACCTSCHEMA_ID")
	  REFERENCES "C_ACCTSCHEMA" ("C_ACCTSCHEMA_ID") ENABLE
   ) ;
   
   /* INSERTING into PA_RATIO */
   Insert into "PA_RATIO" ("PA_RATIO_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","HELP","C_ACCTSCHEMA_ID") values (100,11,11,'Y',to_date('26.12.05','DD.MM.RR'),101,to_date('26.12.05','DD.MM.RR'),101,'Fxed Assets',null,null,101);


  CREATE TABLE "PA_RATIOELEMENT" 
   (	"PA_RATIOELEMENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"DESCRIPTION" NVARCHAR2(255), 
	"PA_RATIO_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"RATIOOPERAND" CHAR(1 BYTE) NOT NULL ENABLE, 
	"RATIOELEMENTTYPE" CHAR(1 BYTE) NOT NULL ENABLE, 
	"ACCOUNT_ID" NUMBER(10,0), 
	"PA_RATIOUSED_ID" NUMBER(10,0), 
	"PA_MEASURECALC_ID" NUMBER(10,0), 
	"CONSTANTVALUE" NUMBER, 
	"SEQNO" NUMBER(10,0) NOT NULL ENABLE, 
	"POSTINGTYPE" CHAR(1 BYTE), 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "PA_RATIOELEMENT_KEY" PRIMARY KEY ("PA_RATIOELEMENT_ID") ENABLE, 
	 CONSTRAINT "CELEMENTVALUE_PARATIOELEMENT" FOREIGN KEY ("ACCOUNT_ID")
	  REFERENCES "C_ELEMENTVALUE" ("C_ELEMENTVALUE_ID") ENABLE, 
	 CONSTRAINT "PAMEASURECALC_PARATIOELEMENT" FOREIGN KEY ("PA_MEASURECALC_ID")
	  REFERENCES "PA_MEASURECALC" ("PA_MEASURECALC_ID") ENABLE, 
	 CONSTRAINT "PARATIOUSED_PARATIOELEMENT" FOREIGN KEY ("PA_RATIOUSED_ID")
	  REFERENCES "PA_RATIO" ("PA_RATIO_ID") ENABLE, 
	 CONSTRAINT "PARATIO_PARATIOELEMENT" FOREIGN KEY ("PA_RATIO_ID")
	  REFERENCES "PA_RATIO" ("PA_RATIO_ID") ENABLE
   ) ;
   
   /* INSERTING into PA_RATIOELEMENT */
   Insert into "PA_RATIOELEMENT" ("PA_RATIOELEMENT_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","PA_RATIO_ID","RATIOOPERAND","RATIOELEMENTTYPE","ACCOUNT_ID","PA_RATIOUSED_ID","PA_MEASURECALC_ID","CONSTANTVALUE","SEQNO","POSTINGTYPE") values (100,11,11,'Y',to_date('26.12.05','DD.MM.RR'),101,to_date('26.12.05','DD.MM.RR'),101,'Long Term Investments',null,100,'P','A',537,null,null,0,10,'A');
   Insert into "PA_RATIOELEMENT" ("PA_RATIOELEMENT_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","PA_RATIO_ID","RATIOOPERAND","RATIOELEMENTTYPE","ACCOUNT_ID","PA_RATIOUSED_ID","PA_MEASURECALC_ID","CONSTANTVALUE","SEQNO","POSTINGTYPE") values (101,11,11,'Y',to_date('26.12.05','DD.MM.RR'),101,to_date('26.12.05','DD.MM.RR'),101,'Inventory',null,100,'P','A',541,null,null,0,0,'A');
   Insert into "PA_RATIOELEMENT" ("PA_RATIOELEMENT_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","PA_RATIO_ID","RATIOOPERAND","RATIOELEMENTTYPE","ACCOUNT_ID","PA_RATIOUSED_ID","PA_MEASURECALC_ID","CONSTANTVALUE","SEQNO","POSTINGTYPE") values (102,11,11,'Y',to_date('26.12.05','DD.MM.RR'),101,to_date('26.12.05','DD.MM.RR'),101,'Land and Building',null,100,'P','A',554,null,null,0,0,null);


  CREATE TABLE "R_STATUSCATEGORY" 
   (	"R_STATUSCATEGORY_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"DESCRIPTION" NVARCHAR2(255), 
	"HELP" NVARCHAR2(2000), 
	"ISDEFAULT" CHAR(1 BYTE) DEFAULT 'N' NOT NULL ENABLE, 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CHECK (IsDefault in ('Y','N')) ENABLE, 
	 CONSTRAINT "R_STATUSCATEGORY_KEY" PRIMARY KEY ("R_STATUSCATEGORY_ID") ENABLE
   ) ;
 
 /* INSERTING into R_STATUSCATEGORY */
 Insert into "R_STATUSCATEGORY" ("R_STATUSCATEGORY_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","HELP","ISDEFAULT") values (100,11,0,'Y',to_date('15.01.06','DD.MM.RR'),100,to_date('15.01.06','DD.MM.RR'),100,'Default','Default Request Status',null,'Y');


  CREATE TABLE "PA_BENCHMARK" 
   (	"PA_BENCHMARK_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
	"DESCRIPTION" NVARCHAR2(255), 
	"HELP" NVARCHAR2(2000), 
	"ACCUMULATIONTYPE" CHAR(1 BYTE) NOT NULL ENABLE, 
	 CHECK (IsActive in ('Y','N')) ENABLE, 
	 CONSTRAINT "PA_BENMARK_KEY" PRIMARY KEY ("PA_BENCHMARK_ID") ENABLE
   ) ;
   
     CREATE TABLE "PA_BENCHMARKDATA" 
      (	"PA_BENCHMARKDATA_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_CLIENT_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"AD_ORG_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"ISACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE, 
   	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"CREATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE, 
   	"UPDATEDBY" NUMBER(10,0) NOT NULL ENABLE, 
   	"NAME" NVARCHAR2(60) NOT NULL ENABLE, 
   	"DESCRIPTION" NVARCHAR2(255), 
   	"PA_BENCHMARK_ID" NUMBER(10,0) NOT NULL ENABLE, 
   	"BENCHMARKDATE" DATE NOT NULL ENABLE, 
   	"BENCHMARKVALUE" NUMBER NOT NULL ENABLE, 
   	 CHECK (IsActive in ('Y','N')) ENABLE, 
   	 CONSTRAINT "PA_BENCHMARKDATA_KEY" PRIMARY KEY ("PA_BENCHMARKDATA_ID") ENABLE, 
   	 CONSTRAINT "PABENCHMARK_PABENCHMARKDATA" FOREIGN KEY ("PA_BENCHMARK_ID")
   	  REFERENCES "PA_BENCHMARK" ("PA_BENCHMARK_ID") ON DELETE CASCADE ENABLE
   ) ;



/* alter existing tables - add new columns */
 ALTER TABLE "C_TAXDECLARATIONACCT" 
 ADD "LINE" NUMBER(10,0);
 
 
   ALTER TABLE "C_TAXDECLARATIONLINE" 
   ADD ("ISMANUAL" CHAR(1 BYTE) DEFAULT 'N' NOT NULL ENABLE, 
 	"C_CURRENCY_ID" NUMBER(10,0) NULL );
 
 --  REPLACE_ME: set a 
 -- default value for C_Currency_ID (the default currency) 102 is EUR, 100 is USD 
    UPDATE "C_TAXDECLARATIONLINE" SET "C_CURRENCY_ID"=100;
    
   ALTER TABLE "C_TAXDECLARATIONLINE" 
   MODIFY ("C_CURRENCY_ID" NUMBER(10,0) NOT NULL ENABLE);    
 	
  ALTER TABLE "C_TAXDECLARATIONLINE" 
   ADD CONSTRAINT "CCURRENCY_CTAXDECLLINE" FOREIGN KEY ("C_CURRENCY_ID")
 	  REFERENCES "C_CURRENCY" ("C_CURRENCY_ID");
 		
 	
 ALTER TABLE  "FACT_ACCT_BALANCE" 
 ADD	   (	"C_SUBACCT_ID" NUMBER(10,0), 
		"USERELEMENT1_ID" NUMBER(10,0), 
		"USERELEMENT2_ID" NUMBER(10,0));
		


 ALTER TABLE "PA_ACHIEVEMENT" 
 ADD (	"MANUALACTUAL" NUMBER DEFAULT 0 NOT NULL, 
	"PA_MEASURE_ID" NUMBER(10,0) NULL, 
	"DATEDOC" DATE);
	
 ALTER TABLE  "PA_ACHIEVEMENT"
 ADD CONSTRAINT "PAMEASURE_PAACHIEVEMENT" FOREIGN KEY ("PA_MEASURE_ID")
	  REFERENCES "PA_MEASURE" ("PA_MEASURE_ID");
	  
  --  REPLACE_ME: if there are lines in the table you have to set a 
  --  default value for PA_MEASURE_ID (references PA_Measure)
   UPDATE "PA_ACHIEVEMENT" SET "PA_MEASURE_ID"=0;
   
  ALTER TABLE "PA_ACHIEVEMENT" 
   MODIFY "PA_MEASURE_ID" NUMBER(10,0) NOT NULL;
   

/* BEWARE: ALL ENTRIES IN PA_MEASURE AND PA_MEASURECALC ARE DELETED */
DELETE FROM "PA_MEASURE";
DELETE FROM "PA_MEASURECALC";

  ALTER TABLE "PA_MEASURECALC" 
  ADD (	"AD_TABLE_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"KEYCOLUMN" NVARCHAR2(60) NOT NULL ENABLE, 
	"ENTITYTYPE" VARCHAR2(4 BYTE) NOT NULL ENABLE
   ) ;

/* INSERTING into PA_MEASURECALC */
Insert into "PA_MEASURECALC" ("PA_MEASURECALC_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","SELECTCLAUSE","WHERECLAUSE","DATECOLUMN","ORGCOLUMN","BPARTNERCOLUMN","PRODUCTCOLUMN","AD_TABLE_ID","KEYCOLUMN","ENTITYTYPE") values (100,0,0,'Y',to_date('26.04.01','DD.MM.RR'),0,to_date('01.01.06','DD.MM.RR'),100,'Invoiced Net Revenue','Invoiced net revenue, without tax and charges','SELECT SUM(il.LineNetAmt) 
FROM RV_C_Invoice C_Invoice
  INNER JOIN RV_C_InvoiceLine il ON (C_Invoice.C_Invoice_ID=il.C_Invoice_ID)','WHERE C_Invoice.IsSOTrx=''Y'' AND C_Invoice.Processed=''Y''','C_Invoice.DateInvoiced','C_Invoice.AD_Org_ID','C_Invoice.C_BPartner_ID','il.M_Product_ID',318,'C_Invoice.C_Invoice_ID','D');
Insert into "PA_MEASURECALC" ("PA_MEASURECALC_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","SELECTCLAUSE","WHERECLAUSE","DATECOLUMN","ORGCOLUMN","BPARTNERCOLUMN","PRODUCTCOLUMN","AD_TABLE_ID","KEYCOLUMN","ENTITYTYPE") values (101,0,0,'Y',to_date('26.04.01','DD.MM.RR'),0,to_date('01.01.06','DD.MM.RR'),100,'Invoiced Gross Revenue','Invoice gross amount including tax; Does not allow selection by product (Category)','SELECT SUM(GrandTotal) 
FROM RV_C_Invoice C_Invoice','WHERE IsSOTrx=''Y'' AND Processed=''Y''','DateInvoiced','AD_Org_ID','C_BPartner_ID',null,318,'C_Invoice_ID','D');
Insert into "PA_MEASURECALC" ("PA_MEASURECALC_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","SELECTCLAUSE","WHERECLAUSE","DATECOLUMN","ORGCOLUMN","BPARTNERCOLUMN","PRODUCTCOLUMN","AD_TABLE_ID","KEYCOLUMN","ENTITYTYPE") values (102,0,0,'Y',to_date('26.04.01','DD.MM.RR'),0,to_date('01.01.06','DD.MM.RR'),100,'Invoiced Sales Margin','Difference between Limit and Actual price','SELECT SUM((il.PriceActual-il.PriceLimit)*QtyInvoiced) 
FROM RV_C_Invoice C_Invoice
  INNER JOIN RV_C_InvoiceLine il ON (C_Invoice.C_Invoice_ID=il.C_Invoice_ID)','WHERE C_Invoice.IsSOTrx=''Y'' AND C_Invoice.Processed=''Y''','C_Invoice.DateInvoiced','C_Invoice.AD_Org_ID','C_Invoice.C_BPartner_ID','il.M_Product_ID',318,'C_Invoice.C_Invoice_ID','D');
Insert into "PA_MEASURECALC" ("PA_MEASURECALC_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","SELECTCLAUSE","WHERECLAUSE","DATECOLUMN","ORGCOLUMN","BPARTNERCOLUMN","PRODUCTCOLUMN","AD_TABLE_ID","KEYCOLUMN","ENTITYTYPE") values (103,0,0,'Y',to_date('26.04.01','DD.MM.RR'),0,to_date('25.12.05','DD.MM.RR'),100,'Number of Customers','Number of (new) customers','SELECT COUNT(*) 
FROM C_BPartner','WHERE IsCustomer=''Y''','Created','AD_Org_ID','C_BPartner_ID',null,291,'C_BPartner_ID','D');
Insert into "PA_MEASURECALC" ("PA_MEASURECALC_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","SELECTCLAUSE","WHERECLAUSE","DATECOLUMN","ORGCOLUMN","BPARTNERCOLUMN","PRODUCTCOLUMN","AD_TABLE_ID","KEYCOLUMN","ENTITYTYPE") values (104,0,0,'Y',to_date('25.12.05','DD.MM.RR'),100,to_date('01.01.06','DD.MM.RR'),100,'Invoiced Paid Quantities','Invoiced paid quantities','SELECT SUM(il.QtyInvoiced) 
FROM RV_C_Invoice C_Invoice
  INNER JOIN RV_C_InvoiceLine il ON (C_Invoice.C_Invoice_ID=il.C_Invoice_ID)','WHERE C_Invoice.IsSOTrx=''Y'' AND C_Invoice.Processed=''Y'' AND C_Invoice.IsPaid=''Y''
','C_Invoice.DateInvoiced','C_Invoice.AD_Org_ID','C_Invoice.C_BPartner_ID','il.M_Product_ID',318,'C_Invoice.C_Invoice_ID','D');
Insert into "PA_MEASURECALC" ("PA_MEASURECALC_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","SELECTCLAUSE","WHERECLAUSE","DATECOLUMN","ORGCOLUMN","BPARTNERCOLUMN","PRODUCTCOLUMN","AD_TABLE_ID","KEYCOLUMN","ENTITYTYPE") values (105,0,0,'Y',to_date('01.01.06','DD.MM.RR'),100,to_date('01.01.06','DD.MM.RR'),100,'Open Invoice Amount','Open Invoice Amount  in Accounting Currency','SELECT COALESCE(SUM(currencyBase(invoiceOpen(C_Invoice_ID, C_InvoicePaySchedule_ID),C_Currency_ID, DateAcct, AD_Client_ID, AD_Org_ID)),0)
FROM C_Invoice_v C_Invoice','WHERE IsSOTrx=''Y'' AND Processed=''Y''','DateInvoiced','AD_Org_ID','C_BPartner_ID',null,318,'C_Invoice_ID','D');


  ALTER TABLE "PA_MEASURE" 
  ADD (	"PA_BENCHMARK_ID" NUMBER(10,0), 
	"PA_RATIO_ID" NUMBER(10,0), 
	"PA_HIERARCHY_ID" NUMBER(10,0), 
	"MEASUREDATATYPE" CHAR(1 BYTE) NOT NULL ENABLE, 
	"R_REQUESTTYPE_ID" NUMBER(10,0), 
	"C_PROJECTTYPE_ID" NUMBER(10,0)
   ) ;
   
 ALTER TABLE  "PA_MEASURE"
 ADD CONSTRAINT  "PABENCHMARK_PAMEASURE" FOREIGN KEY ("PA_BENCHMARK_ID")
   	  REFERENCES "PA_BENCHMARK" ("PA_BENCHMARK_ID"); 
 ALTER TABLE  "PA_MEASURE"
 ADD CONSTRAINT "PAHIERARCHY_PAMEASURE" FOREIGN KEY ("PA_HIERARCHY_ID")
   	  REFERENCES "PA_HIERARCHY" ("PA_HIERARCHY_ID");  
 ALTER TABLE  "PA_MEASURE"
 ADD CONSTRAINT "PARATIO_PAMEASURE" FOREIGN KEY ("PA_RATIO_ID")
	  REFERENCES "PA_RATIO" ("PA_RATIO_ID");
   
/* INSERTING into PA_MEASURE */
Insert into "PA_MEASURE" ("PA_MEASURE_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","MEASURETYPE","MANUALACTUAL","MANUALNOTE","CALCULATIONCLASS","PA_MEASURECALC_ID","PA_BENCHMARK_ID","PA_RATIO_ID","PA_HIERARCHY_ID","MEASUREDATATYPE","R_REQUESTTYPE_ID","C_PROJECTTYPE_ID") values (102,11,0,'Y',to_date('01.01.06','DD.MM.RR'),100,to_date('01.01.06','DD.MM.RR'),100,'Open Invoice Amount',null,'C',0,null,null,105,null,null,null,'S',null,null);
Insert into "PA_MEASURE" ("PA_MEASURE_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","MEASURETYPE","MANUALACTUAL","MANUALNOTE","CALCULATIONCLASS","PA_MEASURECALC_ID","PA_BENCHMARK_ID","PA_RATIO_ID","PA_HIERARCHY_ID","MEASUREDATATYPE","R_REQUESTTYPE_ID","C_PROJECTTYPE_ID") values (103,11,0,'Y',to_date('20.01.06','DD.MM.RR'),100,to_date('20.01.06','DD.MM.RR'),100,'Service Requests (Time)',null,'Q',0,null,null,null,null,null,null,'T',101,null);
Insert into "PA_MEASURE" ("PA_MEASURE_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","MEASURETYPE","MANUALACTUAL","MANUALNOTE","CALCULATIONCLASS","PA_MEASURECALC_ID","PA_BENCHMARK_ID","PA_RATIO_ID","PA_HIERARCHY_ID","MEASUREDATATYPE","R_REQUESTTYPE_ID","C_PROJECTTYPE_ID") values (104,11,0,'Y',to_date('20.01.06','DD.MM.RR'),100,to_date('20.01.06','DD.MM.RR'),100,'Service Requests (Status)',null,'Q',0,null,null,null,null,null,null,'S',101,null);
Insert into "PA_MEASURE" ("PA_MEASURE_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","NAME","DESCRIPTION","MEASURETYPE","MANUALACTUAL","MANUALNOTE","CALCULATIONCLASS","PA_MEASURECALC_ID","PA_BENCHMARK_ID","PA_RATIO_ID","PA_HIERARCHY_ID","MEASUREDATATYPE","R_REQUESTTYPE_ID","C_PROJECTTYPE_ID") values (101,11,0,'Y',to_date('25.12.05','DD.MM.RR'),100,to_date('26.12.05','DD.MM.RR'),101,'Invoices Gross Revenue',null,'C',0,null,null,101,null,null,null,'T',null,null);

   


  ALTER TABLE "PA_GOAL" 
  ADD  (	"AD_USER_ID" NUMBER(10,0), 
	"PA_COLORSCHEMA_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"PA_GOALPARENT_ID" NUMBER(10,0), 
	"MEASURESCOPE" CHAR(1 BYTE) NOT NULL ENABLE, 
	"MEASUREDISPLAY" CHAR(1 BYTE), 
	"DATEFROM" DATE, 
	"DATETO" DATE, 
	"AD_ROLE_ID" NUMBER(10,0)
   ) ;
   
   ALTER TABLE  "PA_GOAL" 
    ADD CONSTRAINT "ADUSER_PAGOAL" FOREIGN KEY ("AD_USER_ID")
	  REFERENCES "AD_USER" ("AD_USER_ID");
	  
ALTER TABLE  "PA_GOAL" 
    ADD CONSTRAINT "PACOLORSCHEMA_PAGOAL" FOREIGN KEY ("PA_COLORSCHEMA_ID")
	  REFERENCES "PA_COLORSCHEMA" ("PA_COLORSCHEMA_ID");
	  
ALTER TABLE  "PA_GOAL" 
    ADD CONSTRAINT "PAGOALPARENT_PAGOAL" FOREIGN KEY ("PA_GOALPARENT_ID")
	  REFERENCES "PA_GOAL" ("PA_GOAL_ID");
	  
	  
/* INSERTING into PA_GOAL */
Insert into "PA_GOAL" ("PA_GOAL_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","SEQNO","NAME","DESCRIPTION","NOTE","AD_USER_ID","PA_COLORSCHEMA_ID","ISSUMMARY","PA_GOALPARENT_ID","PA_MEASURE_ID","RELATIVEWEIGHT","MEASURETARGET","MEASURESCOPE","MEASUREDISPLAY","DATEFROM","DATETO","MEASUREACTUAL","GOALPERFORMANCE","DATELASTRUN","AD_ROLE_ID") values (101,11,0,'Y',to_date('23.12.05','DD.MM.RR'),100,to_date('11.02.06','DD.MM.RR'),100,0,'Invoice Revenue','100k in Revenue',null,null,100,'N',null,101,1,100000,'1','5',null,null,0,0,to_date('11.02.06','DD.MM.RR'),null);
Insert into "PA_GOAL" ("PA_GOAL_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","SEQNO","NAME","DESCRIPTION","NOTE","AD_USER_ID","PA_COLORSCHEMA_ID","ISSUMMARY","PA_GOALPARENT_ID","PA_MEASURE_ID","RELATIVEWEIGHT","MEASURETARGET","MEASURESCOPE","MEASUREDISPLAY","DATEFROM","DATETO","MEASUREACTUAL","GOALPERFORMANCE","DATELASTRUN","AD_ROLE_ID") values (102,11,0,'Y',to_date('01.01.06','DD.MM.RR'),100,to_date('11.02.06','DD.MM.RR'),100,0,'Open Invoices','Open Invoices max $1000',null,null,101,'N',null,102,1,1000,'0','5',null,null,412.85,0.41285,to_date('11.02.06','DD.MM.RR'),null);
Insert into "PA_GOAL" ("PA_GOAL_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","SEQNO","NAME","DESCRIPTION","NOTE","AD_USER_ID","PA_COLORSCHEMA_ID","ISSUMMARY","PA_GOALPARENT_ID","PA_MEASURE_ID","RELATIVEWEIGHT","MEASURETARGET","MEASURESCOPE","MEASUREDISPLAY","DATEFROM","DATETO","MEASUREACTUAL","GOALPERFORMANCE","DATELASTRUN","AD_ROLE_ID") values (104,11,0,'Y',to_date('20.01.06','DD.MM.RR'),100,to_date('11.02.06','DD.MM.RR'),100,0,'Service Requests (Quarter)','Open Service Requests in Time',null,null,101,'N',null,103,1,10,'3',null,null,null,0,0,to_date('11.02.06','DD.MM.RR'),null);
Insert into "PA_GOAL" ("PA_GOAL_ID","AD_CLIENT_ID","AD_ORG_ID","ISACTIVE","CREATED","CREATEDBY","UPDATED","UPDATEDBY","SEQNO","NAME","DESCRIPTION","NOTE","AD_USER_ID","PA_COLORSCHEMA_ID","ISSUMMARY","PA_GOALPARENT_ID","PA_MEASURE_ID","RELATIVEWEIGHT","MEASURETARGET","MEASURESCOPE","MEASUREDISPLAY","DATEFROM","DATETO","MEASUREACTUAL","GOALPERFORMANCE","DATELASTRUN","AD_ROLE_ID") values (105,11,0,'Y',to_date('20.01.06','DD.MM.RR'),100,to_date('11.02.06','DD.MM.RR'),100,0,'Total Open Service Requests','Open Service Requests by Status',null,null,101,'N',null,104,1,10,'0',null,null,null,1,0.1,to_date('11.02.06','DD.MM.RR'),null);
	  
	  

/* BEWARE ALL ENTRIES IN T_INVENTORYVALUE ARE DELETED*/
DELETE FROM "T_INVENTORYVALUE";

 ALTER TABLE "T_INVENTORYVALUE" 
 ADD  (	"M_ATTRIBUTESETINSTANCE_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"COST" NUMBER DEFAULT 0, 
	"COSTAMT" NUMBER DEFAULT 0, 
	"M_COSTELEMENT_ID" NUMBER(10,0));
	
	ALTER TABLE  "T_INVENTORYVALUE" 
    ADD CONSTRAINT "MASI_TINVENTORYVALUE" FOREIGN KEY ("M_ATTRIBUTESETINSTANCE_ID")
	  REFERENCES "M_ATTRIBUTESETINSTANCE" ("M_ATTRIBUTESETINSTANCE_ID");
	  
	 ALTER TABLE  "T_INVENTORYVALUE" 
    ADD CONSTRAINT "MCOSTELEMENT_TINVENTORYVALUE" FOREIGN KEY ("M_COSTELEMENT_ID")
	  REFERENCES "M_COSTELEMENT" ("M_COSTELEMENT_ID");
	 



ALTER TABLE "T_INVOICEGL" 
ADD   (	"GRANDTOTAL" NUMBER DEFAULT 0 NOT NULL ENABLE, 
	"OPENAMT" NUMBER DEFAULT 0 NOT NULL ENABLE, 
	"PERCENT" NUMBER, 
	"AMTSOURCEBALANCE" NUMBER DEFAULT 0 NOT NULL ENABLE, 
	"AMTACCTBALANCE" NUMBER DEFAULT 0 NOT NULL ENABLE, 
	"C_DOCTYPEREVAL_ID" NUMBER(10,0), 
	"ISALLCURRENCIES" CHAR(1 BYTE) DEFAULT 'N' NOT NULL ENABLE);
	
ALTER TABLE "T_INVOICEGL" 
ADD CONSTRAINT "CDOCTYPE_TINVOICEGL" FOREIGN KEY ("C_DOCTYPEREVAL_ID")
	  REFERENCES "C_DOCTYPE" ("C_DOCTYPE_ID");
	

COMMENT ON TABLE "T_INVOICEGL"  IS 'The real data displayed in T_InvoiceGL_v';
 

 ALTER TABLE "A_ASSET" 
 ADD  (	"LASTMAINTENENCEDATE" DATE, 
	"NEXTMAINTENENCEDATE" DATE DEFAULT NULL, 
	"LASTMAINTENANCEUSEUNIT" NUMBER(10,0), 
	"NEXTMAINTENANCEUSEUNIT" NUMBER(10,0), 
	"LEASETERMINATIONDATE" DATE DEFAULT NULL, 
	"LEASE_BPARTNER_ID" NUMBER(10,0) DEFAULT NULL, 
	"LASTMAINTENANCENOTE" NVARCHAR2(60) DEFAULT NULL, 
	"LASTMAINTENANCEDATE" DATE DEFAULT NULL, 
	"LASTMAINTENANCEUNIT" NUMBER(10,0) DEFAULT NULL, 
	"NEXTMAINTENENCEUNIT" NUMBER(10,0) DEFAULT NULL);



 ALTER TABLE "C_VALIDCOMBINATION" 
 ADD  (	"C_SUBACCT_ID" NUMBER(10,0), 
	"USERELEMENT1_ID" NUMBER(10,0), 
	"USERELEMENT2_ID" NUMBER(10,0)   ) ;
 
 
DROP INDEX "C_VALIDCOMBINATION_ALT";

  CREATE UNIQUE INDEX "C_VALIDCOMBINATION_ALT" ON "C_VALIDCOMBINATION" ("C_ACCTSCHEMA_ID", "AD_ORG_ID", "ACCOUNT_ID", "C_SUBACCT_ID", "M_PRODUCT_ID", "C_BPARTNER_ID", "AD_ORGTRX_ID", "C_LOCFROM_ID", "C_LOCTO_ID", "C_SALESREGION_ID", "C_PROJECT_ID", "C_CAMPAIGN_ID", "C_ACTIVITY_ID", "USER1_ID", "USER2_ID", "USERELEMENT1_ID", "USERELEMENT2_ID") 
  ;
 

ALTER TABLE "FACT_ACCT" 
ADD   (	"C_SUBACCT_ID" NUMBER(10,0), 
	"USERELEMENT1_ID" NUMBER(10,0), 
	"USERELEMENT2_ID" NUMBER(10,0)) ;
 

 ALTER TABLE "I_BPARTNER" 
 ADD  (	"R_INTERESTAREA_ID" NUMBER(10,0), 
	"INTERESTAREANAME" NVARCHAR2(40)) ;


ALTER TABLE "M_MATCHINV" 
ADD   (	"DESCRIPTION" NVARCHAR2(255)) ;


  ALTER TABLE "M_MATCHPO" 
  ADD (	"PRICEMATCHDIFFERENCE" NUMBER, 
	"ISAPPROVED" CHAR(1 BYTE) DEFAULT 'Y', 
	"DESCRIPTION" NVARCHAR2(255)) ;

/* REPLACE_ME: set 1000017 to your clients C_DOCTYPE_ID for Purchase Requisition */
/* find it by: select C_DOCTYPE_ID from C_DOCTYPE where name='Purchase Requisition' and AD_Client_ID!=11; */

  ALTER TABLE "M_REQUISITION" 
  ADD (	"C_DOCTYPE_ID" NUMBER(10,0) DEFAULT 1000017 NOT NULL ) ;
  
  ALTER TABLE "M_REQUISITION" 
  MODIFY "C_DOCTYPE_ID" NUMBER(10,0) DEFAULT NULL NULL;
  
  ALTER TABLE "M_REQUISITION" 
  MODIFY "C_DOCTYPE_ID" NUMBER(10,0) NOT NULL;


 ALTER TABLE "M_REQUISITIONLINE" 
 ADD  (	"C_CHARGE_ID" NUMBER(10,0)) ;




 ALTER TABLE "R_REQUEST" 
 ADD  (	"TASKSTATUS" CHAR(1 BYTE), 
	"QTYPLAN" NUMBER, 
	"DATECOMPLETEPLAN" DATE, 
	"DATESTARTPLAN" DATE, 
	"M_FIXCHANGENOTICE_ID" NUMBER(10,0) ) ; 
	 
	 
ALTER TABLE "R_REQUEST" 
 ADD	 CONSTRAINT "MFIXCHANGENOTICE_RREQUEST" FOREIGN KEY ("M_FIXCHANGENOTICE_ID")
	  REFERENCES "M_CHANGENOTICE" ("M_CHANGENOTICE_ID");
	 


ALTER TABLE "R_REQUESTACTION" 
 ADD  (	"TASKSTATUS" CHAR(1 BYTE), 
	"DATECOMPLETEPLAN" DATE, 
	"QTYPLAN" NUMBER, 
	"QTYSPENT" NUMBER, 
	"STARTDATE" DATE, 
	"ENDDATE" DATE, 
	"DATESTARTPLAN" DATE, 
	"QTYINVOICED" NUMBER, 
	"M_PRODUCTSPENT_ID" NUMBER(10,0));
	
	

/* REPLACE_ME: set 100 to your clients default R_STATUSCATEGORY_ID should be 100 and can be changed later by sql anyway*/

  ALTER TABLE "R_REQUESTTYPE" 
  ADD (	"R_STATUSCATEGORY_ID" NUMBER(10,0) DEFAULT 100 NOT NULL) ;
  
  ALTER TABLE "R_REQUESTTYPE" 
  MODIFY (	"R_STATUSCATEGORY_ID" NUMBER(10,0) DEFAULT NULL NULL) ;
  
  ALTER TABLE "R_REQUESTTYPE" 
  MODIFY (	"R_STATUSCATEGORY_ID" NUMBER(10,0) NOT NULL) ;


/* REPLACE_ME: set 100 to your clients default R_STATUSCATEGORY_ID */
  ALTER TABLE "R_STATUS" 
  ADD (	"SEQNO" NUMBER(10,0) DEFAULT 0 NOT NULL, 
	"R_STATUSCATEGORY_ID" NUMBER(10,0) DEFAULT 100 NOT NULL ) ;
	
  ALTER TABLE "R_STATUS" 
  MODIFY (	"R_STATUSCATEGORY_ID" NUMBER(10,0) DEFAULT NULL NULL) ;
  
  ALTER TABLE "R_STATUS" 
  MODIFY (	"R_STATUSCATEGORY_ID" NUMBER(10,0) NOT NULL) ;	
  


  ALTER TABLE "C_BP_GROUP" 
  ADD (	"M_PRICELIST_ID" NUMBER(10,0), 
	"PO_PRICELIST_ID" NUMBER(10,0), 
	"M_DISCOUNTSCHEMA_ID" NUMBER(10,0), 
	"PO_DISCOUNTSCHEMA_ID" NUMBER(10,0), 
	"CREDITWATCHPERCENT" NUMBER, 
	"PRICEMATCHTOLERANCE" NUMBER);
	
	 
ALTER TABLE "C_BP_GROUP" 
  ADD	 CONSTRAINT "MDISCOUNTSCHEMAPO_CBPGROUP" FOREIGN KEY ("PO_DISCOUNTSCHEMA_ID")
	  REFERENCES "M_DISCOUNTSCHEMA" ("M_DISCOUNTSCHEMA_ID") ON DELETE SET NULL;
	  
ALTER TABLE "C_BP_GROUP" 
  ADD	 CONSTRAINT "MDISCOUNTSCHEMA_CBPGROUP" FOREIGN KEY ("M_DISCOUNTSCHEMA_ID")
	  REFERENCES "M_DISCOUNTSCHEMA" ("M_DISCOUNTSCHEMA_ID") ON DELETE SET NULL; 
	  
	  
ALTER TABLE "C_BP_GROUP" 
  ADD	 CONSTRAINT "MPRICELISTPO_CBPGROUP" FOREIGN KEY ("PO_PRICELIST_ID")
	  REFERENCES "M_PRICELIST" ("M_PRICELIST_ID") ON DELETE SET NULL;
	  
ALTER TABLE "C_BP_GROUP" 
  ADD	 CONSTRAINT "MPRICELIST_CBPGROUP" FOREIGN KEY ("M_PRICELIST_ID")
	  REFERENCES "M_PRICELIST" ("M_PRICELIST_ID") ON DELETE SET NULL;



  ALTER TABLE "C_CHARGE" 
  ADD (	"C_BPARTNER_ID" NUMBER(10,0));
  

 ALTER TABLE "AD_USER" 
  ADD (	"CONNECTIONPROFILE" CHAR(1 BYTE)) ;


  ALTER TABLE "AD_WF_NODE" 
  ADD (	"EMAILRECIPIENT" CHAR(1 BYTE), 
	"EMAIL" NVARCHAR2(60), 
	"R_MAILTEXT_ID" NUMBER(10,0)) ;


ALTER TABLE "C_ACCTSCHEMA_ELEMENT" 
 ADD  (	"AD_COLUMN_ID" NUMBER(10,0)) ;

  ALTER TABLE "A_ASSET_GROUP" 
  ADD (	"ISTRACKISSUES" CHAR(1 BYTE) DEFAULT 'N' NOT NULL ) ;


  ALTER TABLE "AD_PRINTPAPER" 
  ADD (	"SIZEX" NUMBER DEFAULT NULL, 
	"SIZEY" NUMBER DEFAULT NULL, 
	"DIMENSIONUNITS" CHAR(1 BYTE)) ;

  ALTER TABLE "AD_ROLE" 
  ADD (	"CONNECTIONPROFILE" CHAR(1 BYTE)) ;

   
  ALTER TABLE "AD_SYSTEM" 
   ADD ("ISAUTOERRORREPORT" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL, 
 	"RECORD_ID" NUMBER(10,0), 
 	"SUPPORTEXPDATE" DATE, 
 	"PROCESSING" CHAR(1 BYTE), 
 	"SUPPORTEMAIL" NVARCHAR2(60), 
 	"ISALLOWSTATISTICS" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL, 
 	"STATISTICSINFO" NVARCHAR2(60), 
 	"PROFILEINFO" NVARCHAR2(60), 
 	"OLDNAME" NVARCHAR2(60), 
 	"DESCRIPTION" NVARCHAR2(255), 
 	"SYSTEMSTATUS" CHAR(1 BYTE) DEFAULT 'E' NOT NULL   ) ;
 
 COMMIT;
 
