-- POSTGRESQL Changes

ALTER TABLE C_Invoice ADD M_RMA_ID NUMERIC(10) DEFAULT NULL;

ALTER TABLE C_InvoiceLine ADD M_RMALine_ID NUMERIC(10,0) DEFAULT NULL;

ALTER TABLE M_InOut ADD M_RMA_ID NUMERIC(10,0) DEFAULT NULL;

ALTER TABLE M_InOutLine ADD M_RMALine_ID NUMERIC(10,0) DEFAULT NULL;

ALTER TABLE M_RMA ADD IsSOTrx CHAR(1) DEFAULT 'Y' CHECK (IsSOTrx IN ('Y', 'N')) NOT NULL;

ALTER TABLE M_RMA RENAME M_InOut_ID TO InOut_ID;

ALTER TABLE M_RMA ADD GenerateTo CHAR(1) DEFAULT NULL;

ALTER TABLE M_RMALine ADD Amt NUMERIC;

ALTER TABLE M_RMALine ADD C_Charge_ID NUMERIC(10,0);

ALTER TABLE M_RMALine ADD Line NUMERIC(10,0) DEFAULT 0 NOT NULL;

ALTER TABLE M_RMALine ADD LineNetAmt NUMERIC;

ALTER TABLE M_RMALine ADD QtyDelivered NUMERIC;

ALTER TABLE M_RMALine ALTER COLUMN M_InOutLine_ID DROP DEFAULT;

ALTER TABLE M_RMALine ALTER COLUMN M_InOutLine_ID DROP NOT NULL;


-- Constraints

ALTER TABLE C_Invoice ADD CONSTRAINT mrma_cinvoice FOREIGN KEY (M_RMA_ID) REFERENCES M_RMA (M_RMA_ID);

ALTER TABLE C_InvoiceLine ADD CONSTRAINT mrmaline_cinvoiceline FOREIGN KEY (M_RMALine_ID) REFERENCES M_RMALine (M_RMALine_ID);

ALTER TABLE M_InOut ADD CONSTRAINT mrma_minout FOREIGN KEY (M_RMA_ID) REFERENCES M_RMA (M_RMA_ID);

ALTER TABLE M_InOutLine ADD CONSTRAINT mrmaline_minoutline FOREIGN KEY (M_RMALine_ID) REFERENCES M_RMALine (M_RMALine_ID);
