/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.control.pdf;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;

public class Pager
extends HBox {
    private static final double HEIGHT = 25.0;
    private IntegerProperty pageIndexProperty = new SimpleIntegerProperty((Object)this, "pageIndex");
    private IntegerProperty maxPageIndexProperty = new SimpleIntegerProperty((Object)this, "maxPageIndex");
    private Label lblPageNumber = new Label();
    private Button btnFirst;
    private Button btnPrevious;
    private Button btnNext;
    private Button btnLast;

    public IntegerProperty pageIndexProperty() {
        return this.pageIndexProperty;
    }

    public final int getPageIndex() {
        return this.pageIndexProperty.get();
    }

    public final void setPageIndex(int value) {
        this.pageIndexProperty.set(value);
    }

    public IntegerProperty maxPageIndexProperty() {
        return this.maxPageIndexProperty;
    }

    public final int getMaxPageIndex() {
        return this.maxPageIndexProperty.get();
    }

    public Pager() {
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("Pager.css").toExternalForm());
        this.getStyleClass().add((Object)"pager");
        this.btnFirst = new PageButton(new Path(new PathElement[]{new MoveTo(17.5, 7.5), new LineTo(12.5, 12.5), new LineTo(17.5, 17.5), new MoveTo(8.75, 7.5), new LineTo(8.75, 17.5)}), (EventHandler<ActionEvent>)((EventHandler)action -> this.pageIndexProperty.set(0)));
        this.btnPrevious = new PageButton(new Path(new PathElement[]{new MoveTo(17.5, 7.5), new LineTo(12.5, 12.5), new LineTo(17.5, 17.5)}), (EventHandler<ActionEvent>)((EventHandler)action -> this.pageIndexProperty.set(this.pageIndexProperty.get() - 1)));
        this.btnNext = new PageButton(new Path(new PathElement[]{new MoveTo(7.5, 7.5), new LineTo(12.5, 12.5), new LineTo(7.5, 17.5)}), (EventHandler<ActionEvent>)((EventHandler)action -> this.pageIndexProperty.set(this.pageIndexProperty.get() + 1)));
        this.btnLast = new PageButton(new Path(new PathElement[]{new MoveTo(7.5, 7.5), new LineTo(12.5, 12.5), new LineTo(7.5, 17.5), new MoveTo(16.25, 7.5), new LineTo(16.25, 17.5)}), (EventHandler<ActionEvent>)((EventHandler)action -> this.pageIndexProperty.set(this.maxPageIndexProperty.get())));
        this.getChildren().addAll((Object[])new Node[]{this.btnFirst, this.btnPrevious, this.lblPageNumber, this.btnNext, this.btnLast});
        this.pageIndexProperty.addListener((observable, oldValue, newValue) -> this.update());
        this.maxPageIndexProperty.addListener((observable, oldValue, newValue) -> this.update());
    }

    protected void update() {
        if (this.maxPageIndexProperty.get() <= 0) {
            this.lblPageNumber.setText("");
            this.btnFirst.setDisable(true);
            this.btnPrevious.setDisable(true);
            this.btnNext.setDisable(true);
            this.btnLast.setDisable(true);
        } else {
            this.lblPageNumber.setText(this.pageIndexProperty.get() + 1 + " / " + (this.maxPageIndexProperty.get() + 1));
            this.btnFirst.setDisable(this.pageIndexProperty.get() <= 0);
            this.btnPrevious.setDisable(this.pageIndexProperty.get() <= 0);
            this.btnNext.setDisable(this.pageIndexProperty.get() == this.maxPageIndexProperty.get());
            this.btnLast.setDisable(this.pageIndexProperty.get() == this.maxPageIndexProperty.get());
        }
    }

    public void moveFirst() {
        this.btnFirst.fire();
    }

    public void movePrevious() {
        this.btnPrevious.fire();
    }

    public void moveNext() {
        this.btnNext.fire();
    }

    public void moveLast() {
        this.btnLast.fire();
    }

    public Map<KeyCombination, Runnable> createDefaultAccelerators() {
        HashMap<KeyCombination, Runnable> accelerators = new HashMap<KeyCombination, Runnable>();
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[0]), () -> this.moveFirst());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.PAGE_UP, new KeyCombination.Modifier[0]), () -> this.movePrevious());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[0]), () -> this.movePrevious());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.KP_UP, new KeyCombination.Modifier[0]), () -> this.movePrevious());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[0]), () -> this.movePrevious());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.KP_LEFT, new KeyCombination.Modifier[0]), () -> this.movePrevious());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.PAGE_DOWN, new KeyCombination.Modifier[0]), () -> this.moveNext());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[0]), () -> this.moveNext());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.KP_DOWN, new KeyCombination.Modifier[0]), () -> this.moveNext());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[0]), () -> this.moveNext());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.KP_RIGHT, new KeyCombination.Modifier[0]), () -> this.moveNext());
        accelerators.put((KeyCombination)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[0]), () -> this.moveLast());
        return accelerators;
    }

    private class PageButton
    extends Button {
        public PageButton(Path path, EventHandler<ActionEvent> action) {
            this.setMinHeight(25.0);
            this.setPrefHeight(25.0);
            this.setDisable(true);
            this.setFocusTraversable(false);
            path.strokeProperty().bind((ObservableValue)this.textFillProperty());
            path.setStrokeWidth(1.2);
            path.setStrokeLineCap(StrokeLineCap.ROUND);
            path.setStrokeLineJoin(StrokeLineJoin.ROUND);
            this.setGraphic((Node)path);
            this.setOnAction(action);
        }
    }
}

