/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javafx.concurrent.Task;
import net.osdn.util.javafx.concurrent.AsyncCallable;
import net.osdn.util.javafx.concurrent.AsyncRunnable;
import net.osdn.util.javafx.concurrent.AsyncWrappedException;
import net.osdn.util.javafx.event.SilentRunnable;

public class Async<V>
implements AsyncRunnable,
AsyncCallable<V> {
    private static ThreadFactory defaultThreadFactory;
    private static Executor executor;
    private Task<V> task;
    private Cancel cancel;
    private AsyncRunnable.Success runnableSuccess;
    private AsyncCallable.Success<V> callableSuccess;
    private Failure failure;
    private Complete complete;

    public static ThreadFactory getDefaultThreadFactory() {
        return defaultThreadFactory;
    }

    public static void setDefaultThreadFactory(ThreadFactory factory) {
        defaultThreadFactory = factory;
        executor = null;
    }

    public static Executor getExecutor() {
        if (executor == null) {
            ThreadFactory factory = Async.getDefaultThreadFactory();
            if (factory == null) {
                factory = new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r);
                        thread.setDaemon(true);
                        return thread;
                    }
                };
            }
            executor = Executors.newCachedThreadPool(factory);
        }
        return executor;
    }

    public static void setExecutor(Executor executor) {
        Async.executor = executor;
    }

    public static AsyncRunnable execute(SilentRunnable runnable) {
        Async<Void> async = new Async<Void>(() -> {
            runnable.run();
            return null;
        });
        Async.getExecutor().execute((Runnable)async.task);
        return async;
    }

    public static <V> AsyncCallable<V> execute(Callable<V> callable) {
        Async<V> async = new Async<V>(callable);
        Async.getExecutor().execute((Runnable)async.task);
        return async;
    }

    private Async(final Callable<V> callable) {
        this.task = new Task<V>(){

            protected V call() throws Exception {
                return callable.call();
            }

            protected void cancelled() {
                Async.this.cancelled();
            }

            protected void succeeded() {
                Async.this.succeeded();
            }

            protected void failed() {
                Async.this.failed();
            }
        };
    }

    protected void cancelled() {
        block13: {
            Exception exception = null;
            try {
                if (this.cancel != null) {
                    this.cancel.onCancelled();
                }
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                block14: {
                    if (this.complete != null) {
                        try {
                            this.complete.onCompleted(State.CANCELLED);
                        }
                        catch (Exception e) {
                            if (exception != null) break block14;
                            exception = e;
                        }
                    }
                }
                if (exception == null) break block13;
                throw new AsyncWrappedException(exception);
            }
        }
    }

    protected void succeeded() {
        block15: {
            Exception exception = null;
            try {
                if (this.runnableSuccess != null) {
                    this.runnableSuccess.onSucceeded();
                } else if (this.callableSuccess != null) {
                    this.callableSuccess.onSucceeded(this.task.getValue());
                }
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                block16: {
                    if (this.complete != null) {
                        try {
                            this.complete.onCompleted(State.SUCCEEDED);
                        }
                        catch (Exception e) {
                            if (exception != null) break block16;
                            exception = e;
                        }
                    }
                }
                if (exception == null) break block15;
                throw new AsyncWrappedException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failed() {
        block15: {
            Throwable t = this.task.getException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            Exception exception = null;
            try {
                if (this.failure != null) {
                    this.failure.onFailed((Exception)t);
                } else {
                    exception = (Exception)t;
                }
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                block16: {
                    if (this.complete != null) {
                        try {
                            this.complete.onCompleted(State.FAILED);
                        }
                        catch (Exception e) {
                            if (exception != null) break block16;
                            exception = e;
                        }
                    }
                }
                if (exception == null) break block15;
                throw new AsyncWrappedException(exception);
            }
        }
    }

    public Task<V> getTask() {
        return this.task;
    }

    @Override
    public Async<V> onCancelled(Cancel callback) {
        this.cancel = callback;
        return this;
    }

    @Override
    public Async<V> onSucceeded(AsyncRunnable.Success callback) {
        this.callableSuccess = null;
        this.runnableSuccess = callback;
        return this;
    }

    @Override
    public Async<V> onSucceeded(AsyncCallable.Success<V> callback) {
        this.runnableSuccess = null;
        this.callableSuccess = callback;
        return this;
    }

    @Override
    public Async<V> onFailed(Failure callback) {
        this.failure = callback;
        return this;
    }

    @Override
    public Async<V> onCompleted(Complete callback) {
        this.complete = callback;
        return this;
    }

    @FunctionalInterface
    public static interface Complete {
        public void onCompleted(State var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Failure {
        public void onFailed(Exception var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Cancel {
        public void onCancelled() throws Exception;
    }

    public static enum State {
        CANCELLED,
        SUCCEEDED,
        FAILED;

    }
}

