/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import net.osdn.util.javafx.event.SilentWrappedException;

@FunctionalInterface
public interface SilentChangeListener<T> {
    public void changed(ObservableValue<? extends T> var1, T var2, T var3) throws Exception;

    public static <T> ChangeListener<T> wrap(SilentChangeListener<T> listener) {
        return (observable, oldValue, newValue) -> {
            try {
                listener.changed(observable, oldValue, newValue);
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                    return;
                }
                throw new SilentWrappedException(e);
            }
        };
    }
}

