#
#  The pkgbuild build engine
#
#  Copyright (C) 2004, 2005 Sun Microsystems, Inc.
#
#  pkgbuild is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License 
#  version 2 published by the Free Software Foundation.
#
#  pkgbuild is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#  As a special exception to the GNU General Public License, if you
#  distribute this file as part of a program that contains a
#  configuration script generated by Autoconf, you may include it under
#  the same distribution terms that you use for the rest of that program.
#
#  Authors:  Laszlo Peter  <laca@sun.com>
#

use strict;
use warnings;
use rpm_package;

package packagebase;

my $packagebase;

sub new ($) {
    my $class = shift;

    $packagebase ||= bless {}, $class;
}

sub add_package ($) {
    my $self = shift;
    my $package = shift;

    if (not defined ($self->{_all_packages})) {
	my @arr;
	$self->{_all_packages} = \@arr;
    }
    my $ref = $self->{_all_packages};
    push (@$ref, \$package);
}

sub find_package_by_name ($) {
    my $self = shift;
    my $name = shift;

    my $ref = $self->{_all_packages};
    foreach my $package (@$ref) {
	if ($$package->get_tag ("name") eq $name) {
	    return $$package;
	}
    }
    return undef;
}

sub add_spec ($) {
    my $self = shift;
    my $spec = shift;

    if (not defined ($self->{_all_specs})) {
	my @arr;
	$self->{_all_specs} = \@arr;
    }
    my $ref = $self->{_all_specs};
    push (@$ref, \$spec);
}

sub find_spec_by_file_name ($) {
    my $self = shift;
    my $fname = shift;

    my $ref = $self->{_all_specs};
    foreach my $spec (@$ref) {
	if ($$spec->get_file_name () eq $fname) {
	    return $$spec;
	}
    }
    return undef;
}

sub find_spec_by_base_name ($) {
    my $self = shift;
    my $fname = shift;

    my $ref = $self->{_all_specs};
    foreach my $spec (@$ref) {
	if ($$spec->get_base_file_name () eq $fname) {
	    return $$spec;
	}
    }
    return undef;
}

1;
