/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.tools.propedit;

import com.mylyane.afx.IApplication;
import com.mylyane.afx.IDomain;
import com.mylyane.afx.IProvider;
import com.mylyane.afx.plugin.IPlugin;
import com.mylyane.afx.plugin.IPluginManager;
import com.mylyane.afx.plugin.PluginLoader;
import com.mylyane.net.URLUtility;
import com.mylyane.tools.propedit.Main;
import com.mylyane.tools.propedit.afx.DomainProviders;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public final class PropertiesEditorAppDomain
implements IDomain {
    private static IDomain SINGLETON;
    private Main main;
    private PluginLoader plugin_loader = new PluginLoader(this.getClass().getClassLoader());
    private boolean b_app_active;

    public static IDomain GetInstance() {
        if (SINGLETON == null) {
            SINGLETON = new PropertiesEditorAppDomain();
        }
        return SINGLETON;
    }

    public static void main(String[] stringArray) throws Exception {
        IDomain iDomain = PropertiesEditorAppDomain.GetInstance();
        if (iDomain.initializeDomain()) {
            iDomain.getApplication().runApplication();
        }
    }

    private PropertiesEditorAppDomain() {
    }

    private synchronized void loadDefaultPlugins() {
        URL uRL;
        if (!this.b_app_active) {
            throw new RuntimeException("Application not active.");
        }
        Class<?> clazz = super.getClass();
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = string.substring(0, n + 1).concat("plugins");
        try {
            uRL = new URL(URLUtility.GetPhysicalParentURL(clazz), "plugins");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            uRL = null;
        }
        if (uRL == null) {
            this.main.showStatus("!Internal error: findPlugins");
            return;
        }
        n = this.plugin_loader.findPlugin(uRL, string);
        if (n > 0) {
            IPluginManager iPluginManager = this.plugin_loader.getPluginManager();
            Enumeration enumeration = iPluginManager.enumPlugin();
            while (enumeration.hasMoreElements()) {
                IPlugin iPlugin = (IPlugin)enumeration.nextElement();
                if (!iPlugin.initialize((IDomain)this)) {
                    --n;
                    continue;
                }
                this.main.showStatus("Loaded :" + iPlugin.getPluginName());
                this.main.acceptPlugin(iPlugin);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.main.showStatus("Loaded plugins :" + n);
        }
    }

    public synchronized IProvider getProvider(IProvider.ProviderID providerID) {
        if (this.b_app_active) {
            if (providerID == DomainProviders.TREE_PROVIDER) {
                return this.main.treePane;
            }
            if (providerID == DomainProviders.UNI_PROVIDER) {
                return this.main.pprovider;
            }
            if (providerID == DomainProviders.TREE_ROOT_UI_PROVIDER) {
                return this.main.treePane;
            }
            if (providerID == DomainProviders.TEXTEDTOR_ROOT_UI_PROVIDER) {
                return this.main.getTextComponentPane(0);
            }
        }
        return null;
    }

    public synchronized IApplication getApplication() {
        return this.main;
    }

    public synchronized boolean initializeDomain() {
        if (!this.b_app_active) {
            this.b_app_active = true;
            this.main = (Main)Main.GetInstance();
            this.main.setBelongingDomain(this);
            new Thread("PropertiesEditorApp-PluginLoader"){

                public final void run() {
                    PropertiesEditorAppDomain.this.main.showStatus("Loading plugins..");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    PropertiesEditorAppDomain.this.loadDefaultPlugins();
                }
            }.start();
            return true;
        }
        throw new UnsupportedOperationException("app instance already exists");
    }

    public synchronized void finalizeDomain() {
        if (this.main != null) {
            this.main.setVisible(false);
            this.main.dispose();
            this.main.setBelongingDomain(null);
            this.main = null;
            this.plugin_loader.removeAll();
            this.b_app_active = false;
        }
    }
}

