/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.tools.propedit;

import com.mylyane.tools.propedit.IDocumentManipulator;
import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.UndoableEdit;

class PropertiesEditorKit
extends StyledEditorKit {
    public static final String PROPERTIES_STYLE_COMMENT = "prop_comment";
    public static final String PROPERTIES_STYLE_KEY = "prop_key";
    public static final String PROPERTIES_STYLE_VALUE = "prop_value";
    public static final String[] LINE_STYLE_SET = new String[]{"prop_key", "default", "prop_value"};
    private DefaultStyledDocument doc;
    private StyleContext styles = new StyleContext();

    public PropertiesEditorKit() {
        this.initStyles();
    }

    public StyledDocument getStyledDocument() {
        return this.doc;
    }

    public Document createDefaultDocument() {
        this.doc = new X(this.styles);
        return this.doc;
    }

    public IDocumentManipulator getDocumentManipulator() {
        return (IDocumentManipulator)((Object)this.doc);
    }

    private void initStyles() {
        Style style = this.styles.getStyle("default");
        Style style2 = this.styles.addStyle(PROPERTIES_STYLE_COMMENT, style);
        StyleConstants.setForeground(style2, Color.red);
        StyleConstants.setFontFamily(style2, "SansSerif");
        StyleConstants.setSpaceAbove(style2, 0.0f);
        StyleConstants.setSpaceBelow(style2, 0.0f);
        StyleConstants.setAlignment(style2, 0);
        style2 = this.styles.addStyle(PROPERTIES_STYLE_KEY, style);
        StyleConstants.setBold(style2, true);
        StyleConstants.setForeground(style2, Color.black);
        StyleConstants.setSpaceAbove(style2, 0.0f);
        StyleConstants.setSpaceBelow(style2, 0.0f);
        StyleConstants.setAlignment(style2, 0);
        style2 = this.styles.addStyle(PROPERTIES_STYLE_VALUE, style);
        StyleConstants.setBold(style2, false);
        StyleConstants.setForeground(style2, Color.blue);
        StyleConstants.setSpaceAbove(style2, 0.0f);
        StyleConstants.setSpaceBelow(style2, 0.0f);
    }

    static final class Y
    extends GapContent {
        Y(int n) {
            super(n);
        }

        public UndoableEdit insertString(int n, String string) throws BadLocationException {
            if (n > this.length() || n < 0) {
                throw new BadLocationException("Invalid insert", this.length());
            }
            char[] cArray = string.toCharArray();
            this.replace(n, 0, cArray, cArray.length);
            return null;
        }

        public void insertChars(int n, char[] cArray, int n2) throws BadLocationException {
            if (n > this.length() || n < 0) {
                throw new BadLocationException("Invalid insert", this.length());
            }
            this.replace(n, 0, cArray, n2);
        }
    }

    static final class X
    extends DefaultStyledDocument
    implements IDocumentManipulator {
        private StyleContext styles;
        private Y gap;
        static final char[] LINE_CHARS = new char[]{'\n'};

        X(StyleContext styleContext) {
            super((AbstractDocument.Content)new Y(4096), styleContext);
            this.styles = styleContext;
            this.gap = (Y)this.getContent();
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            this.writeLock();
            this.gap.insertString(n, string);
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, string.length(), DocumentEvent.EventType.INSERT);
            this.insertUpdate(defaultDocumentEvent, attributeSet);
            defaultDocumentEvent.end();
            this.fireInsertUpdate(defaultDocumentEvent);
            this.writeUnlock();
        }

        public void insertChars(int n, char[] cArray, int n2, AttributeSet attributeSet) {
            if (cArray == null || n2 == 0) {
                return;
            }
            this.writeLock();
            try {
                this.gap.insertChars(n, cArray, n2);
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.INSERT);
                this.insertUpdate(defaultDocumentEvent, attributeSet);
                defaultDocumentEvent.end();
                this.fireInsertUpdate(defaultDocumentEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.writeUnlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
            try {
                this.writeLock();
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.CHANGE);
                this.buffer.change(n, n2, defaultDocumentEvent);
                int n3 = Integer.MAX_VALUE;
                int n4 = n;
                while (n4 < n + n2) {
                    Element element = this.getCharacterElement(n4);
                    n3 = element.getEndOffset();
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                    if (bl) {
                        mutableAttributeSet.removeAttributes(mutableAttributeSet);
                    }
                    mutableAttributeSet.addAttributes(attributeSet);
                    n4 = n3;
                }
                defaultDocumentEvent.end();
                this.fireChangedUpdate(defaultDocumentEvent);
            }
            finally {
                this.writeUnlock();
            }
        }

        public void removeAll() {
            try {
                this.remove(0, this.getLength());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void addStringLine(String[] stringArray) {
            int n = stringArray.length;
            String[] stringArray2 = LINE_STYLE_SET;
            try {
                for (int i = 0; i < n; ++i) {
                    this.insertString(this.getLength(), stringArray[i], this.styles.getStyle(stringArray2[i]));
                }
                this.insertString(this.getLength(), "\n", null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void addString(String string, String string2, boolean bl) {
            Style style = string2 == null ? this.styles.getStyle("default") : this.styles.getStyle(string2);
            try {
                this.insertString(this.getLength(), string, style);
                if (bl) {
                    this.insertString(this.getLength(), "\n", null);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void addChars(char[] cArray, int n, String string, boolean bl) {
            Style style = string == null ? this.styles.getStyle("default") : this.styles.getStyle(string);
            this.insertChars(this.getLength(), cArray, n, style);
            if (bl) {
                this.insertChars(this.getLength(), LINE_CHARS, 1, null);
            }
        }

        public void addString(String string) {
            try {
                this.insertString(this.getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }
}

