/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.tools.propedit.afx;

import com.mylyane.afx.IApplication;
import com.mylyane.afx.XApplicationElements;
import com.mylyane.afx.swing.tree.XComparableTreeNode;
import com.mylyane.lang.CharsBuffer;
import com.mylyane.tools.propedit.afx.IConstants;
import com.mylyane.tools.propedit.afx.IPropertiesTreeProvider;
import com.mylyane.tools.propedit.afx.IPropertiesUniversalProvider;
import com.mylyane.tools.propedit.afx.model.IPropertiesModel;
import com.mylyane.tools.propedit.afx.model.PropertiesContext;
import com.mylyane.tools.propedit.afx.model.PropertiesModelManager;
import com.mylyane.util.Utility;
import java.awt.AWTEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public abstract class XPropertiesUniProvider
extends XApplicationElements
implements IPropertiesUniversalProvider,
IConstants {
    protected static final String DEFAULT_NAME = "unknown-";
    protected static final String DEFAULT_DOT_EXTENSION = ".properties";
    protected static int NameCounter = 0;
    protected static final String ALERT_FILE_EXISTS_FMT = "File :\n    [{0}]\nalready {1}. Please make it to another name.\n";
    protected IPropertiesTreeProvider tree_provider;
    protected char current_section_delim;

    protected XPropertiesUniProvider(IApplication iApplication) {
        super(iApplication);
    }

    protected final void markDirty(XComparableTreeNode xComparableTreeNode) {
        if (xComparableTreeNode != null) {
            xComparableTreeNode.setUserFlag(65536);
        }
    }

    protected final void unMarkAll(XComparableTreeNode xComparableTreeNode) {
        if (xComparableTreeNode.getUserFlag() == 0) {
            return;
        }
        xComparableTreeNode.setUserFlag(0);
        if (xComparableTreeNode.getChildCount() == 0) {
            return;
        }
        Enumeration enumeration = xComparableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            XComparableTreeNode xComparableTreeNode2 = (XComparableTreeNode)enumeration.nextElement();
            this.unMarkAll(xComparableTreeNode2);
        }
    }

    protected final boolean isDirty(XComparableTreeNode xComparableTreeNode) {
        return xComparableTreeNode.getUserFlag() == 65536;
    }

    protected final void processAfterEdit(XComparableTreeNode xComparableTreeNode) {
        if (xComparableTreeNode == null) {
            xComparableTreeNode = this.tree_provider.currentSelectedKey();
        }
        if (xComparableTreeNode == null) {
            return;
        }
        this.markDirty(xComparableTreeNode);
        this.markDirty(this.tree_provider.getParentNode(xComparableTreeNode, 2));
        this.markDirty(this.tree_provider.getParentNode(xComparableTreeNode, 1));
    }

    public final void setTreeProvider(IPropertiesTreeProvider iPropertiesTreeProvider) {
        this.tree_provider = iPropertiesTreeProvider;
    }

    public final int getErrorCode(int n) {
        return 0xF0000000 & n;
    }

    public void setSectionDelimiter(char c) {
        this.current_section_delim = c;
    }

    public char getSectionDelimiter() {
        return this.current_section_delim;
    }

    public PropertiesContext getPropertiesContextFrom(XComparableTreeNode xComparableTreeNode) {
        PropertiesContext propertiesContext = null;
        int n = xComparableTreeNode.getNodeType();
        if (n == 3) {
            if ((xComparableTreeNode = (XComparableTreeNode)xComparableTreeNode.getParent()).getNodeType() == 2) {
                xComparableTreeNode = (XComparableTreeNode)xComparableTreeNode.getParent();
            }
            propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
        } else if (n == 2) {
            propertiesContext = (PropertiesContext)((XComparableTreeNode)xComparableTreeNode.getParent()).getUserObject();
        } else if (n == 1) {
            propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
        }
        return propertiesContext;
    }

    public boolean isPropertiesAvailable(XComparableTreeNode xComparableTreeNode) {
        if (xComparableTreeNode == null) {
            return false;
        }
        if (xComparableTreeNode.getNodeType() != 1) {
            throw new UnsupportedOperationException("node is not properties node.");
        }
        PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
        return this.getPropertiesModelManager().isContained(propertiesContext.canonical_name);
    }

    public void unloadProperties(XComparableTreeNode xComparableTreeNode) {
        if (xComparableTreeNode.getNodeType() != 1) {
            return;
        }
        PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
        IPropertiesModel iPropertiesModel = this.removePropertiesModel(propertiesContext.canonical_name);
        if (iPropertiesModel == null) {
            return;
        }
        this.tree_provider.removeNodeFromParent(xComparableTreeNode);
        this.showStatus("File '" + propertiesContext.name + "' closed...");
    }

    public boolean closeAllProperties() {
        boolean bl = this.tree_provider.isRootNodeEmpty();
        if (!bl) {
            Enumeration enumeration = this.tree_provider.getRootNode().children();
            while (enumeration.hasMoreElements()) {
                XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)enumeration.nextElement();
                PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
                IPropertiesModel iPropertiesModel = this.removePropertiesModel(propertiesContext.canonical_name);
                if (iPropertiesModel == null) continue;
                if ((propertiesContext.isUncertain() || propertiesContext.isModified()) && JOptionPane.showConfirmDialog(null, "[" + propertiesContext.name + "] has been changed. Do you preserve it?", "File close.", 0) == 0) {
                    iPropertiesModel.save();
                }
                this.unMarkAll(xComparableTreeNode);
            }
            this.tree_provider.removeChildren(this.tree_provider.getRootNode());
        }
        return !bl;
    }

    public int renameProperties(XComparableTreeNode xComparableTreeNode, String string) {
        int n = 0;
        try {
            PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
            if (propertiesContext.isUncertain()) {
                this.showStatus("This file is uncertain. Please save a file.");
                return 0x30000000;
            }
            if (propertiesContext.isReadOnly()) {
                this.showStatus("This file is readonly.");
                return 0x50000000;
            }
            File file = new File(propertiesContext.canonical_name);
            File file2 = new File(file.getParent(), string);
            if (!file.equals(file2)) {
                if (file2.exists()) {
                    this.alert("File :\n    [" + file2.getAbsolutePath() + "]\n" + "already exists. Please make it to another name.\n");
                } else if (file.renameTo(file2)) {
                    String string2 = propertiesContext.name + " was changed to " + file2.getName();
                    IPropertiesModel iPropertiesModel = this.getPropertiesModel(propertiesContext.canonical_name);
                    propertiesContext.setCanonicalName(file2.getAbsolutePath());
                    iPropertiesModel.setPath(propertiesContext.canonical_name);
                    this.showStatus(string2);
                } else {
                    this.warning("The name was not able to be changed from " + propertiesContext.name + " to " + string + ". " + "It might be a problem of the right of access.");
                    n = -268435456;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public final boolean savePropertiesAs(XComparableTreeNode xComparableTreeNode, String string) {
        PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
        if (string == null && propertiesContext.isReadOnly()) {
            this.showStatus("File \"" + propertiesContext.name + "\" is readonly.");
            return false;
        }
        IPropertiesModel iPropertiesModel = this.getPropertiesModel(propertiesContext.canonical_name);
        if (iPropertiesModel == null) {
            return false;
        }
        if (string != null) {
            iPropertiesModel.setPath(string);
            propertiesContext.setCanonicalName(string);
        }
        if (iPropertiesModel.save()) {
            propertiesContext.setFileState(64);
            this.unMarkAll(xComparableTreeNode);
            return true;
        }
        return false;
    }

    public int createProperties(String string) {
        int n = 0;
        CharsBuffer charsBuffer = CharsBuffer.GetShared((int)300);
        if (string == null) {
            string = charsBuffer.append(DEFAULT_NAME).append(NameCounter++).append(DEFAULT_DOT_EXTENSION).flushToString();
        }
        Object object = null;
        try {
            object = new File(string).getCanonicalFile();
            string = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            n = -268435456;
        }
        if (object != null) {
            if (((File)object).exists()) {
                n |= 1;
            }
            if (this.getPropertiesModelManager().isContained(string)) {
                n |= 2;
            }
        }
        if ((n & 3) != 0) {
            charsBuffer.append(ALERT_FILE_EXISTS_FMT).format(new Object[]{string, (n & 3) != 2 ? "exists" : "created"}, 2);
            this.alert(charsBuffer.flushToString());
            n = 0x20000000;
        } else if (n == 0) {
            object = (IPropertiesModel)this.getPropertiesModelManager().add(string);
            if (object != null) {
                PropertiesContext propertiesContext = new PropertiesContext(string);
                propertiesContext.setFileState(32);
                XComparableTreeNode xComparableTreeNode = this.tree_provider.createNodeInstance(propertiesContext, true, 1);
                this.tree_provider.addNodeToRoot(xComparableTreeNode, true);
                this.markDirty(xComparableTreeNode);
                this.showStatus(charsBuffer.append("Create a new File :").append(string).flushToString());
                this.warning(charsBuffer.append('[').append(string).append("] is temporary now.").flushToString());
            } else {
                n = -268435456;
            }
        }
        CharsBuffer.Replace((CharsBuffer)charsBuffer);
        return n;
    }

    public int removeProperty(XComparableTreeNode xComparableTreeNode) {
        XComparableTreeNode xComparableTreeNode2 = this.tree_provider.getParentNode(xComparableTreeNode, 1);
        if (xComparableTreeNode2 == null) {
            return -268435456;
        }
        PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode2.getUserObject();
        if (propertiesContext.isReadOnly()) {
            return 0x50000000;
        }
        IPropertiesModel iPropertiesModel = this.getPropertiesModel(propertiesContext.canonical_name);
        int n = xComparableTreeNode.getNodeType();
        if (n == 3) {
            String string = this.solveUncertainKeyStringOf(xComparableTreeNode);
            if (iPropertiesModel.remove(string) == null) {
                return -268435456;
            }
            this.markDirty(this.tree_provider.getParentNode(xComparableTreeNode, 2));
            this.markDirty(xComparableTreeNode2);
            propertiesContext.setFileStateOr(16);
            this.tree_provider.removeNodeFromParent(xComparableTreeNode);
            return iPropertiesModel.size();
        }
        if (n == 2) {
            return this.removeSection(xComparableTreeNode, xComparableTreeNode2, propertiesContext, iPropertiesModel);
        }
        return -268435456;
    }

    private int removeSection(XComparableTreeNode xComparableTreeNode, XComparableTreeNode xComparableTreeNode2, PropertiesContext propertiesContext, IPropertiesModel iPropertiesModel) {
        Enumeration enumeration = xComparableTreeNode.children();
        CharsBuffer charsBuffer = CharsBuffer.GetShared((int)128).append((String)xComparableTreeNode.getUserObject()).append(this.getSectionDelimiter());
        int n = charsBuffer.length();
        while (enumeration.hasMoreElements()) {
            XComparableTreeNode xComparableTreeNode3 = (XComparableTreeNode)enumeration.nextElement();
            String string = charsBuffer.append((String)xComparableTreeNode3.getUserObject()).toString();
            charsBuffer.seek(n, true);
            if (iPropertiesModel.remove(string) != null) continue;
        }
        CharsBuffer.Replace((CharsBuffer)charsBuffer);
        this.markDirty(xComparableTreeNode2);
        propertiesContext.setFileStateOr(16);
        this.tree_provider.removeNodeFromParent(xComparableTreeNode);
        return iPropertiesModel.size();
    }

    public final int addProperty(String string, String string2) {
        if (this.isInvalidKeyString(string)) {
            return 0x10000000;
        }
        XComparableTreeNode xComparableTreeNode = this.tree_provider.currentSelectedProperties();
        if (xComparableTreeNode != null) {
            PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
            if (propertiesContext.isReadOnly()) {
                return 0x50000000;
            }
            IPropertiesModel iPropertiesModel = this.getPropertiesModelManager().forName(propertiesContext.canonical_name);
            XComparableTreeNode xComparableTreeNode2 = this.tree_provider.currentSelectedSection();
            String string3 = string;
            if (xComparableTreeNode2 != null) {
                String string4 = (String)xComparableTreeNode2.getUserObject();
                string3 = string4 + this.getSectionDelimiter() + string;
                xComparableTreeNode = xComparableTreeNode2;
            }
            if (iPropertiesModel.getValue(string3) != null) {
                return 0x20000000;
            }
            iPropertiesModel.add(string3, string2);
            propertiesContext.setFileStateOr(16);
            this.tree_provider.addNodeEx(xComparableTreeNode, string, false, true, 3);
            this.processAfterEdit(null);
            return iPropertiesModel.size();
        }
        return -268435456;
    }

    public final boolean isInvalidKeyString(String string) {
        return string == null || string.length() == 0 || string.indexOf(10) > 0 || Utility.IsSpaceString((String)string);
    }

    public final boolean isInvalidKey(String string) {
        if (this.isInvalidKeyString(string)) {
            return true;
        }
        XComparableTreeNode xComparableTreeNode = this.tree_provider.currentSelectedProperties();
        if (xComparableTreeNode != null) {
            PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
            IPropertiesModel iPropertiesModel = this.getPropertiesModelManager().forName(propertiesContext.canonical_name);
            return iPropertiesModel != null && iPropertiesModel.getValue(string) != null;
        }
        return false;
    }

    public final String solveUncertainKeyStringOf(XComparableTreeNode xComparableTreeNode) {
        XComparableTreeNode xComparableTreeNode2;
        CharsBuffer charsBuffer = CharsBuffer.GetShared((int)256).append(xComparableTreeNode.getUserObject());
        String string = null;
        while ((xComparableTreeNode2 = (XComparableTreeNode)xComparableTreeNode.getParent()) != null) {
            int n = xComparableTreeNode2.getNodeType();
            if (n != 1) {
                String string2 = (String)xComparableTreeNode2.getUserObject();
                charsBuffer.insert(0, string2.concat(String.valueOf(this.getSectionDelimiter())));
            } else if (n == 1) {
                string = charsBuffer.flushToString();
                break;
            }
            xComparableTreeNode = xComparableTreeNode2;
        }
        if (string == null) {
            string = charsBuffer.flushToString();
        }
        CharsBuffer.Replace((CharsBuffer)charsBuffer);
        return string;
    }

    public abstract IPropertiesModel getPropertiesModel(Object var1);

    public abstract IPropertiesModel removePropertiesModel(Object var1);

    public abstract JPopupMenu getPopupMenuFor(Object var1);

    public abstract PropertiesModelManager getPropertiesModelManager();

    public abstract TreePath getPathForPropertyKey(XComparableTreeNode var1, String var2);

    public abstract boolean ask(Object var1, int var2);

    public abstract boolean handlePropertyKeyChange(XComparableTreeNode var1, String var2);

    public abstract boolean handlePropertyValueChange(XComparableTreeNode var1, String var2);

    public abstract boolean restoreProperties(XComparableTreeNode var1, String var2);

    public abstract int removeProperty(TreePath[] var1);

    public abstract void init(ActionListener var1);

    public abstract void margeProperties(Object var1);

    public abstract void processEvent(AWTEvent var1);
}

