/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.tools.propedit.plugins;

import com.mylyane.afx.IApplication;
import com.mylyane.afx.IDomain;
import com.mylyane.afx.IProvider;
import com.mylyane.afx.PlatForm;
import com.mylyane.afx.XApplicationElements;
import com.mylyane.afx.swing.IUIProvider;
import com.mylyane.afx.swing.tree.XComparableTreeNode;
import com.mylyane.lang.CharsBuffer;
import com.mylyane.tools.propedit.afx.ActionDefinition;
import com.mylyane.tools.propedit.afx.DomainProviders;
import com.mylyane.tools.propedit.afx.IActionID;
import com.mylyane.tools.propedit.afx.IPropertiesUniversalProvider;
import com.mylyane.tools.propedit.afx.model.IPropertiesModel;
import com.mylyane.tools.propedit.afx.model.PropertiesContext;
import com.mylyane.tools.propedit.afx.plugin.XPropertiesEditorPlugin;
import com.mylyane.ui.swing.MicroButtonPane;
import com.mylyane.ui.swing.SearchResultWalkAction;
import com.mylyane.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class TextSearchPlugin
extends XPropertiesEditorPlugin
implements ActionListener,
IActionID {
    protected static final int SEARCH_TYPE_MASK = 1;
    protected static final int SEARCH_TYPE_KEY = 0;
    protected static final int SEARCH_TYPE_TEXT = 1;
    protected static final int SEARCH_COND_MASK = 6;
    protected static final int SEARCH_CONDITION_STARTSWITH = 2;
    protected static final int SEARCH_CONDITION_ENDSWITH = 4;
    protected static final int SEARCH_CONDITION_CONTAINED = 6;
    protected static final int INSTANCE_FOR_STRING = 0;
    protected static final int INSTANCE_FOR_TREEPATH = 1;
    static final Highlighter.HighlightPainter HL_ORANGE = new DefaultHighlighter.DefaultHighlightPainter(Color.orange);
    private JMenuItem highlite_item;
    private JMenuItem rm_highlite_item;
    private MicroButtonPane micro_buttons;
    private SearchResultWalkAction srw;
    private int search_bits;

    protected static SearchResultWalkAction.IWalkDelegate CreateWalkDelegate(IPropertiesUniversalProvider iPropertiesUniversalProvider, JTree jTree, int n) {
        switch (n) {
            case 0: {
                return new StringWalkDelegate(iPropertiesUniversalProvider, jTree);
            }
            case 1: {
                return new TreePathWalkDelegate(iPropertiesUniversalProvider, jTree);
            }
        }
        return null;
    }

    public static void SetHighlight(JTextComponent jTextComponent, String string) {
        TextSearchPlugin.RemoveHighlights(jTextComponent);
        Highlighter.HighlightPainter highlightPainter = HL_ORANGE;
        try {
            Highlighter highlighter = jTextComponent.getHighlighter();
            Document document = jTextComponent.getDocument();
            String string2 = document.getText(0, document.getLength());
            int n = 0;
            int n2 = string.length();
            while ((n = string2.indexOf(string, n)) >= 0) {
                highlighter.addHighlight(n, n + n2, highlightPainter);
                n += n2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void RemoveHighlights(JTextComponent jTextComponent) {
        Highlighter highlighter = jTextComponent.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        Highlighter.HighlightPainter highlightPainter = HL_ORANGE;
        for (int i = highlightArray.length - 1; i >= 0; --i) {
            Highlighter.Highlight highlight = highlightArray[i];
            if (highlight.getPainter() != highlightPainter) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    public String getPluginName() {
        return "Text Search Plugin";
    }

    public JMenuItem getPluginMenuItem() {
        JMenu jMenu = new JMenu(this.getPluginName());
        JMenuItem jMenuItem = new JMenuItem((Action)this.srw);
        JMenuItem jMenuItem2 = new JMenuItem("Show highlite(text mode)");
        JMenuItem jMenuItem3 = new JMenuItem("Remove highlite(text mode)");
        jMenuItem2.setEnabled(false);
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke("alt H"));
        jMenuItem3.setEnabled(false);
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke("alt X"));
        if (!PlatForm.IsVersionSatisfyIt((int)4)) {
            jMenuItem.setAccelerator((KeyStroke)this.srw.getValue("AcceleratorKey"));
        }
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        this.highlite_item = jMenuItem2;
        this.rm_highlite_item = jMenuItem3;
        return jMenu;
    }

    public boolean initialize(IDomain iDomain) {
        boolean bl;
        if (!super.initialize(iDomain)) {
            return false;
        }
        IUIProvider iUIProvider = (IUIProvider)iDomain.getProvider((IProvider.ProviderID)DomainProviders.TREE_ROOT_UI_PROVIDER);
        JPanel jPanel = (JPanel)iUIProvider.getRootComponent();
        boolean bl2 = bl = jPanel != null;
        if (bl) {
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            JTextField jTextField = new JTextField(10);
            jTextField.setActionCommand(ActionDefinition.IDsToActionCommands(new int[]{23}));
            jTextField.addActionListener(this);
            jTextField.setToolTipText("The character string that wants to be retrieved is input and ENTER is press.");
            jPanel2.add((Component)jTextField, "Center");
            String string = ActionDefinition.IDsToActionCommands(new int[]{21, 22});
            MicroButtonPane microButtonPane = new MicroButtonPane("Key|Text", string, 1, 0, (Object)this);
            jPanel2.add((Component)microButtonPane, "East");
            jPanel.add((Component)jPanel2, "North");
            this.micro_buttons = microButtonPane;
            this.initSearchClasses(1);
        }
        return bl;
    }

    private void initSearchClasses(int n) {
        this.srw = new SearchResultWalkAction();
        SearchResultWalkAction.IWalkDelegate iWalkDelegate = TextSearchPlugin.CreateWalkDelegate(this.uni_provider, this.tree_provider.getTree(), n);
        this.srw.setWalkDelegate(iWalkDelegate);
        this.setSearchMode(0);
        this.setSearchCondition(2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = ActionDefinition.ActionCommandToID(actionEvent);
        boolean bl = true;
        switch (n) {
            case 21: {
                bl = false;
            }
            case 22: {
                int n2 = n == 21 ? 0 : 1;
                this.micro_buttons.setPushed(n2);
                this.setSearchMode(n == 21 ? 0 : 1);
                this.app.showStatus("Search mode :".concat(n2 == 0 ? "Key" : "Text"));
                this.highlite_item.setEnabled(bl);
                this.rm_highlite_item.setEnabled(bl);
                break;
            }
            case 23: {
                String string = ((JTextField)actionEvent.getSource()).getText();
                this.app.showStatus("Serach :" + string);
                this.search(string);
                break;
            }
        }
        Object object = actionEvent.getSource();
        if (object == this.highlite_item) {
            String string = this.srw.getSearchWord();
            if (string != null && string.length() > 0) {
                TextSearchPlugin.SetHighlight(this.uni_provider.getValueEditor(), string);
            }
        } else if (object == this.rm_highlite_item) {
            TextSearchPlugin.RemoveHighlights(this.uni_provider.getValueEditor());
        }
    }

    synchronized void setSearchMode(int n) {
        this.search_bits = this.search_bits & 6 | n & 1;
    }

    synchronized void setSearchCondition(int n) {
        this.search_bits = this.search_bits & 1 | n & 6;
    }

    private synchronized void search(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            this.app.alert("Search: text is empty!");
            return;
        }
        XComparableTreeNode xComparableTreeNode = this.tree_provider.currentSelectedProperties();
        if (xComparableTreeNode == null) {
            return;
        }
        SearchResultWalkAction searchResultWalkAction = this.srw;
        searchResultWalkAction.reset();
        switch (this.search_bits & 1) {
            case 0: {
                if (searchResultWalkAction.is(0)) {
                    this.searchKeyV1(xComparableTreeNode, string, searchResultWalkAction);
                } else if (searchResultWalkAction.is(1)) {
                    this.searchKeyV2(xComparableTreeNode, string, searchResultWalkAction);
                }
                string2 = "Search key, count=";
                break;
            }
            case 1: {
                Object object = (PropertiesContext)xComparableTreeNode.getUserObject();
                IPropertiesModel iPropertiesModel = this.uni_provider.getPropertiesModel(((PropertiesContext)object).canonical_name);
                object = xComparableTreeNode.children();
                char c = this.uni_provider.getSectionDelimiter();
                while (object.hasMoreElements()) {
                    XComparableTreeNode xComparableTreeNode2 = (XComparableTreeNode)object.nextElement();
                    String string3 = (String)xComparableTreeNode2.getUserObject();
                    if (xComparableTreeNode2.getNodeType() == 2) {
                        Enumeration enumeration = xComparableTreeNode2.children();
                        CharsBuffer charsBuffer = CharsBuffer.GetShared((int)128).append(string3).append(c);
                        int n = charsBuffer.length();
                        while (enumeration.hasMoreElements()) {
                            XComparableTreeNode xComparableTreeNode3 = (XComparableTreeNode)enumeration.nextElement();
                            String string4 = charsBuffer.append((String)xComparableTreeNode3.getUserObject()).toString();
                            if ((string4 = iPropertiesModel.getValue(string4)) != null && string4.indexOf(string, 0) >= 0) {
                                searchResultWalkAction.add((Object)new TreePath(xComparableTreeNode3.getPath()));
                            }
                            charsBuffer.seek(n, true);
                        }
                        CharsBuffer.Replace((CharsBuffer)charsBuffer);
                        continue;
                    }
                    if ((string3 = iPropertiesModel.getValue(string3)) == null || string3.indexOf(string, 0) < 0) continue;
                    searchResultWalkAction.add((Object)new TreePath(xComparableTreeNode2.getPath()));
                }
                string2 = "Search text, count=";
                break;
            }
            default: {
                string2 = null;
            }
        }
        int n = searchResultWalkAction.size();
        if (n > 0) {
            searchResultWalkAction.notifyOfSearchDone((Object)xComparableTreeNode, string);
            searchResultWalkAction.setMode(this.search_bits & 1);
            searchResultWalkAction.walkNext();
        }
        if (string2 != null) {
            this.app.showStatus(string2 + n);
        }
    }

    private void searchKeyV1(XComparableTreeNode xComparableTreeNode, String string, SearchResultWalkAction searchResultWalkAction) {
        PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
        Enumeration enumeration = this.uni_provider.getPropertiesModel(propertiesContext.canonical_name).keys();
        int n = this.search_bits & 6;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.isConditionHit(string, string2, n)) continue;
            searchResultWalkAction.add((Object)string2);
        }
    }

    private void searchKeyV2(XComparableTreeNode xComparableTreeNode, String string, SearchResultWalkAction searchResultWalkAction) {
        Enumeration enumeration = xComparableTreeNode.children();
        char c = this.uni_provider.getSectionDelimiter();
        int n = this.search_bits & 6;
        while (enumeration.hasMoreElements()) {
            XComparableTreeNode xComparableTreeNode2 = (XComparableTreeNode)enumeration.nextElement();
            String string2 = (String)xComparableTreeNode2.getUserObject();
            if (xComparableTreeNode2.getNodeType() == 2) {
                Enumeration enumeration2 = xComparableTreeNode2.children();
                CharsBuffer charsBuffer = CharsBuffer.GetShared((int)128).append(string2).append(c);
                int n2 = charsBuffer.length();
                while (enumeration2.hasMoreElements()) {
                    XComparableTreeNode xComparableTreeNode3 = (XComparableTreeNode)enumeration2.nextElement();
                    if (this.isConditionHit(string, charsBuffer.append((String)xComparableTreeNode3.getUserObject()).toString(), n)) {
                        searchResultWalkAction.add((Object)new TreePath(xComparableTreeNode3.getPath()));
                    }
                    charsBuffer.seek(n2, true);
                }
                CharsBuffer.Replace((CharsBuffer)charsBuffer);
                continue;
            }
            if (!this.isConditionHit(string, string2, n)) continue;
            searchResultWalkAction.add((Object)new TreePath(xComparableTreeNode2.getPath()));
        }
    }

    private boolean isConditionHit(String string, String string2, int n) {
        switch (n) {
            case 2: {
                return string2.startsWith(string, 0);
            }
            case 4: {
                return string2.endsWith(string);
            }
            case 6: {
                return string2.indexOf(string, 0) >= 0;
            }
        }
        return false;
    }

    public static class TreePathWalkDelegate
    extends StringWalkDelegate {
        private int next;

        TreePathWalkDelegate(IPropertiesUniversalProvider iPropertiesUniversalProvider, JTree jTree) {
            super(iPropertiesUniversalProvider, jTree);
        }

        public void update(Vector vector) {
            this.walk_next = 0;
            this.next = 0;
        }

        public boolean isInstanceFor(int n) {
            return n == 1;
        }

        public synchronized void walkNext() {
            TreePath treePath;
            if (!this.isCurrentContextAvailable()) {
                return;
            }
            if (this.mode == 1) {
                this.walkNextValue();
                return;
            }
            int n = 2;
            do {
                if (this.walk_next >= this.size()) {
                    this.walk_next = 0;
                    if (--n == 0) {
                        this.message("Search, thing including text \"" + this.search_word + "\" is not found.");
                        return;
                    }
                }
                treePath = (TreePath)this.owner.get(this.walk_next++);
                this.tree.setSelectionPath(treePath);
            } while (this.tree.getPathBounds(treePath) == null);
            this.visitMessage();
        }

        private void walkNextValue() {
            int n;
            JTextComponent jTextComponent;
            block1: {
                int n2 = 2;
                jTextComponent = this.uni_provider.getValueEditor();
                while (true) {
                    String string;
                    TreePath treePath = (TreePath)this.owner.get(this.walk_next);
                    this.tree.setSelectionPath(treePath);
                    if (this.tree.getPathBounds(treePath) != null && (n = (string = jTextComponent.getText()).indexOf(this.search_word, this.next)) >= 0) break block1;
                    this.next = 0;
                    ++this.walk_next;
                    if (this.walk_next < this.size()) continue;
                    this.walk_next = 0;
                    if (--n2 == 0) break;
                }
                this.message("Search, thing including text \"" + this.search_word + "\" is not found.");
                return;
            }
            int n3 = this.search_word.length();
            jTextComponent.grabFocus();
            this.next = n + n3;
            jTextComponent.select(n, this.next);
            this.message("Search visit :" + (this.walk_next + 1));
        }

        private void message(String string) {
            if (this.app != null) {
                this.app.showStatus(string);
            }
        }
    }

    public static class StringWalkDelegate
    implements SearchResultWalkAction.IWalkDelegate {
        protected JTree tree;
        protected IApplication app;
        protected IPropertiesUniversalProvider uni_provider;
        protected SearchResultWalkAction owner;
        protected int walk_next;
        protected int mode;
        String[] contents;
        String search_word;

        StringWalkDelegate(IPropertiesUniversalProvider iPropertiesUniversalProvider, JTree jTree) {
            this.tree = jTree;
            this.uni_provider = iPropertiesUniversalProvider;
            this.walk_next = 0;
            if (iPropertiesUniversalProvider instanceof XApplicationElements) {
                this.app = ((XApplicationElements)iPropertiesUniversalProvider).getApplication();
            }
        }

        protected synchronized void finalize() {
            this.app = null;
            this.tree = null;
            this.uni_provider = null;
            this.contents = null;
            if (this.owner != null) {
                this.owner.setWalkDelegate(null);
                this.owner = null;
            }
        }

        public int size() {
            return this.contents == null ? this.owner.size() : this.contents.length;
        }

        public boolean isCurrentContextAvailable() {
            XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)this.owner.getValue("search-from-object");
            if (xComparableTreeNode == null || !this.uni_provider.isPropertiesAvailable(xComparableTreeNode)) {
                this.owner.reset();
                return false;
            }
            return true;
        }

        protected final void visitMessage() {
            if (this.app != null) {
                this.app.showStatus("Search visit :" + this.walk_next);
            }
        }

        public String getSearchWord() {
            return this.search_word;
        }

        public void setMode(int n) {
            this.mode = n;
        }

        public void setSearchWord(String string) {
            this.search_word = string;
        }

        public void setOwner(SearchResultWalkAction searchResultWalkAction) {
            this.owner = searchResultWalkAction;
        }

        public boolean isInstanceFor(int n) {
            return n == 0;
        }

        public void update(Vector vector) {
            if (vector.size() == 0) {
                this.contents = null;
                this.walk_next = 0;
                return;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Utility.FqSort((Comparable[])objectArray, (int)0, (int)(objectArray.length - 1));
            vector.removeAllElements();
            this.contents = objectArray;
        }

        public void walkNext() {
            String string;
            int n;
            String[] stringArray = this.contents;
            if (stringArray == null) {
                return;
            }
            if (!this.isCurrentContextAvailable()) {
                return;
            }
            int n2 = n = this.size();
            TreePath treePath = null;
            XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)this.owner.getValue("search-from-object");
            do {
                if (this.walk_next < n) continue;
                this.walk_next = 0;
            } while ((treePath = this.uni_provider.getPathForPropertyKey(xComparableTreeNode, string = stringArray[this.walk_next++])) == null && --n2 >= 0);
            if (treePath == null) {
                this.owner.reset();
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.visitMessage();
        }
    }
}

