/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.tools.propedit.plugins;

import com.mylyane.afx.IDomain;
import com.mylyane.afx.PlatForm;
import com.mylyane.afx.swing.tree.XComparableTreeNode;
import com.mylyane.lang.CharsBuffer;
import com.mylyane.tools.propedit.afx.INodeConstants;
import com.mylyane.tools.propedit.afx.model.IPropertiesModel;
import com.mylyane.tools.propedit.afx.plugin.XPropertiesEditorPlugin;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreeDnDSupportPlugin
extends XPropertiesEditorPlugin
implements DragGestureListener,
TreeSelectionListener,
DropTargetListener,
MouseListener,
MouseMotionListener,
DragSourceListener,
INodeConstants {
    private transient DropTarget drop_target;
    private transient DataFlavor file_list;
    private transient JTree tree;
    private transient boolean b_java14;
    private XComparableTreeNode from_parent;
    private Point p_cache;
    private boolean b_reject_usr;
    private Point p_cache2;
    static final TreePath[] NULL_PATH = new TreePath[0];
    static final XComparableTreeNode[] NULL_NODE = new XComparableTreeNode[0];
    static final DataFlavor TREE_PATHs_FLAVOR = new DataFlavor(NULL_PATH.getClass(), "treepath-array");
    static final DataFlavor TREE_NODEs_FLAVOR = new DataFlavor(NULL_NODE.getClass(), "treenode-array");
    static final DataFlavor NODE_INDICES_FLAVOR = new DataFlavor(class$com$mylyane$tools$propedit$plugins$TreeDnDSupportPlugin$NodeSelectionSnap == null ? (class$com$mylyane$tools$propedit$plugins$TreeDnDSupportPlugin$NodeSelectionSnap = TreeDnDSupportPlugin.class$("com.mylyane.tools.propedit.plugins.TreeDnDSupportPlugin$NodeSelectionSnap")) : class$com$mylyane$tools$propedit$plugins$TreeDnDSupportPlugin$NodeSelectionSnap, "treenode-indices-snap");
    static final DataFlavor PROPERTIES_FLAVOR = new DataFlavor(new Vector().getClass(), "properties-item-set");
    private DragSource ds;
    private DragGestureRecognizer mdgr;
    private TreeElementTrasfer tp_transfer;
    private TreeScrollAction action;
    private boolean dnd_lock = false;
    private boolean b_blanket_ban = false;
    static /* synthetic */ Class class$com$mylyane$tools$propedit$plugins$TreeDnDSupportPlugin$NodeSelectionSnap;

    protected void finalize() {
        this.drop_target = null;
        this.tree = null;
        this.file_list = null;
        this.ds = null;
        this.mdgr = null;
        this.tp_transfer = null;
    }

    public String getPluginName() {
        return "Tree drag drop support Plugin";
    }

    public boolean initialize(IDomain iDomain) {
        if (!super.initialize(iDomain)) {
            return false;
        }
        this.tree = this.tree_provider.getTree();
        this.tree.addMouseListener(this);
        this.tree.addMouseMotionListener(this);
        this.tree.addTreeSelectionListener(this);
        this.drop_target = new DropTarget(this.tree, this);
        FlavorMap flavorMap = this.drop_target.getFlavorMap();
        Map<String, DataFlavor> map = flavorMap.getFlavorsForNatives(null);
        this.file_list = map.get("HDROP");
        this.ds = new DragSource();
        this.mdgr = this.ds.createDefaultDragGestureRecognizer(this.tree, 3, this);
        this.b_java14 = PlatForm.IsVersionSatisfyIt((int)4);
        this.tp_transfer = new TreeElementTrasfer(this);
        return true;
    }

    public JMenuItem getPluginMenuItem() {
        return null;
    }

    private void openFilesIf(Object object) {
        List list;
        if (object instanceof List && (list = (List)object).size() > 0) {
            File[] fileArray = (File[])list.toArray();
            this.app.onFileOpen(fileArray);
        }
    }

    private void privateDrop(TreePath[] treePathArray, TreePath treePath, int n) {
        XComparableTreeNode xComparableTreeNode;
        if (treePath != null && (xComparableTreeNode = (XComparableTreeNode)treePath.getLastPathComponent()) != null) {
            System.out.println("Drop dest :" + xComparableTreeNode);
            if (treePathArray != null && treePathArray.length > 0) {
                System.out.println("TreePath length: " + treePathArray.length);
                IPropertiesModel iPropertiesModel = this.uni_provider.getPropertiesModel(this.from_parent);
                IPropertiesModel iPropertiesModel2 = this.uni_provider.getPropertiesModel(xComparableTreeNode);
                switch (n) {
                    case 1: {
                        int n2 = xComparableTreeNode.getNodeType();
                        if (n2 == 1) {
                            this.copyNodesToProperties(treePathArray, xComparableTreeNode, iPropertiesModel, iPropertiesModel2);
                            break;
                        }
                        if (n2 != 2) break;
                        this.copyNodesToSection(treePathArray, xComparableTreeNode, iPropertiesModel, iPropertiesModel2);
                        break;
                    }
                }
            }
        }
    }

    private XComparableTreeNode searchSameSection(XComparableTreeNode xComparableTreeNode, XComparableTreeNode xComparableTreeNode2) {
        Object object = xComparableTreeNode2.getUserObject();
        Enumeration enumeration = xComparableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            XComparableTreeNode xComparableTreeNode3 = (XComparableTreeNode)enumeration.nextElement();
            if (xComparableTreeNode3.getNodeType() != 2 || !xComparableTreeNode3.getUserObject().equals(object)) continue;
            return xComparableTreeNode3;
        }
        return null;
    }

    private void copyNodesToProperties(TreePath[] treePathArray, XComparableTreeNode xComparableTreeNode, IPropertiesModel iPropertiesModel, IPropertiesModel iPropertiesModel2) {
        int n = treePathArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            XComparableTreeNode xComparableTreeNode2 = (XComparableTreeNode)treePathArray[i].getLastPathComponent();
            int n2 = xComparableTreeNode2.getNodeType();
            if (n2 == 2) {
                int n3 = 0;
                int[] nArray = null;
                XComparableTreeNode xComparableTreeNode3 = this.searchSameSection(xComparableTreeNode, xComparableTreeNode2);
                int n4 = xComparableTreeNode2.getChildCount();
                while (n4-- > 0) {
                    XComparableTreeNode xComparableTreeNode4 = (XComparableTreeNode)xComparableTreeNode2.getChildAt(n4);
                    string = this.uni_provider.solveUncertainKeyStringOf(xComparableTreeNode4);
                    if (!iPropertiesModel2.containsKey(string)) {
                        iPropertiesModel2.add(string, iPropertiesModel.getValue(string));
                        if (xComparableTreeNode3 == null) continue;
                        this.tree_provider.addNode(xComparableTreeNode3, xComparableTreeNode4, false);
                        continue;
                    }
                    if (xComparableTreeNode3 != null) continue;
                    if (nArray == null) {
                        nArray = new int[xComparableTreeNode2.getChildCount()];
                    }
                    nArray[n3++] = xComparableTreeNode2.getIndex((TreeNode)xComparableTreeNode4);
                }
                if (n3 > 0) {
                    if (xComparableTreeNode2.getChildCount() == n3) continue;
                    while (n3-- > 0) {
                        xComparableTreeNode2.remove((int)nArray[n3]);
                    }
                }
                if (xComparableTreeNode3 != null) continue;
                this.tree_provider.addNode(xComparableTreeNode, xComparableTreeNode2, false);
                continue;
            }
            if (n2 != 3) continue;
            String string2 = this.uni_provider.solveUncertainKeyStringOf(xComparableTreeNode2);
            string = (String)xComparableTreeNode2.getUserObject();
            if (iPropertiesModel2.containsKey(string)) continue;
            iPropertiesModel2.add(string, iPropertiesModel.getValue(string2));
            this.tree_provider.addNode(xComparableTreeNode, xComparableTreeNode2, false);
        }
    }

    private void copyNodesToSection(TreePath[] treePathArray, XComparableTreeNode xComparableTreeNode, IPropertiesModel iPropertiesModel, IPropertiesModel iPropertiesModel2) {
        CharsBuffer charsBuffer = CharsBuffer.GetShared((int)256).append((String)xComparableTreeNode.getUserObject()).append(this.uni_provider.getSectionDelimiter());
        int n = charsBuffer.length();
        int n2 = treePathArray.length;
        for (int i = 0; i < n2; ++i) {
            String string;
            XComparableTreeNode xComparableTreeNode2 = (XComparableTreeNode)treePathArray[i].getLastPathComponent();
            int n3 = xComparableTreeNode2.getNodeType();
            if (n3 == 2) {
                Enumeration enumeration = xComparableTreeNode2.children();
                while (enumeration.hasMoreElements()) {
                    XComparableTreeNode xComparableTreeNode3 = (XComparableTreeNode)enumeration.nextElement();
                    String string2 = (String)xComparableTreeNode3.getUserObject();
                    string = charsBuffer.append(string2).toString();
                    charsBuffer.seek(n, true);
                    if (iPropertiesModel2.containsKey(string)) continue;
                    iPropertiesModel2.add(string, iPropertiesModel.getValue(this.uni_provider.solveUncertainKeyStringOf(xComparableTreeNode3)));
                    this.tree_provider.addNodeEx(xComparableTreeNode, string2, false, false, 3);
                }
                continue;
            }
            if (n3 != 3) continue;
            string = charsBuffer.append((String)xComparableTreeNode2.getUserObject()).toString();
            charsBuffer.seek(n, true);
            if (iPropertiesModel2.containsKey(string)) continue;
            iPropertiesModel2.add(string, iPropertiesModel.getValue(this.uni_provider.solveUncertainKeyStringOf(xComparableTreeNode2)));
            this.tree_provider.addNode(xComparableTreeNode, xComparableTreeNode2, false);
        }
        CharsBuffer.Replace((CharsBuffer)charsBuffer);
    }

    String getPropertiesFormText(TreePath[] treePathArray) {
        return this.getPropertiesFormText(treePathArray, this.uni_provider.getPropertiesModel(this.from_parent));
    }

    String getPropertiesFormText(TreePath[] treePathArray, IPropertiesModel iPropertiesModel) {
        if (iPropertiesModel == null) {
            return null;
        }
        int n = treePathArray.length;
        CharsBuffer charsBuffer = CharsBuffer.GetShared((int)4096);
        for (int i = 0; i < n; ++i) {
            String string;
            XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)treePathArray[i].getLastPathComponent();
            int n2 = xComparableTreeNode.getNodeType();
            if (n2 == 2) {
                Enumeration enumeration = xComparableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    XComparableTreeNode xComparableTreeNode2 = (XComparableTreeNode)enumeration.nextElement();
                    string = this.uni_provider.solveUncertainKeyStringOf(xComparableTreeNode2);
                    charsBuffer.append(string).append('=').addLine(iPropertiesModel.getValue(string));
                }
                continue;
            }
            if (n2 != 3) continue;
            string = this.uni_provider.solveUncertainKeyStringOf(xComparableTreeNode);
            iPropertiesModel.getValue(string);
            charsBuffer.append(string).append('=').addLine(iPropertiesModel.getValue(string));
        }
        String string = charsBuffer.flushToString();
        CharsBuffer.Replace((CharsBuffer)charsBuffer);
        return string;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        if (point.equals(this.p_cache)) {
            return;
        }
        this.p_cache = point;
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        boolean bl = true;
        if ((treePath == null || this.tree_provider.isRootNode(treePath)) && !dropTargetDragEvent.isDataFlavorSupported(this.file_list)) {
            bl = false;
        } else if (treePath != null) {
            this.tree.setSelectionPath(treePath);
            XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)treePath.getLastPathComponent();
            if (xComparableTreeNode != null) {
                if (dropTargetDragEvent.isDataFlavorSupported(this.file_list) && !this.tree_provider.isRootNode(xComparableTreeNode)) {
                    bl = false;
                } else if (dropTargetDragEvent.isDataFlavorSupported(TREE_PATHs_FLAVOR) && (xComparableTreeNode.getNodeType() == 3 || this.from_parent != null && this.from_parent.equals(this.tree_provider.getParentNode(xComparableTreeNode, 1)) || this.tree_provider.isRootNode(xComparableTreeNode))) {
                    bl = false;
                }
            }
        }
        if (bl) {
            dropTargetDragEvent.acceptDrag(0x40000003);
            System.out.println("acceptDrag!!");
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private void printFlavors(DataFlavor[] dataFlavorArray) {
        for (int i = dataFlavorArray.length - 1; i >= 0; --i) {
            System.out.println(dataFlavorArray[i]);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        System.out.println("drop :" + dropTargetDropEvent.getDropAction());
        Transferable transferable = dropTargetDropEvent.getTransferable();
        this.printFlavors(transferable.getTransferDataFlavors());
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if ((treePath == null || this.tree_provider.isRootNode(treePath)) && transferable.isDataFlavorSupported(this.file_list)) {
            dropTargetDropEvent.acceptDrop(3);
            try {
                this.openFilesIf(transferable.getTransferData(this.file_list));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (transferable.isDataFlavorSupported(TREE_PATHs_FLAVOR)) {
            TreePath[] treePathArray;
            dropTargetDropEvent.acceptDrop(3);
            try {
                treePathArray = (TreePath[])transferable.getTransferData(TREE_PATHs_FLAVOR);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                treePathArray = null;
            }
            if (treePathArray != null) {
                this.privateDrop(treePathArray, treePath, dropTargetDropEvent.getDropAction());
            }
        }
        dropTargetDropEvent.dropComplete(true);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("DropAction: " + dropTargetDragEvent.getDropAction());
        System.out.println("SourceActions : " + dropTargetDragEvent.getSourceActions());
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        System.out.println("DropTargetListener dragExit");
    }

    private void changeCursor(DragSourceContext dragSourceContext, int n) {
        Cursor cursor;
        if (this.b_reject_usr) {
            return;
        }
        switch (n) {
            case 1: {
                cursor = DragSource.DefaultCopyDrop;
                break;
            }
            case 2: {
                cursor = DragSource.DefaultMoveDrop;
                break;
            }
            default: {
                cursor = DragSource.DefaultCopyNoDrop;
            }
        }
        dragSourceContext.setCursor(cursor);
        System.out.println("changeCursor, action=" + n);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println("DragSourceListener dragEnter :");
        this.b_reject_usr = false;
    }

    private Point patchIfJre13(DragSourceDragEvent dragSourceDragEvent) {
        return this.b_java14 ? dragSourceDragEvent.getLocation() : this.p_cache2;
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        Point point = this.patchIfJre13(dragSourceDragEvent);
        if (point.equals(this.p_cache2)) {
            return;
        }
        this.p_cache2 = point;
        this.b_reject_usr = false;
        this.changeCursor(dragSourceDragEvent.getDragSourceContext(), dragSourceDragEvent.getUserAction());
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        this.changeCursor(dragSourceDragEvent.getDragSourceContext(), dragSourceDragEvent.getUserAction());
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        this.b_reject_usr = true;
        System.out.println("DragSourceListener dragExit");
        dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.b_reject_usr = false;
        this.tp_transfer.reset();
        this.mdgr.resetRecognizer();
        this.dnd_lock = false;
        System.out.println("dnd_lock:Off");
        System.out.println("dragDropEnd");
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (!this.b_blanket_ban && (dragGestureEvent.getDragAction() & 3) != 0) {
            Cursor cursor;
            switch (dragGestureEvent.getDragAction()) {
                case 1: {
                    cursor = DragSource.DefaultCopyDrop;
                    break;
                }
                case 2: {
                    cursor = DragSource.DefaultMoveDrop;
                    break;
                }
                default: {
                    cursor = null;
                }
            }
            if (this.tp_transfer.paths != NULL_PATH) {
                dragGestureEvent.startDrag(cursor, this.tp_transfer, this);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int n;
        if (!this.dnd_lock) {
            System.out.println(">Set TreePath[]");
            this.tp_transfer.paths = this.tree.getSelectionPaths();
        }
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = this.tree.getVisibleRect();
        int n2 = rectangle.y - rectangle.height - 5;
        int n3 = rectangle.y + rectangle.height * 2 + 5;
        int n4 = n3 >= rectangle2.height ? 3 : (n = n2 <= rectangle2.y ? -3 : 0);
        if (n != 0) {
            if (this.action == null) {
                this.action = new TreeScrollAction(this.tree);
            }
            this.action.setTargetPath(treePath, n);
            this.action.start();
        }
    }

    private boolean isUnsupportType(int n) {
        return n == 0 || n == 1;
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) != 16) {
            return 0;
        }
        return 3;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        TreePath[] treePathArray;
        if (!this.tree.isEditing() && this.mapDragOperationFromModifiers(mouseEvent) != 0 && (treePathArray = this.tp_transfer.paths) != NULL_PATH) {
            TreePath treePath = null;
            if (treePathArray != null && treePathArray.length > 0) {
                if (this.tree_provider.isParentOver(treePathArray)) {
                    this.app.alert("The selection that extends to two or more parents is refused.");
                    this.b_blanket_ban = true;
                    return;
                }
                treePath = treePathArray[0];
            } else {
                treePath = this.tree.getSelectionPath();
            }
            if (treePath != null) {
                XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)treePath.getLastPathComponent();
                if (this.isUnsupportType(xComparableTreeNode.getNodeType())) {
                    this.b_blanket_ban = true;
                    return;
                }
                this.from_parent = this.tree_provider.getParentNode(xComparableTreeNode, 1);
                this.dnd_lock = true;
                this.b_blanket_ban = false;
                mouseEvent.consume();
                System.out.println("dnd_lock:On");
                return;
            }
        }
        this.from_parent = null;
        this.b_blanket_ban = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.b_java14) {
            this.p_cache2 = mouseEvent.getPoint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.from_parent = null;
        this.b_blanket_ban = true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.from_parent = null;
        this.b_blanket_ban = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class TreeScrollAction
    implements ActionListener {
        private JTree tree;
        private TreePath tree_path;
        private Timer timer;
        private int mv_row;

        TreeScrollAction(JTree jTree) {
            this.tree = jTree;
            this.timer = new Timer(500, this);
            this.timer.setRepeats(false);
        }

        void setTargetPath(TreePath treePath, int n) {
            this.tree_path = treePath;
            this.mv_row = n;
        }

        void start() {
            if (this.timer.isRunning()) {
                this.timer.restart();
            } else {
                this.timer.start();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.tree.getRowForPath(this.tree_path) + this.mv_row;
            if (n < 0) {
                n = 0;
            }
            this.tree.scrollRowToVisible(n);
        }

        protected void finalize() throws Throwable {
            this.tree = null;
            this.tree_path = null;
            this.timer.stop();
            this.timer.removeActionListener(this);
            this.timer = null;
        }
    }

    static final class NodeSelectionSnap {
        static final int SECTION = 0;
        static final int SECTION_TO_KEY = 1;
        static final int KEY = 3;
        int type;
        Object indices;

        NodeSelectionSnap() {
        }

        int getDimension() {
            Object object = this.indices;
            if (object == null) {
                return -1;
            }
            return object instanceof int[] ? 1 : (object instanceof int[][] ? 2 : 0);
        }
    }

    static final class TreeElementTrasfer
    implements Transferable {
        TreePath[] paths;
        TreeDnDSupportPlugin parent;

        TreeElementTrasfer(TreeDnDSupportPlugin treeDnDSupportPlugin) {
            this.parent = treeDnDSupportPlugin;
            this.reset();
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{TREE_NODEs_FLAVOR, TREE_PATHs_FLAVOR, DataFlavor.stringFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            String string = dataFlavor.getHumanPresentableName();
            return string.equals("treenode-array") || string.equals("treepath-array") || DataFlavor.stringFlavor == dataFlavor;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            if (dataFlavor.getHumanPresentableName() == "treepath-array") {
                return this.paths;
            }
            if (DataFlavor.stringFlavor == dataFlavor) {
                return this.parent.getPropertiesFormText(this.paths);
            }
            return null;
        }

        void reset() {
            this.paths = NULL_PATH;
        }
    }
}

