/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.afx;

public abstract class PlatForm {
    public static final byte JAVA_VENDOR_ID_UNKNOWN = -1;
    public static final byte JAVA_VENDOR_ID_SUN = 0;
    public static final byte JAVA_VENDOR_ID_MS = 1;
    public static final byte JAVA_VENDOR_ID_NS4x = 2;
    public static final byte NATIVE_ID_UNKNOWN = -1;
    public static final byte NATIVE_ID_WINDOWS9x = 0;
    public static final byte NATIVE_ID_UNIX = 1;
    public static final byte NATIVE_ID_LINUX = 2;
    public static final byte NATIVE_ID_WINDOWS_NT = 3;
    public static final byte NATIVE_ID_WINDOWS_XP = 4;

    public static Class ClassFromLiteral(String string) {
        try {
            return Class.forName(string.replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int AskJavaVendor() {
        int n = -1;
        String string = null;
        try {
            string = System.getProperty("java.vendor");
        }
        finally {
            if (string != null) {
                if (string.indexOf("Netscape") >= 0) {
                    n = 2;
                } else if (string.indexOf("Sun Microsystems") >= 0) {
                    n = 0;
                } else if (string.indexOf("Microsoft") >= 0) {
                    n = 1;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int AskNaitve() {
        int n = -1;
        String string = null;
        try {
            string = System.getProperty("os.name");
            Object var3_2 = null;
            if (string != null) {
                if (string.indexOf("Unix") >= 0) {
                    n = 1;
                } else if (string.indexOf("Linux") >= 0) {
                    n = 2;
                } else if (string.indexOf("Windows 9") >= 0) {
                    n = 0;
                } else if (string.indexOf("Windows NT") >= 0 || string.indexOf("Windows 2000") >= 0) {
                    n = 3;
                } else if (string.indexOf("Windows XP") >= 0) {
                    n = 4;
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (string != null) {
                if (string.indexOf("Unix") >= 0) {
                    n = 1;
                } else if (string.indexOf("Linux") >= 0) {
                    n = 2;
                } else if (string.indexOf("Windows 9") >= 0) {
                    n = 0;
                } else if (string.indexOf("Windows NT") >= 0 || string.indexOf("Windows 2000") >= 0) {
                    n = 3;
                } else if (string.indexOf("Windows XP") >= 0) {
                    n = 4;
                }
            }
            throw throwable;
        }
        return n;
    }

    public static boolean IsJava2() {
        int n = System.getProperty("java.version").charAt(2) - 48;
        return n > 1;
    }

    public static boolean IsVersionSatisfyIt(int n) {
        int n2 = System.getProperty("java.version").charAt(2) - 48;
        return n2 >= n;
    }

    public static boolean IsTiger() {
        return PlatForm.IsVersionSatisfyIt(5);
    }

    public static boolean IsAppletProcess() {
        try {
            System.getProperty("user.dir");
            return false;
        }
        catch (SecurityException securityException) {
            return true;
        }
    }
}

