/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.afx;

import com.mylyane.util.IOUtility;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.SwingUtilities;

public class UIModule {
    public static final Toolkit g_CURRENT_KIT = Toolkit.getDefaultToolkit();
    private static EventQueue EQ;
    private static final Image[] IMG_HOLDER;

    private static Class GetClassByLiteral(String string) {
        try {
            return Class.forName(string.replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static boolean IsEventQueueEnable() {
        return EQ != null;
    }

    public static void NotifyEvent(AWTEvent aWTEvent) {
        EQ.postEvent(aWTEvent);
    }

    public static void ToCenterScreen(Object object) {
        UIModule.ToCenterByWindow(object, null);
    }

    public static void ToCenterByWindow(Object object, Window window) {
        if (object instanceof Window) {
            Dimension dimension;
            Window window2 = (Window)object;
            Point point = null;
            if (window == null) {
                dimension = g_CURRENT_KIT.getScreenSize();
            } else {
                dimension = window.getSize();
                point = window.getLocation();
            }
            Dimension dimension2 = window2.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            if (point != null) {
                point.x += (dimension.width - dimension2.width) / 2;
                point.y += (dimension.height - dimension2.height) / 2;
            } else {
                point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            }
            window2.setLocation(point);
        }
    }

    public static void BoundsWindowByScreen(Window window, int n) {
        Dimension dimension = UIModule.GetScreenSize();
        window.setBounds(n, n, dimension.width - n * 2, dimension.height - n * 2);
    }

    public static int GetStringWidth(Graphics graphics, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return SwingUtilities.computeStringWidth(fontMetrics, string);
    }

    public static int GetStringWidth(Font font, String string) {
        return g_CURRENT_KIT.getFontMetrics(font).stringWidth(string);
    }

    public static String[] SplitString(String string, char c) {
        if (string == null) {
            return new String[0];
        }
        int n = UIModule.CountChar(string, c);
        if (n == 0) {
            return new String[]{string};
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (string.charAt(n2) != c) {
                ++n2;
                continue;
            }
            stringArray[n4] = string.substring(n3, n2);
            n3 = ++n2;
            if (++n4 >= n) break;
        }
        stringArray[n4] = string.substring(n3);
        return stringArray;
    }

    public static int CountChar(String string, char c) {
        int n = 0;
        int n2 = string.length();
        while (n2-- > 0) {
            if (string.charAt(n2) != c) continue;
            ++n;
        }
        return n;
    }

    public static Dimension GetScreenSize() {
        return g_CURRENT_KIT.getScreenSize();
    }

    public static PopupMenu CreatePopupByParams(String string, Font font, ActionListener actionListener) {
        String[] stringArray = UIModule.SplitString(string, '|');
        if (stringArray.length == 0) {
            return null;
        }
        PopupMenu popupMenu = new PopupMenu();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-")) {
                popupMenu.addSeparator();
                continue;
            }
            MenuItem menuItem = new MenuItem(string2);
            if (font != null) {
                menuItem.setFont(font);
            }
            menuItem.addActionListener(actionListener);
            popupMenu.add(menuItem);
        }
        return popupMenu;
    }

    public static void SetMenuItemActionCommandsByParams(String string, PopupMenu popupMenu) {
        String[] stringArray = UIModule.SplitString(string, '|');
        if (stringArray.length == 0) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-")) continue;
            popupMenu.getItem(i).setActionCommand(string2);
        }
    }

    public static Menu CreateMenuByParams(String string, Font font, ActionListener actionListener) {
        String[] stringArray = UIModule.SplitString(string, '|');
        if (stringArray.length == 0) {
            return null;
        }
        Menu menu = new Menu();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-")) {
                menu.addSeparator();
                continue;
            }
            MenuItem menuItem = new MenuItem(string2);
            if (font != null) {
                menuItem.setFont(font);
            }
            menuItem.addActionListener(actionListener);
            menu.add(menuItem);
        }
        return menu;
    }

    public static Choice CreateChoiceByParams(String string, Font font, ItemListener itemListener) {
        String[] stringArray = UIModule.SplitString(string, '|');
        if (stringArray.length == 0) {
            return null;
        }
        Choice choice = new Choice();
        choice.addItemListener(itemListener);
        if (font != null) {
            choice.setFont(font);
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            choice.add(stringArray[i]);
        }
        return choice;
    }

    public static Window FindTopWindow(Container container) {
        if (container != null) {
            do {
                if (!((container = container.getParent()) instanceof Window)) continue;
                return (Window)container;
            } while (container != null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image CreateImageFromBytes(byte[] byArray, Component component) {
        Image image = g_CURRENT_KIT.createImage(byArray);
        g_CURRENT_KIT.prepareImage(image, -1, -1, component);
        Component component2 = component;
        synchronized (component2) {
            while (image.getWidth(component) < 0) {
                component.notifyAll();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image WaitForImage(Image image, Component component) {
        Image[] imageArray = IMG_HOLDER;
        Image[] imageArray2 = IMG_HOLDER;
        synchronized (imageArray2) {
            imageArray[0] = image;
            boolean bl = UIModule.WaitForImage(imageArray, component) == null;
            imageArray[0] = null;
            return bl ? null : image;
        }
    }

    public static final Image[] WaitForImage(Image[] imageArray, Component component) {
        int n;
        if (imageArray == null || (n = imageArray.length) == 0) {
            return null;
        }
        try {
            MediaTracker mediaTracker = new MediaTracker(component);
            while (n-- > 0) {
                mediaTracker.addImage(imageArray[n], 0);
            }
            mediaTracker.waitForID(0);
            if (imageArray[0].getWidth(null) < 0 || imageArray[0].getHeight(null) < 0) {
                throw new Exception();
            }
            return imageArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image LoadImage(URL uRL, Component component) {
        try {
            return UIModule.LoadImage(uRL.openStream(), component);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image LoadImage(InputStream inputStream, Component component) {
        Image image = null;
        byte[] byArray = new byte[512];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8096);
        try {
            try {
                int n;
                while ((n = inputStream.read(byArray, 0, 512)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                byArray = null;
                Object var7_8 = null;
                image = byArray == null ? UIModule.ErrImg(component) : UIModule.CreateImageFromBytes(byArray, component);
            }
            Object var7_7 = null;
            image = byArray == null ? UIModule.ErrImg(component) : UIModule.CreateImageFromBytes(byArray, component);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            image = byArray == null ? UIModule.ErrImg(component) : UIModule.CreateImageFromBytes(byArray, component);
            throw throwable;
        }
        return image;
    }

    public static Image LoadImageFromZip(URL uRL, String string, Component component) {
        byte[] byArray = IOUtility.ReadStreamFromZip(uRL, string);
        return byArray == null ? UIModule.ErrImg(component) : UIModule.CreateImageFromBytes(byArray, component);
    }

    protected static Image ErrImg(Component component) {
        try {
            byte[] byArray = IOUtility.ReadFitfullyAsBinary(UIModule.GetClassByLiteral("com/mylyane/afx/UIModule").getResource("err.gif"));
            Image image = UIModule.CreateImageFromBytes(byArray, component);
            return UIModule.WaitForImage(image.getScaledInstance(22, 22, 4), component);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        try {
            EQ = g_CURRENT_KIT.getSystemEventQueue();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        IMG_HOLDER = new Image[1];
    }
}

