/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.afx.swing.tree;

import com.mylyane.afx.IUniversalProvider;
import com.mylyane.afx.swing.tree.ITreeIconResolver;
import com.mylyane.afx.swing.tree.TreeNodeContext;
import com.mylyane.ui.swing.PopupMenuManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class JTreeCellEditor
extends DefaultTreeCellEditor {
    protected transient PopupMenuManager ed_pop;
    protected IUniversalProvider pprovider;
    protected ITreeIconResolver icon_resolver;
    private int ask_meaning;

    public JTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
        super(jTree, defaultTreeCellRenderer, treeCellEditor);
    }

    public JTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        super(jTree, defaultTreeCellRenderer, null);
    }

    public void setAskMeaning(int n) {
        this.ask_meaning = n;
    }

    public void setTreeIconResolver(ITreeIconResolver iTreeIconResolver) {
        this.icon_resolver = iTreeIconResolver;
    }

    public void setProvider(IUniversalProvider iUniversalProvider) {
        this.pprovider = iUniversalProvider;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.pprovider = null;
        this.icon_resolver = null;
    }

    protected TreeCellEditor createTreeCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        DefaultTreeCellEditor.DefaultTextField defaultTextField = new DefaultTreeCellEditor.DefaultTextField(this, border);
        PopupMenuManager popupMenuManager = PopupMenuManager.ForTextEditorPopup();
        popupMenuManager.setTargetComponent(defaultTextField);
        this.ed_pop = popupMenuManager;
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(defaultTextField);
        defaultCellEditor.setClickCountToStart(1);
        return defaultCellEditor;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.setTree(jTree);
        this.lastRow = n;
        this.determineOffset(jTree, object, bl, bl2, bl3, n);
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        Font font = this.getFont();
        if (font == null) {
            if (this.renderer != null) {
                font = this.renderer.getFont();
            }
            if (font == null) {
                font = this.tree.getFont();
            }
        }
        this.editingContainer.setFont(font);
        this.prepareForEditing();
        return this.editingContainer;
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        Icon icon;
        this.editingIcon = icon = this.icon_resolver.resolveIcon(new TreeNodeContext(object, bl3, bl2, bl, true));
        DefaultTreeCellRenderer defaultTreeCellRenderer = this.renderer;
        int n2 = 0;
        if (defaultTreeCellRenderer != null) {
            n2 = icon != null ? defaultTreeCellRenderer.getIconTextGap() + icon.getIconWidth() : defaultTreeCellRenderer.getIconTextGap();
        }
        this.offset = n2;
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            return mouseEvent.getClickCount() > 1 && this.pprovider.ask(treePath.getLastPathComponent(), this.ask_meaning);
        }
        return eventObject == null;
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl;
        if (!this.realEditor.isCellEditable(eventObject)) {
            return false;
        }
        boolean bl2 = false;
        if (eventObject != null && eventObject.getSource() instanceof JTree) {
            this.setTree((JTree)eventObject.getSource());
            if (eventObject instanceof MouseEvent) {
                TreePath treePath = this.tree.getPathForLocation(((MouseEvent)eventObject).getX(), ((MouseEvent)eventObject).getY());
                boolean bl3 = bl2 = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
            }
        }
        if ((bl = this.canEditImmediately(eventObject)) && bl2 && this.shouldStartEditingTimer(eventObject)) {
            this.prepareForEditing();
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        return bl;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1000, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }
}

