/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.afx.swing.tree;

import com.mylyane.afx.swing.tree.ITreeIconResolver;
import com.mylyane.afx.swing.tree.TreeNodeContext;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class JTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected ITreeIconResolver icon_resolver;

    public JTreeCellRenderer() {
        this((ITreeIconResolver)null);
    }

    public JTreeCellRenderer(ITreeIconResolver iTreeIconResolver) {
        this(UIManager.getIcon("Tree.openIcon"), UIManager.getIcon("Tree.closedIcon"), UIManager.getIcon("Tree.leafIcon"), iTreeIconResolver);
    }

    public JTreeCellRenderer(Icon icon, Icon icon2, Icon icon3, ITreeIconResolver iTreeIconResolver) {
        this.setLeafIcon(icon3);
        this.setClosedIcon(icon2);
        this.setOpenIcon(icon);
        this.icon_resolver = iTreeIconResolver;
    }

    public void setTreeIconResolver(ITreeIconResolver iTreeIconResolver) {
        this.icon_resolver = iTreeIconResolver;
    }

    protected void finalize() {
        this.closedIcon = null;
        this.leafIcon = null;
        this.openIcon = null;
        this.icon_resolver = null;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Icon icon;
        this.setText(jTree.convertValueToText(object, bl, bl2, bl3, n, bl4));
        this.hasFocus = bl4;
        super.setForeground(bl ? super.getTextSelectionColor() : super.getTextNonSelectionColor());
        boolean bl5 = jTree.isEnabled();
        if (this.icon_resolver != null) {
            icon = this.icon_resolver.resolveIcon(new TreeNodeContext(object, bl3, bl2, bl, false));
        } else {
            Icon icon2 = bl3 ? this.getLeafIcon() : (icon = bl2 ? this.getOpenIcon() : this.getClosedIcon());
        }
        if (!bl5) {
            this.setDisabledIcon(icon);
        } else {
            this.setIcon(icon);
        }
        super.setEnabled(bl5);
        super.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }
}

