/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.io;

import com.mylyane.lang.CharsBuffer;
import java.io.IOException;
import java.io.Reader;

public final class QuickBufferedReader
extends Reader {
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    public static int DEFAULT_BUFFERING = 8192;
    private Reader in;
    private char[] cb;
    private int m_rcc;
    private int current_idx;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skip_lf = false;
    private boolean markedSkipLF = false;
    private CharsBuffer line_buf;

    public QuickBufferedReader(Reader reader, int n) {
        super((Object)reader);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.attach(reader, n);
    }

    public QuickBufferedReader(Reader reader) {
        this(reader, DEFAULT_BUFFERING);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.current_idx - this.markedChar;
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, n);
                    this.markedChar = 0;
                    n2 = n;
                } else {
                    char[] cArray = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, cArray, 0, n);
                    this.cb = cArray;
                    this.markedChar = 0;
                    n2 = n;
                }
                this.current_idx = this.m_rcc = n;
            }
        }
        while ((n = this.in.read(this.cb, n2, this.cb.length - n2)) == 0) {
        }
        if (n > 0) {
            this.m_rcc = n2 + n;
            this.current_idx = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.current_idx >= this.m_rcc) {
                    this.fill();
                    if (this.current_idx >= this.m_rcc) {
                        return -1;
                    }
                }
                if (!this.skip_lf) break;
                this.skip_lf = false;
                if (this.cb[this.current_idx] != '\n') break;
                ++this.current_idx;
            }
            return this.cb[this.current_idx++];
        }
    }

    private int read1(char[] cArray, int n, int n2) throws IOException {
        if (this.current_idx >= this.m_rcc) {
            if (n2 >= this.cb.length && this.markedChar <= -1 && !this.skip_lf) {
                return this.in.read(cArray, n, n2);
            }
            this.fill();
        }
        if (this.current_idx >= this.m_rcc) {
            return -1;
        }
        if (this.skip_lf) {
            this.skip_lf = false;
            if (this.cb[this.current_idx] == '\n') {
                ++this.current_idx;
                if (this.current_idx >= this.m_rcc) {
                    this.fill();
                }
                if (this.current_idx >= this.m_rcc) {
                    return -1;
                }
            }
        }
        int n3 = Math.min(n2, this.m_rcc - this.current_idx);
        System.arraycopy(this.cb, this.current_idx, cArray, n, n3);
        this.current_idx += n3;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n4 = this.read1(cArray, n, n2);
            if (n4 <= 0) {
                return n4;
            }
            while (n4 < n2 && this.in.ready() && (n3 = this.read1(cArray, n + n4, n2 - n4)) > 0) {
                n4 += n3;
            }
            return n4;
        }
    }

    public String readLine() throws IOException {
        char[] cArray = this.readLineChars();
        return cArray == null ? null : new String(cArray);
    }

    public char[] readLineChars() throws IOException {
        CharsBuffer charsBuffer = this.line_buf;
        Object object = this.lock;
        synchronized (object) {
            char c;
            boolean bl;
            charsBuffer.flush();
            this.ensureOpen();
            do {
                if (this.current_idx >= this.m_rcc) {
                    this.fill();
                }
                if (this.current_idx >= this.m_rcc) {
                    return charsBuffer.length() > 0 ? charsBuffer.getValues(true) : null;
                }
                char[] cArray = this.cb;
                int n = this.current_idx;
                if (!this.skip_lf || cArray[n] == '\n') {
                    // empty if block
                }
                this.skip_lf = false;
                bl = false;
                c = '\u0000';
                int n2 = ++n;
                while (n < this.m_rcc) {
                    c = cArray[n];
                    if (c == '\n' || c == '\r') {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                this.current_idx = n;
                charsBuffer.add(cArray, n2, n - n2);
            } while (!bl);
            ++this.current_idx;
            if (c == '\r') {
                this.skip_lf = true;
            }
            return charsBuffer.getValues(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        if (l < 0L) {
            return 0L;
        }
        Object object = this.lock;
        synchronized (object) {
            long l2;
            long l3;
            this.ensureOpen();
            for (l2 = l; l2 > 0L; l2 -= l3) {
                if (this.current_idx >= this.m_rcc) {
                    this.fill();
                }
                if (this.current_idx >= this.m_rcc) break;
                if (this.skip_lf) {
                    this.skip_lf = false;
                    if (this.cb[this.current_idx] == '\n') {
                        ++this.current_idx;
                    }
                }
                if (l2 <= (l3 = (long)(this.m_rcc - this.current_idx))) {
                    this.current_idx = (int)((long)this.current_idx + l2);
                    l2 = 0L;
                    break;
                }
                this.current_idx = this.m_rcc;
            }
            return l - l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.skip_lf) {
                if (this.current_idx >= this.m_rcc && this.in.ready()) {
                    this.fill();
                }
                if (this.current_idx < this.m_rcc) {
                    if (this.cb[this.current_idx] == '\n') {
                        ++this.current_idx;
                    }
                    this.skip_lf = false;
                }
            }
            return this.current_idx < this.m_rcc || this.in.ready();
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.readAheadLimit = n;
            this.markedChar = this.current_idx;
            this.markedSkipLF = this.skip_lf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
            }
            this.current_idx = this.markedChar;
            this.skip_lf = this.markedSkipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.in != null) {
                    this.in.close();
                }
                this.detach();
                this.lock = null;
            }
        }
    }

    public void detach() {
        this.in = null;
        this.cb = null;
        this.initInternal(false);
    }

    public void attach(Reader reader, int n) {
        this.in = reader;
        this.m_rcc = 0;
        this.current_idx = 0;
        this.cb = new char[n];
        this.markedSkipLF = false;
        this.skip_lf = false;
        this.initInternal(true);
    }

    private void initInternal(boolean bl) {
        if (!bl) {
            if (this.line_buf != null) {
                CharsBuffer.Replace(this.line_buf);
                this.line_buf = null;
            }
        } else if (this.line_buf == null) {
            this.line_buf = CharsBuffer.GetShared(512);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

