/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.lang;

public final class CharUtility {
    static final char[] DIGITS = "0123456789ABCDEF".toCharArray();

    private CharUtility() {
    }

    public static boolean Contains(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        int n2 = cArray2.length - n;
        if (n2 >= 0) {
            int n3 = -1;
            char c = cArray[0];
            while (true) {
                if (cArray2[++n3] != c) {
                    if (n3 != n2) continue;
                    return false;
                }
                if (n == 1) {
                    return true;
                }
                int n4 = 1;
                while (cArray[n4++] == cArray2[++n3]) {
                    if (n4 < n) continue;
                    return true;
                }
                if (n3 >= n2) break;
            }
        }
        return false;
    }

    public static boolean CompChars(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        if (cArray2.length != n) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (cArray[n2] != cArray2[n3]) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    public static boolean CheckContained(char[] cArray, int n, int n2, char c) {
        while (n < n2 && cArray[n] != c) {
            ++n;
        }
        return n != n2;
    }

    public static char[] ConvertSingle(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return cArray;
    }

    public static final int CountChar(char[] cArray, char c) {
        if (cArray == null) {
            return -1;
        }
        if (cArray.length == 0) {
            return 0;
        }
        return CharUtility.CountChar(cArray, c, 0, cArray.length);
    }

    public static final int CountChar(char[] cArray, char c, int n, int n2) {
        try {
            int n3 = 0;
            while (n < n2) {
                if (cArray[n++] != c) continue;
                ++n3;
            }
            return n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            return -1;
        }
    }

    public static char[] RepeatChar(int n, char c) {
        char[] cArray = new char[n];
        while (n-- > 0) {
            cArray[n] = c;
        }
        return cArray;
    }

    public static int RepeatChar(char[] cArray, int n, int n2, char c) {
        while (n2-- > 0) {
            cArray[n++] = c;
        }
        return n;
    }

    public static int CopyChars(char[] cArray, char[] cArray2, int n) {
        int n2 = cArray.length;
        int n3 = 0;
        do {
            cArray2[n++] = cArray[n3++];
        } while (n3 < n2);
        return n;
    }

    public static char[] GetChars(String string, int n, int n2) {
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        string.getChars(n, n2, cArray, 0);
        return cArray;
    }

    public static char[] GetChars(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2 - n];
        int n3 = 0;
        while (n < n2) {
            cArray2[n3] = cArray[n];
            ++n3;
            ++n;
        }
        return cArray2;
    }

    public static char[] Combine(char[][] cArray) {
        char[] cArray2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = cArray.length;
        do {
            if ((cArray2 = cArray[n++]) == null) continue;
            n3 += cArray2.length;
        } while (n < n4);
        char[] cArray3 = new char[n3];
        n = 0;
        do {
            int n5 = 0;
            if ((cArray2 = cArray[n++]) == null) continue;
            n3 = cArray2.length;
            do {
                cArray3[n2++] = cArray2[n5++];
            } while (n5 < n3);
        } while (n < n4);
        return cArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String CombineToString(char[][] cArray) {
        char[] cArray2;
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        int n4 = 0;
        do {
            if ((cArray2 = cArray[n++]) == null) continue;
            n4 += cArray2.length;
        } while (n < n3);
        cArray2 = new char[n4];
        n = 0;
        char[] cArray3 = cArray2;
        synchronized (cArray2) {
            do {
                char[] cArray4;
                int n5 = 0;
                if ((cArray4 = cArray[n++]) == null) continue;
                int n6 = cArray4.length;
                do {
                    cArray2[n2++] = cArray4[n5++];
                } while (n5 < n6);
            } while (n < n3);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return new String(cArray2, 0, n4);
        }
    }

    public static int IndexOf(char[] cArray, char[] cArray2) {
        return CharUtility.IndexOf(cArray, cArray2, 0);
    }

    public static int IndexOf(char[] cArray, char[] cArray2, int n) {
        int n2 = cArray.length;
        int n3 = cArray2.length - n2;
        if (n3 >= 0) {
            char c = cArray[0];
            while (true) {
                if (cArray2[n] != c) {
                    if (n++ != n3) continue;
                    return -1;
                }
                if (n2 == 1) {
                    return n;
                }
                int n4 = 1;
                while (cArray[n4++] == cArray2[++n]) {
                    if (n4 < n2) continue;
                    return n - (n2 - 1);
                }
                if (n >= n3) break;
            }
        }
        return -1;
    }

    public static int LastIndexOf(char[] cArray, char[] cArray2) {
        return CharUtility.LastIndexOf(cArray, cArray2, cArray2.length);
    }

    public static int LastIndexOf(char[] cArray, char[] cArray2, int n) {
        int n2 = cArray.length;
        int n3 = n2 - 1;
        if (n < n2) {
            return -1;
        }
        char c = cArray[n3];
        while (true) {
            if (cArray2[--n] != c) {
                if (n > n3) continue;
                return -1;
            }
            if (n3 == 0) {
                return n;
            }
            int n4 = n3;
            while (cArray[--n4] == cArray2[--n]) {
                if (n4 > 0) continue;
                return n;
            }
            if (++n <= n3) break;
        }
        return -1;
    }

    public static int IndexOfChar(char[] cArray, char c) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int IndexOfChar(char[] cArray, char c, int n) {
        int n2 = cArray.length;
        while (n < n2) {
            if (cArray[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int LastIndexOfChar(char[] cArray, char c) {
        int n;
        for (n = cArray.length - 1; n >= 0; --n) {
            if (cArray[n] != c) continue;
            return n;
        }
        return n;
    }

    public static char[] Replace(char[] cArray, char c, char c2) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            cArray[i] = c2;
        }
        return cArray;
    }

    public static final boolean IsLastOf(char[] cArray, char c) {
        return cArray[cArray.length - 1] == c;
    }

    public static char[] ToUnicodeCharsFromAnsi(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i++] = (char)byArray[i];
        }
        return cArray;
    }

    public static int ComputeUnicodeLengthEx(byte[] byArray) {
        int n = byArray.length;
        int n2 = 255;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            int n5;
            if ((n5 = byArray[n3++] & n2) < 14) {
                ++n4;
            } else if (n5 > 127) {
                if (n5 > 223) {
                    n3 += 2;
                } else if (n5 == 192 || (byArray[n3] & n2) == 128) {
                    ++n3;
                    ++n4;
                } else {
                    ++n3;
                }
            }
            ++n4;
        }
        return n4;
    }

    public static int ComputeUnicodeLength(byte[] byArray) {
        int n = byArray.length;
        int n2 = 255;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            int n5;
            if ((n5 = byArray[n3++] & n2) > 127) {
                n3 = n5 > 223 ? (n3 += 2) : ++n3;
            }
            ++n4;
        }
        return n4;
    }

    public static char FilterCtrl(int n) {
        return (char)(n == 8 ? 98 : (n == 9 ? 116 : (n == 10 ? 110 : (n == 13 ? 114 : 0))));
    }

    public static char ToCtrl(int n) {
        return (char)(n == 102 ? 12 : (n == 98 ? 8 : (n == 116 ? 9 : (n == 110 ? 10 : (n == 114 ? 13 : 0)))));
    }

    public static char[] Trim(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    public static int CountCTRLChar(byte[] byArray) {
        byte by = 14;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            byte by2 = byArray[i];
            if (by2 >= by || by2 <= 7 || by2 == 11 || by2 == 12) continue;
            ++n;
        }
        return n;
    }

    public static String ToStringFromUtf(byte[] byArray) {
        return new String(CharUtility.ToUnicodeCharsFromUtf(byArray));
    }

    public static char[] ToUnicodeCharsFromUtf(byte[] byArray) {
        int n = byArray.length;
        int n2 = 255;
        int n3 = 15;
        int n4 = 63;
        int n5 = CharUtility.ComputeUnicodeLengthEx(byArray);
        char[] cArray = new char[n5];
        int n6 = 0;
        int n7 = 0;
        while (n6 < n) {
            int n8;
            int n9;
            int n10;
            if ((n10 = byArray[n6++] & n2) < 14) {
                n9 = CharUtility.FilterCtrl(n10);
                cArray[n7++] = 92;
                n8 = n9 != 0 ? n9 : 48 + n10;
            } else if (n10 > 127) {
                n9 = byArray[n6++] & n2;
                if (n10 > 223) {
                    int n11 = byArray[n6++] & n2;
                    n8 = ((n10 & n3) << 12) + ((n9 & n4) << 6) + (n11 & n4);
                } else {
                    n8 = ((n10 & 0x1F) << 6) + (n9 & n4);
                }
                if (n8 == 0) {
                    cArray[n7++] = 92;
                    n8 = 48;
                }
            } else {
                n8 = n10;
            }
            cArray[n7] = (char)n8;
            ++n7;
        }
        if (n7 < n5) {
            return CharUtility.Trim(cArray, n7);
        }
        return cArray;
    }

    public static char[] ToUnicodeCharsFromUtfDefault(byte[] byArray) {
        int n = byArray.length;
        int n2 = 255;
        int n3 = 15;
        int n4 = 63;
        char[] cArray = new char[n];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            int n7;
            int n8;
            if ((n8 = byArray[n5++] & n2) > 127) {
                int n9 = byArray[n5++] & n2;
                if (n8 > 223) {
                    int n10 = byArray[n5++] & n2;
                    n7 = ((n8 & n3) << 12) + ((n9 & n4) << 6) + (n10 & n4);
                } else {
                    n7 = ((n8 & 0x1F) << 6) + (n9 & n4);
                }
            } else {
                n7 = n8;
            }
            cArray[n6] = (char)n7;
            ++n6;
        }
        if (n6 < n) {
            return CharUtility.Trim(cArray, n6);
        }
        return cArray;
    }

    public static char[] UTF8ToUnicodeEscape(byte[] byArray) {
        return CharUtility.ToUnicodeEscape(CharUtility.ToUnicodeCharsFromUtfDefault(byArray));
    }

    public static char[] ToUnicodeEscape(char[] cArray) {
        int n = cArray.length;
        int n2 = n * 6;
        char[] cArray2 = new char[n2];
        char[] cArray3 = DIGITS;
        int n3 = 0;
        int n4 = 0;
        int n5 = 61440;
        while (n4 < n) {
            char c;
            if ((c = cArray[n4++]) > '\u007f' || c < '\t') {
                cArray2[n3++] = 92;
                cArray2[n3++] = 117;
                int n6 = 12;
                do {
                    int n7 = (c & n5) >>> n6;
                    cArray2[n3++] = cArray3[n7 & 0xF];
                    n6 -= 4;
                } while ((n5 >>>= 4) != 0);
                n5 = 61440;
                continue;
            }
            cArray2[n3++] = c;
        }
        return n3 < n2 ? CharUtility.Trim(cArray2, n3) : cArray2;
    }

    public static String ReleaseUnicodeEscapeIf(String string, boolean bl) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        do {
            int n4;
            if ((n4 = cArray[n2]) == 92 && n2 + 1 < n) {
                int n5;
                char c = cArray[n2 + 1];
                if (c == 'u' && n2 + 5 < n) {
                    n5 = 12;
                    int n6 = 0;
                    ++n2;
                    do {
                        int n7;
                        n7 = ((n7 = cArray[++n2]) & 0x30) == 48 ? (n7 -= 48) : ((n7 & 0x60) == 96 ? (n7 -= 87) : (n7 -= 55));
                        n6 |= n7 << n5;
                    } while ((n5 -= 4) >= 0);
                    n4 = (char)n6;
                } else if (bl && (n5 = CharUtility.ToCtrl(c)) != 0) {
                    n4 = n5;
                    ++n2;
                }
            }
            cArray[n3++] = n4;
        } while (++n2 < n);
        if (n3 < n) {
            return new String(cArray, 0, n3);
        }
        return string;
    }

    public static char[] TranslateFor(char[] cArray, boolean bl) {
        char c;
        char c2;
        int n = cArray.length;
        int n2 = 32;
        if (bl) {
            c2 = '`';
            c = '{';
        } else {
            c2 = '@';
            c = '[';
        }
        for (int i = 0; i < n; ++i) {
            char c3 = cArray[i];
            if (c3 <= c2 || c3 >= c) continue;
            if (bl) {
                int n3 = i;
                cArray[n3] = (char)(cArray[n3] ^ n2);
                continue;
            }
            int n4 = i;
            cArray[n4] = (char)(cArray[n4] | n2);
        }
        return cArray;
    }

    public static char[] ToBoolChars(boolean bl) {
        char[] cArray;
        if (bl) {
            char[] cArray2 = new char[4];
            cArray2[0] = 116;
            cArray2[1] = 114;
            cArray2[2] = 117;
            cArray = cArray2;
            cArray2[3] = 101;
        } else {
            char[] cArray3 = new char[5];
            cArray3[0] = 102;
            cArray3[1] = 97;
            cArray3[2] = 108;
            cArray3[3] = 115;
            cArray = cArray3;
            cArray3[4] = 101;
        }
        return cArray;
    }

    public static int DecodeBase64Char(char c) {
        return c >= 'A' && c <= 'Z' ? c - 65 : (c >= 'a' && c <= 'z' ? c - 71 : (c >= '0' && c <= '9' ? c + 4 : (c == '+' ? 62 : (c == '/' ? 63 : -1))));
    }

    public static int Base64Decode(char[] cArray, int n, byte[] byArray) {
        if (cArray == null || byArray == null) {
            throw new NullPointerException("!Decode data or out buffer is null");
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5;
            int n6 = 0;
            int n7 = 0;
            for (n5 = 0; n5 < 4 && n2 < n; ++n5) {
                n4 = CharUtility.DecodeBase64Char(cArray[n2]);
                ++n2;
                if (n4 == -1) {
                    --n5;
                    continue;
                }
                n6 <<= 6;
                n6 |= n4;
                n7 += 6;
            }
            n6 <<= 24 - n7;
            n4 = n7 / 8;
            for (n5 = 0; n5 < n4; ++n5) {
                byArray[n3++] = (byte)((n6 & 0xFF0000) >> 16);
                n6 <<= 8;
            }
        }
        return n3;
    }

    public static byte[] Decode64(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = CharUtility.Base64Decode(string.toCharArray(), n, byArray);
        if (n2 <= 0) {
            return new byte[0];
        }
        if (n2 < n) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }
}

