/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.lang;

import com.mylyane.afx.IFactory;
import com.mylyane.lang.CharUtility;
import com.mylyane.util.IDumpable;
import com.mylyane.util.MultiPool;
import com.mylyane.util.QON;
import java.io.PrintStream;
import java.io.Serializable;

public final class CharsBuffer
implements Serializable,
IDumpable {
    private static CharsBuffer _RP;
    private static MultiPool POOL;
    char[] value;
    int count;
    int peek_max;
    private boolean b_pooled;

    public static CharsBuffer GetShared(int n) {
        CharsBuffer charsBuffer = (CharsBuffer)POOL.get();
        char[] cArray = charsBuffer.value;
        if (cArray == null || cArray.length < n) {
            charsBuffer.value = new char[n];
        }
        charsBuffer.count = 0;
        return charsBuffer;
    }

    public static void Replace(CharsBuffer charsBuffer) {
        POOL.replace(charsBuffer);
    }

    public static synchronized void DumpShared() {
        MultiPool multiPool = POOL;
        Object[] objectArray = multiPool.getPoolSnap();
        if (objectArray.length == 0) {
            System.out.println("pool is empty...");
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            CharsBuffer charsBuffer = (CharsBuffer)objectArray[i];
            CharsBuffer._dump(charsBuffer);
        }
        System.gc();
        System.runFinalization();
    }

    private static void _dump(CharsBuffer charsBuffer) {
        if (charsBuffer == null) {
            System.out.println("client is null..");
            return;
        }
        int n = charsBuffer.value == null ? -1 : charsBuffer.value.length;
        CharsBuffer._print_db("   Report:[capacity = ", n, charsBuffer.peek_max);
    }

    private static final void _print_db(String string, int n, int n2) {
        CharsBuffer charsBuffer = _RP;
        if (charsBuffer == null) {
            _RP = charsBuffer = new CharsBuffer(256);
        }
        charsBuffer.append(string).append(QON.toCharArray(n)).append(", peek = ").append(QON.toCharArray(n2)).add(']');
        System.out.println(charsBuffer.flushToString());
    }

    CharsBuffer() {
    }

    private void updatePeek() {
        if (this.count > this.peek_max) {
            this.peek_max = this.count;
        }
    }

    public CharsBuffer(int n) {
        if (n > 0) {
            this.value = new char[n];
        }
    }

    public CharsBuffer(String string) {
        this(string.length() + 128);
        this.add(string);
    }

    public CharsBuffer(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2 + 16];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        this.value = cArray2;
        this.count = n2;
    }

    public synchronized int length() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value == null ? -1 : this.value.length;
    }

    public synchronized void terminate(boolean bl) {
        if (bl) {
            CharsBuffer._dump(this);
        }
        this.count = 0;
        this.value = null;
    }

    public synchronized void flush() {
        int n = this.count;
        this.count = 0;
        if (n > this.peek_max) {
            this.peek_max = n;
        }
    }

    public synchronized void seek(int n, boolean bl) {
        if (!bl) {
            n = this.count + n;
        }
        if (n < 0 || n > this.value.length) {
            throw new ArrayIndexOutOfBoundsException("pos value is invalid.");
        }
        this.count = n;
    }

    public synchronized void resize(float f) {
        if (f <= 0.0f) {
            return;
        }
        char[] cArray = this.value;
        int n = (int)((float)cArray.length * f);
        int n2 = this.count;
        if (n < n2) {
            n2 = n;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        this.value = cArray2;
        this.count = n2;
    }

    public synchronized void allocate(int n) {
        this.count = 0;
        this.value = null;
        this.grow(n);
    }

    private void grow(int n) {
        int n2;
        char[] cArray = this.value;
        if (cArray != null) {
            n2 = cArray.length << 1;
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            } else if (n > n2) {
                n2 = n;
            }
        } else {
            n2 = n;
        }
        char[] cArray2 = new char[n2];
        if (cArray != null) {
            System.arraycopy(cArray, 0, cArray2, 0, this.count);
        }
        this.value = cArray2;
    }

    private char[] growIf(int n) {
        char[] cArray = this.value;
        if (n > cArray.length) {
            this.grow(n);
            cArray = this.value;
        }
        return cArray;
    }

    public synchronized char charAt(int n) {
        return this.value[n];
    }

    public synchronized void setCharAt(int n, char c) {
        this.value[n] = c;
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public synchronized char[] getValues(boolean bl) {
        char[] cArray;
        if (bl) {
            int n = this.count;
            cArray = new char[n];
            System.arraycopy(this.value, 0, cArray, 0, n);
        } else {
            cArray = this.value;
        }
        this.updatePeek();
        return cArray;
    }

    public synchronized char[] getRange(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        System.arraycopy(this.value, n, cArray, 0, n3);
        return cArray;
    }

    public CharsBuffer append(Object object) {
        return this.append(object == null ? "null" : object.toString());
    }

    public void add(Object object) {
        this.add(object == null ? "null" : object.toString());
    }

    public void addLine(Object object) {
        this.addLine(object == null ? "null" : object.toString());
    }

    public CharsBuffer appendLine(Object object) {
        return this.appendLine(object == null ? "null" : object.toString());
    }

    public CharsBuffer append(String string) {
        this.add(string);
        return this;
    }

    public CharsBuffer append(String string, int n, int n2) {
        this.add(string, n, n2);
        return this;
    }

    public void add(String string) {
        if (string == null) {
            string = "null";
        }
        this.add(string, 0, string.length());
    }

    public synchronized void add(String string, int n, int n2) {
        int n3 = n2 - n;
        int n4 = this.count;
        int n5 = n4 + n3;
        char[] cArray = this.growIf(n5);
        string.getChars(n, n + n3, cArray, n4);
        this.count = n5;
    }

    public synchronized void addLine(String string) {
        int n = string.length();
        int n2 = this.count;
        int n3 = n2 + n + 1;
        char[] cArray = this.growIf(n3);
        string.getChars(0, n, cArray, n2);
        this.count = n3;
        cArray[n3 - 1] = 10;
    }

    public CharsBuffer appendLine(String string) {
        this.addLine(string);
        return this;
    }

    public void addLine(char[] cArray) {
        this.add(cArray, 0, cArray.length);
        this.add('\n');
    }

    public CharsBuffer appendLine(char[] cArray) {
        this.add(cArray, 0, cArray.length);
        return this.append('\n');
    }

    public CharsBuffer append(char[] cArray, int n, int n2) {
        this.add(cArray, n, n2);
        return this;
    }

    public void add(char[] cArray) {
        this.add(cArray, 0, cArray.length);
    }

    public synchronized void add(char[] cArray, int n, int n2) {
        int n3 = this.count;
        int n4 = n3 + n2;
        char[] cArray2 = this.value;
        if (n4 > cArray2.length) {
            this.grow(n4);
            cArray2 = this.value;
        }
        System.arraycopy(cArray, n, cArray2, n3, n2);
        this.count = n4;
    }

    public CharsBuffer append(char[] cArray) {
        this.add(cArray, 0, cArray.length);
        return this;
    }

    public CharsBuffer append(char c) {
        this.add(c);
        return this;
    }

    public synchronized void add(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.grow(n);
        }
        this.value[n - 1] = c;
        this.count = n;
    }

    public synchronized void addLine(char c) {
        int n = this.count + 2;
        if (n > this.value.length) {
            this.grow(n);
        }
        char[] cArray = this.value;
        cArray[n - 2] = c;
        cArray[n - 1] = 10;
        this.count = n;
    }

    public CharsBuffer appendLine(char c) {
        this.addLine(c);
        return this;
    }

    public void add(int n) {
        this.add(QON.toCharArray(n));
    }

    public CharsBuffer append(int n) {
        this.add(QON.toCharArray(n));
        return this;
    }

    public CharsBuffer append(long l) {
        this.add(Long.toString(l));
        return this;
    }

    public CharsBuffer appendLine(long l) {
        return this.appendLine(Long.toString(l));
    }

    public CharsBuffer append(float f) {
        this.add(Float.toString(f));
        return this;
    }

    public CharsBuffer appendLine(float f) {
        return this.appendLine(Float.toString(f));
    }

    public CharsBuffer append(double d) {
        this.add(Double.toString(d));
        return this;
    }

    public CharsBuffer appendLine(double d) {
        return this.appendLine(Double.toString(d));
    }

    public CharsBuffer append(boolean bl) {
        return this.append(CharUtility.ToBoolChars(bl));
    }

    public CharsBuffer appendLine(boolean bl) {
        return this.appendLine(CharUtility.ToBoolChars(bl));
    }

    public synchronized void replace(int n, int n2, String string) {
        int n3 = this.count;
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = string.length();
        int n5 = n3 + n4 - (n2 - n);
        if (n5 > this.value.length) {
            this.grow(n5);
        }
        System.arraycopy(this.value, n2, this.value, n + n4, n3 - n2);
        string.getChars(0, n4, this.value, n);
        this.count = n5;
    }

    public synchronized void replace(int n, int n2, char[] cArray) {
        int n3;
        if (cArray == null || (n3 = cArray.length) == 0) {
            return;
        }
        int n4 = this.count;
        if (n2 > n4) {
            n2 = n4;
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n5 = n4 + n3 - (n2 - n);
        if (n5 > this.value.length) {
            this.grow(n5);
        }
        char[] cArray2 = this.value;
        System.arraycopy(cArray2, n2, cArray2, n + n3, n4 - n2);
        n4 = 0;
        do {
            cArray2[n++] = cArray[n4++];
        } while (n4 < n3);
        this.count = n5;
    }

    public synchronized void replace(char c, char c2) {
        if (c == c2) {
            return;
        }
        char[] cArray = this.value;
        int n = this.count;
        while (n-- > 0) {
            if (cArray[n] != c) continue;
            cArray[n] = c2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSync(char c, char[] cArray) {
        CharsBuffer charsBuffer = this;
        synchronized (charsBuffer) {
            this.replace(c, cArray);
            this.notifyAll();
        }
    }

    public void replace(char c, char[] cArray) {
        char[] cArray2 = this.value;
        int n = cArray.length;
        int n2 = 0;
        int n3 = this.count;
        do {
            if (cArray2[n2] == c) {
                int n4 = n2 + 1;
                int n5 = n3 + n - 1;
                if (n5 > cArray2.length) {
                    this.grow(n5);
                    cArray2 = this.value;
                }
                System.arraycopy(cArray2, n4, cArray2, n2 + n, n3 - n4);
                System.arraycopy(cArray, 0, cArray2, n2, n);
                n2 += n;
                n3 = n5;
                continue;
            }
            ++n2;
        } while (n2 < n3);
        this.count = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSync(String string, String string2) {
        CharsBuffer charsBuffer = this;
        synchronized (charsBuffer) {
            this.replace(string.toCharArray(), string2.toCharArray());
            this.notify();
        }
    }

    public void replace(String string, String string2) {
        this.replace(string.toCharArray(), string2.toCharArray());
    }

    public void replace(char[] cArray, char[] cArray2) {
        char[] cArray3 = this.value;
        int n = cArray.length;
        int n2 = cArray2.length;
        int n3 = 0;
        char c = cArray[0];
        int n4 = this.count;
        int n5 = n4 - (n - 1);
        block0: while (n3 < n5) {
            if (cArray3[n3++] != c) continue;
            int n6 = n3;
            int n7 = 1;
            while (n7 < n) {
                if (cArray3[n6++] == cArray[n7++]) continue;
                continue block0;
            }
            n7 = n4 + n2 - n;
            if (n7 > cArray3.length) {
                this.grow(n7);
                cArray3 = this.value;
            }
            System.arraycopy(cArray3, n6, cArray3, --n3 + n2, n4 - n6);
            System.arraycopy(cArray2, 0, cArray3, n3, n2);
            n3 += n2;
            n4 = n7;
            n5 = n4 - (n - 1);
        }
        this.count = n4;
    }

    public synchronized void repeatChar(char c, int n) {
        if (n <= 0) {
            return;
        }
        int n2 = this.count;
        int n3 = n2 + n;
        if (n3 > this.value.length) {
            this.grow(n3);
        }
        char[] cArray = this.value;
        while (n-- > 0) {
            cArray[n2++] = c;
        }
        this.count = n2;
    }

    public synchronized CharsBuffer insert(int n, String string) {
        int n2;
        int n3;
        int n4;
        if (string == null) {
            string = "null";
        }
        if ((n4 = (n3 = this.count) + (n2 = string.length())) > this.value.length) {
            this.grow(n4);
        }
        System.arraycopy(this.value, n, this.value, n + n2, n3 - n);
        string.getChars(0, n2, this.value, n);
        this.count = n4;
        return this;
    }

    public synchronized CharsBuffer insert(int n, char c) {
        int n2 = this.count;
        int n3 = n2 + 1;
        if (n3 > this.value.length) {
            this.grow(n3);
        }
        System.arraycopy(this.value, n, this.value, n + 1, n2 - n);
        this.value[n] = c;
        this.count = n3;
        return this;
    }

    public synchronized CharsBuffer insert(int n, char[] cArray, int n2, int n3) {
        int n4 = this.count;
        int n5 = n4 + n3;
        if (n5 > this.value.length) {
            this.grow(n5);
        }
        System.arraycopy(this.value, n, this.value, n + n3, n4 - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count = n5;
        return this;
    }

    public synchronized CharsBuffer appendFrom(int n, Object object) {
        int n2;
        if (object == null) {
            return this;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > (n2 = this.count)) {
            n = n2;
        }
        this.count = n;
        if (object instanceof char[]) {
            char[] cArray = (char[])object;
            this.add(cArray, 0, cArray.length);
        } else {
            String string = object.toString();
            this.add(string, 0, string.length());
        }
        return this;
    }

    public String[] splitByChar(char c) {
        char[] cArray = this.value;
        int n = this.count;
        int n2 = CharUtility.CountChar(cArray, c, 0, n);
        if (n2 > 0) {
            String[] stringArray = new String[n2 + 1];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                if (cArray[n3] != c) {
                    ++n3;
                    continue;
                }
                stringArray[n5] = new String(cArray, n4, n3 - n4);
                n4 = ++n3;
                if (++n5 >= n2) break;
            }
            stringArray[n5] = new String(cArray, n4, n - n4);
            return stringArray;
        }
        return new String[]{this.toString()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(Object[] objectArray, int n) {
        if (objectArray == null) {
            return;
        }
        char[] cArray = "{ }".toCharArray();
        cArray[1] = 48;
        int n2 = 0;
        boolean bl = true;
        CharsBuffer charsBuffer = this;
        synchronized (charsBuffer) {
            while (n2 < n) {
                char[] cArray2;
                Object object;
                if ((object = objectArray[n2++]) instanceof String) {
                    cArray2 = ((String)object).toCharArray();
                }
                cArray2 = object instanceof char[] ? (char[])object : (object instanceof Character ? new char[]{'\'', ((Character)object).charValue(), '\''} : (object == null ? "!format<arg null>".toCharArray() : object.toString().toCharArray()));
                this.replace(cArray, cArray2);
                if (n2 > 9) {
                    if (bl) {
                        cArray = "{  }".toCharArray();
                        bl = false;
                    }
                    char[] cArray3 = QON.toCharArray(n2);
                    cArray[1] = cArray3[0];
                    cArray[2] = cArray3[1];
                    continue;
                }
                cArray[1] = (char)(48 + n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatBy(String string, Object[] objectArray) {
        CharsBuffer charsBuffer = this;
        synchronized (charsBuffer) {
            int n;
            this.add(string);
            if (objectArray == null || (n = objectArray.length) == 0) {
                return;
            }
            this.format(objectArray, n);
        }
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public synchronized int indexOf(char c, int n) {
        char[] cArray = this.value;
        int n2 = this.count;
        if (n < 0) {
            n = 0;
        } else if (n > n2) {
            return -1;
        }
        while (n < n2) {
            if (cArray[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int indexOf(String string, int n) {
        return CharUtility.IndexOf(string.toCharArray(), this.value, n);
    }

    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.count);
    }

    public synchronized int lastIndexOf(char c, int n) {
        char[] cArray = this.value;
        if (n > this.count) {
            n = this.count;
        } else if (n < 0) {
            return -1;
        }
        while (n-- > 0) {
            if (cArray[n] != c) continue;
            return n;
        }
        return -1;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public synchronized String substring(int n, int n2) {
        return new String(this.value, n, n2 - n);
    }

    public String toString() {
        char[] cArray = this.value;
        if (cArray == null) {
            return "";
        }
        int n = this.count;
        String string = new String(cArray, 0, n);
        if (n > this.peek_max) {
            this.peek_max = n;
        }
        return string;
    }

    public String flushToString() {
        char[] cArray = this.value;
        if (cArray == null) {
            return "";
        }
        int n = this.count;
        String string = new String(cArray, 0, n);
        this.count = 0;
        if (n > this.peek_max) {
            this.peek_max = n;
        }
        return string;
    }

    public String shellToString() {
        char[] cArray = this.value;
        if (cArray == null) {
            return "";
        }
        this.updatePeek();
        String string = new String(cArray, 0, this.count);
        this.value = null;
        this.count = 0;
        return string;
    }

    public void dumpTo(PrintStream printStream) {
        if (printStream == null) {
            return;
        }
        String string = "\nCharsBuffer dump\n{\n\tchar value[] :{0}\n\tint count    :{1}\n\tint peek_max :{2}\n}\n";
        CharsBuffer charsBuffer = CharsBuffer.GetShared(512).append(string);
        Object[] objectArray = new Object[]{this.value, QON.toCharArray(this.count), QON.toCharArray(this.peek_max)};
        charsBuffer.format(objectArray, 3);
        printStream.println(charsBuffer.flushToString());
        CharsBuffer.Replace(charsBuffer);
    }

    protected synchronized void finalize() throws Throwable {
        if (this.b_pooled) {
            if (POOL.replace(this) == 1) {
                // empty if block
            }
            this.b_pooled = false;
        }
    }

    static {
        MultiPool multiPool = new MultiPool();
        multiPool.setFactory(new IFactory(){

            public final Object create() {
                CharsBuffer charsBuffer = new CharsBuffer();
                charsBuffer.b_pooled = true;
                return charsBuffer;
            }

            public final Class getInstanceClass() {
                return null;
            }
        });
        multiPool.initAsync(10, 2);
        POOL = multiPool;
    }
}

