/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.net;

import com.mylyane.lang.CharsBuffer;
import com.mylyane.util.IOUtility;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public abstract class URLUtility {
    public static byte[] ReadBinaryFrom(String string) throws Exception {
        return URLUtility.ReadBinaryFrom(new URL(string));
    }

    public static byte[] ReadBinaryFrom(URL uRL) throws Exception {
        InputStream inputStream = uRL.openConnection().getInputStream();
        return IOUtility.ReadFitfullyAsBinary(inputStream);
    }

    public static URL GetPhysicalURL(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1).concat(".class");
        return clazz.getResource(string);
    }

    public static URL GetPhysicalParentURL(Class clazz) {
        URL uRL = URLUtility.GetPhysicalURL(clazz);
        String string = uRL.toString();
        int n = string.lastIndexOf(47);
        string = string.substring(0, n + 1);
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public static URL CreateURLByStringString(String string, String string2, CharsBuffer charsBuffer) throws MalformedURLException {
        if (string != null && string.length() > 0) {
            charsBuffer.add(string);
            if (File.separatorChar == '\\') {
                charsBuffer.replace(File.separatorChar, '/');
            }
            if (charsBuffer.charAt(charsBuffer.length() - 1) != '/') {
                charsBuffer.add('/');
            }
        }
        if (string2 != null && string2.length() > 0) {
            charsBuffer.add(string2);
        }
        return new URL(null, charsBuffer.flushToString());
    }

    public static URL CreateURLByStringString(String string, String string2) throws MalformedURLException {
        CharsBuffer charsBuffer = CharsBuffer.GetShared(256);
        URL uRL = URLUtility.CreateURLByStringString(string, string2, charsBuffer);
        return uRL;
    }

    public static URL CreateURLByUserDir(String string) throws MalformedURLException {
        String string2 = IOUtility.CreatePathByUserDir(string);
        CharsBuffer charsBuffer = CharsBuffer.GetShared(255).append("file:").append(string2);
        if (File.separatorChar == '\\') {
            charsBuffer.replace(File.separatorChar, '/');
        }
        URL uRL = new URL(null, charsBuffer.flushToString());
        CharsBuffer.Replace(charsBuffer);
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL ToURL(String string) throws MalformedURLException {
        CharsBuffer charsBuffer;
        URL uRL;
        block7: {
            String string2 = null;
            uRL = null;
            try {
                try {
                    string2 = new File(string).getCanonicalPath();
                }
                catch (Exception exception) {
                    Object var5_4 = null;
                    if (string2 == null) return uRL;
                    CharsBuffer charsBuffer3 = CharsBuffer.GetShared(255).append("file:").append(string2);
                    if (File.separatorChar == '\\') {
                        charsBuffer3.replace(File.separatorChar, '/');
                    }
                    uRL = new URL(null, charsBuffer3.flushToString());
                    CharsBuffer.Replace(charsBuffer3);
                    return uRL;
                }
                Object var5_3 = null;
                if (string2 == null) return uRL;
                charsBuffer = CharsBuffer.GetShared(255).append("file:").append(string2);
                if (File.separatorChar != '\\') break block7;
                charsBuffer.replace(File.separatorChar, '/');
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (string2 == null) throw throwable;
                CharsBuffer charsBuffer2 = CharsBuffer.GetShared(255).append("file:").append(string2);
                if (File.separatorChar == '\\') {
                    charsBuffer2.replace(File.separatorChar, '/');
                }
                uRL = new URL(null, charsBuffer2.flushToString());
                CharsBuffer.Replace(charsBuffer2);
                throw throwable;
            }
        }
        uRL = new URL(null, charsBuffer.flushToString());
        CharsBuffer.Replace(charsBuffer);
        return uRL;
    }

    public static URLConnection GetURLConnection(String string) {
        URLConnection uRLConnection = null;
        try {
            uRLConnection = new URL(string).openConnection();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return uRLConnection;
    }
}

