/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui.swing;

import com.mylyane.afx.swing.IIconManager;
import com.mylyane.afx.swing.SwingUIModule;
import com.mylyane.util.HashtableX;
import com.mylyane.util.QON;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class PopupMenuManager
implements Serializable,
MouseListener,
ActionListener {
    private Component com;
    private JPopupMenu swing_popup;
    private HashtableX pop_table = null;

    public static PopupMenuManager ForTextEditorPopup() {
        return new PopupMenuManager("Copy|Cut|Paste|Select all", "0|1|2|3");
    }

    public PopupMenuManager(String string, String string2) {
        this(string, string2, null);
    }

    public PopupMenuManager(String string, String string2, ActionListener actionListener) {
        this.createPopupMenu(string, string2, actionListener);
    }

    private void createPopupMenu(String string, String string2, ActionListener actionListener) {
        JPopupMenu jPopupMenu = SwingUIModule.CreateJPopupByParams(string, null, actionListener != null ? actionListener : this);
        SwingUIModule.SetJMenuItemActionCommandsByParams(string2, jPopupMenu);
        this.swing_popup = jPopupMenu;
    }

    public PopupMenuManager() {
        this.swing_popup = null;
        this.com = null;
    }

    public void createAndRegister(String string, String string2, ActionListener actionListener, String string3) {
        this.createAndRegisterEx(string, string2, actionListener, null, string3);
    }

    public void createAndRegisterEx(String string, String string2, ActionListener actionListener, IIconManager iIconManager, String string3) {
        JPopupMenu jPopupMenu = SwingUIModule.CreateJPopupByParamsEx(string, string2, iIconManager, actionListener != null ? actionListener : this);
        if (this.pop_table == null) {
            this.pop_table = new HashtableX(11, 0.8f);
        }
        this.pop_table.put(string3, jPopupMenu);
    }

    public JPopupMenu getPopup(String string) {
        return (JPopupMenu)this.pop_table.get(string);
    }

    public JPopupMenu getPopupMenu() {
        return this.swing_popup;
    }

    protected void finalize() throws Throwable {
        this.com = null;
        System.out.println("PopupMenuManager finalize...");
    }

    public synchronized void setTargetComponent(Component component) {
        if (component != null) {
            component.addMouseListener(this);
        }
        if (this.com != null && this.com != component) {
            this.com.removeMouseListener(this);
        }
        this.com = component;
    }

    public Component getTargetComponent() {
        return this.com;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (QON.IsDigitString(string) && this.com instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)this.com;
            switch (string.charAt(0)) {
                case '0': {
                    jTextComponent.copy();
                    break;
                }
                case '1': {
                    jTextComponent.cut();
                    break;
                }
                case '2': {
                    jTextComponent.paste();
                    break;
                }
                case '3': {
                    jTextComponent.selectAll();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            // empty if block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            this.com = mouseEvent.getComponent();
            this.swing_popup.show(this.com, mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

