/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui.swing;

import com.mylyane.afx.IUserInputFrame;
import com.mylyane.afx.swing.SwingUIModule;
import com.mylyane.ui.swing.XTextComponentPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class SimpleTextPane
extends XTextComponentPane
implements MouseListener,
ActionListener {
    protected JTextComponent text_component;
    protected JPopupMenu popup_menu;

    public static IUserInputFrame CreateSimpleEditor(String[] stringArray) {
        return SimpleTextPane.CreateSimpleEditor("No title.", stringArray);
    }

    public static IUserInputFrame CreateSimpleEditor(String string, String[] stringArray) {
        SE sE = new SE(string);
        sE.createUI(stringArray);
        SwingUIModule.ToCenterScreen(sE);
        return sE;
    }

    public SimpleTextPane() {
        this(new JTextArea(), "Simple text pane.");
    }

    public SimpleTextPane(JTextComponent jTextComponent) {
        this(jTextComponent, "Simple text pane.");
    }

    public SimpleTextPane(String string) {
        this(new JTextArea(), string);
    }

    public SimpleTextPane(JTextComponent jTextComponent, String string) {
        this.text_component = jTextComponent;
        this.init(string);
    }

    protected final void finalize() {
        this.text_component = null;
    }

    private void init(String string) {
        super.setMinimumSize(new Dimension(100, 50));
        super.setPreferredSize(new Dimension(400, 300));
        if (this.text_component instanceof JTextArea) {
            ((JTextArea)this.text_component).setTabSize(4);
        }
        this.text_component.addMouseListener(this);
        this.text_component.setOpaque(false);
        if (string != null && string.length() > 0) {
            super.setBorder(new TitledBorder(string));
        }
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setViewportBorder(compoundBorder);
        this.setDoubleBuffered(true);
        this.setViewportView(this.text_component);
        this.getViewport().setBackground(Color.white);
        JPopupMenu jPopupMenu = SwingUIModule.CreateJPopupByParams("Copy|Cut|Paste|Select all|-|!Find|-|Change text pane background|Change text pane foreground", null, this);
        SwingUIModule.SetJMenuItemActionCommandsByParams("0|1|2|3|-|4|-|5|6", jPopupMenu);
        if (!this.text_component.isEditable()) {
            jPopupMenu.getComponent(1).setEnabled(false);
            jPopupMenu.getComponent(2).setEnabled(false);
        }
        this.popup_menu = jPopupMenu;
    }

    public JTextComponent getTextComponent() {
        return this.text_component;
    }

    public JTextComponent setTextComponent(JTextComponent jTextComponent) {
        JTextComponent jTextComponent2 = this.text_component;
        if (jTextComponent != null) {
            if (jTextComponent == jTextComponent2) {
                return jTextComponent2;
            }
            jTextComponent.addMouseListener(this);
            jTextComponent.setOpaque(false);
            this.setViewportView(jTextComponent);
            jTextComponent2.removeMouseListener(this);
        } else if (jTextComponent == null) {
            this.setViewportView(null);
        }
        this.text_component = jTextComponent;
        return jTextComponent2;
    }

    public void setTextPaneforeColor(Color color) {
        this.text_component.setForeground(color);
    }

    public void setTextPanebackColor(Color color) {
        this.text_component.setBackground(color);
    }

    public void setTextCaretColor(Color color) {
        this.text_component.setCaretColor(color);
    }

    public void setTextFont(Font font) {
        this.text_component.setFont(font);
    }

    public String getText() {
        return this.text_component.getText();
    }

    public void setText(String string) {
        this.text_component.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = actionEvent.getActionCommand().charAt(0) - 48;
        if (n == 0) {
            this.text_component.copy();
        } else if (n == 1) {
            this.text_component.cut();
        } else if (n == 2) {
            this.text_component.paste();
        } else if (n == 3) {
            this.text_component.selectAll();
        } else if (n != 4) {
            Color color;
            if (n == 5) {
                Color color2 = SwingUIModule.ShowColorDialog(this, "Change text pane background");
                if (color2 != null) {
                    this.getViewport().setBackground(color2);
                }
            } else if (n == 6 && (color = SwingUIModule.ShowColorDialog(this, "Change text pane foreground")) != null) {
                this.text_component.setForeground(color);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            this.popup_menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static class SE
    extends JFrame
    implements IUserInputFrame,
    ActionListener {
        private static final int SLEEP_TIME = 200;
        JButton accept_btn = new JButton("Accept");
        JButton cancel_btn = new JButton("Cancel");
        SimpleTextPane[] str_params;
        private boolean accepted = false;

        public SE() {
            this("No title.");
        }

        public SE(String string) {
            super(string);
            this.initButtons();
        }

        private void initButtons() {
            Font font = new Font("DialogInput", 1, 11);
            this.accept_btn.setFont(font);
            this.accept_btn.setBorder(BorderFactory.createLineBorder(Color.black));
            this.accept_btn.setDoubleBuffered(true);
            this.accept_btn.setPreferredSize(new Dimension(150, 20));
            this.cancel_btn.setFont(font);
            this.cancel_btn.setBorder(BorderFactory.createLineBorder(Color.black));
            this.cancel_btn.setDoubleBuffered(true);
            this.cancel_btn.setPreferredSize(new Dimension(150, 20));
            this.accept_btn.addActionListener(this);
            this.cancel_btn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.accept_btn) {
                this.accepted = true;
            }
            super.setVisible(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getResults() {
            String[] stringArray;
            if (Thread.currentThread().getName().equals("main")) {
                SyncThread syncThread = new SyncThread((Window)this);
                try {
                    stringArray = this;
                    synchronized (this) {
                        syncThread.start();
                        while (syncThread.isAlive()) {
                            this.wait(200L);
                        }
                        // ** MonitorExit[var2_4] (shouldn't be in output)
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                try {
                    while (super.isShowing()) {
                        Thread.sleep(500L);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            {
                if (!this.accepted || this.str_params == null) {
                    return null;
                }
                int n = this.str_params.length;
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = this.str_params[i].getText();
                }
                return stringArray;
            }
        }

        public void setText(int n, String string) {
            SimpleTextPane[] simpleTextPaneArray = this.str_params;
            if (simpleTextPaneArray == null) {
                return;
            }
            try {
                simpleTextPaneArray[n].setText(string);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("invalid index!");
            }
        }

        public void showInputFrame() {
            super.setVisible(true);
        }

        public void createUI(String[] stringArray) {
            this.str_params = new SimpleTextPane[stringArray.length];
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.removeAll();
            jPanel.setLayout(new BorderLayout(3, 3));
            Font font = new Font("DialogInput", 0, 11);
            JPanel jPanel2 = new JPanel(new GridLayout(stringArray.length, 1, 3, 3));
            for (int i = 0; i < stringArray.length; ++i) {
                SimpleTextPane simpleTextPane = new SimpleTextPane(stringArray[i]);
                simpleTextPane.setFont(font);
                jPanel2.add(simpleTextPane);
                this.str_params[i] = simpleTextPane;
            }
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 3, 3));
            jPanel3.add(this.accept_btn);
            jPanel3.add(this.cancel_btn);
            jPanel.add((Component)jPanel3, "South");
            this.pack();
        }

        public void release() {
            super.dispose();
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.removeAll();
            this.accept_btn = null;
            this.cancel_btn = null;
            this.str_params = null;
        }

        private static class SyncThread
        extends Thread {
            Window m_wnd;

            SyncThread(Window window) {
                super("SyncThread");
                this.m_wnd = window;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Window window = this.m_wnd;
                    synchronized (window) {
                        while (this.m_wnd.isShowing()) {
                            this.m_wnd.wait(200L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.m_wnd = null;
            }
        }
    }
}

