/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui.swing;

import com.mylyane.afx.IApplication;
import com.mylyane.afx.IDomain;
import com.mylyane.afx.UIModule;
import com.mylyane.afx.plugin.IPlugin;
import com.mylyane.afx.swing.IIconManager;
import com.mylyane.afx.swing.SwingUIModule;
import com.mylyane.util.Utility;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public abstract class XMainFrame
extends JFrame
implements IApplication {
    static SwingUIModule.IFileFilterEx FILTER = SwingUIModule.GetDefaultFileFilterEx();
    protected IDomain domain;
    protected String title;
    protected String title_format;
    protected String dialog_title;
    protected File visited_dir;
    private String f_extensions;
    private String f_description;

    protected static JFileChooser GetSharedFileChooser(String string, String string2, File file) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(true);
        FILTER.setDescription(string);
        FILTER.setExtensions(string2);
        jFileChooser.setFileFilter(FILTER.toFileFilter());
        return jFileChooser;
    }

    public XMainFrame() {
        this("No title.", " {0} [{1}]");
    }

    public XMainFrame(String string) {
        this(string, " {0} [{1}]");
    }

    public XMainFrame(String string, String string2) {
        super(string);
        this.title = string;
        this.title_format = string.concat(string2);
        this.visited_dir = new File(System.getProperty("user.dir"));
    }

    public IDomain getBelongingDomain() {
        return this.domain;
    }

    public void setBelongingDomain(IDomain iDomain) {
        this.domain = iDomain;
    }

    public void setFileExtensions(String string) {
        this.f_extensions = string;
    }

    public void setFileDescription(String string) {
        this.f_description = string;
    }

    public void release() {
        this.visited_dir = null;
        this.domain = null;
    }

    protected final void finalize() throws Throwable {
        this.release();
    }

    public void cacheVisitedDirectory(JFileChooser jFileChooser) {
        this.visited_dir = jFileChooser.getCurrentDirectory();
    }

    protected void upDateTitle(File file) {
        if (file != null) {
            String string = null;
            if (file.exists()) {
                string = file.getParent();
            }
            if (string == null) {
                string = "!Warning :It's uncertain file.";
            }
            Object[] objectArray = new Object[]{file.getName(), string};
            super.setTitle(Utility.Format(this.title_format, objectArray));
        } else {
            super.setTitle(this.title);
        }
    }

    public void runApplication() {
        this.setDefaultCloseOperation(3);
        this.pack();
        UIModule.ToCenterByWindow(this, null);
        this.setVisible(true);
    }

    public void openFileEvent() {
        JFileChooser jFileChooser = XMainFrame.GetSharedFileChooser(this.f_description, this.f_extensions, this.visited_dir);
        if (jFileChooser.showOpenDialog(this) == 0 && this.onFileOpen(jFileChooser.getSelectedFiles())) {
            this.upDateTitle(jFileChooser.getSelectedFile());
        }
        jFileChooser.resetChoosableFileFilters();
        this.cacheVisitedDirectory(jFileChooser);
    }

    public void saveFileEvent() {
        JFileChooser jFileChooser = XMainFrame.GetSharedFileChooser(this.f_description, this.f_extensions, this.visited_dir);
        String string = this.getSaveFileName();
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                jFileChooser.setSelectedFile(file);
            } else {
                jFileChooser.setSelectedFile(new File(this.visited_dir, string));
            }
        }
        if (jFileChooser.showSaveDialog(this) == 0 && this.onFileSave(jFileChooser.getSelectedFile())) {
            this.upDateTitle(jFileChooser.getSelectedFile());
        }
        jFileChooser.resetChoosableFileFilters();
        this.cacheVisitedDirectory(jFileChooser);
    }

    public abstract boolean onFileOpen(File[] var1);

    public abstract boolean onFileSave(File var1);

    protected abstract String getSaveFileName();

    public abstract void about();

    public abstract void showStatus(String var1);

    public abstract IIconManager getIconManager();

    public abstract void acceptPlugin(IPlugin var1);

    public void alert(String string) {
        JOptionPane.showMessageDialog(this, string, this.dialog_title, 1);
    }

    public void warning(String string) {
        JOptionPane.showMessageDialog(this, string, this.dialog_title, 2);
    }
}

