/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui.swing;

import com.mylyane.afx.swing.ISwingUniversalProvider;
import com.mylyane.afx.swing.IUIProvider;
import com.mylyane.afx.swing.tree.ITreeIconResolver;
import com.mylyane.afx.swing.tree.ITreeNodeFactory;
import com.mylyane.afx.swing.tree.ITreeProvider;
import com.mylyane.afx.swing.tree.TreeNodeFactory;
import com.mylyane.afx.swing.tree.XComparableTreeNode;
import com.mylyane.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class XTreePane
extends JPanel
implements IUIProvider,
ITreeProvider {
    protected JScrollPane treePane;
    protected JTree tree;
    protected XComparableTreeNode root_node;
    protected DefaultTreeModel treeModel;
    protected ITreeNodeFactory factory;
    private transient int[] tmp_indices;
    private transient XComparableTreeNode[] tmp_nodes;
    private transient boolean b_sorting;

    public XTreePane() {
        this(true);
    }

    public XTreePane(boolean bl) {
        super(new BorderLayout(3, 3), bl);
    }

    public abstract void initTree(TreeModelListener var1, TreeSelectionListener var2, ISwingUniversalProvider var3, ITreeIconResolver var4);

    public void init() {
        this.treePane = new JScrollPane(this.tree, 20, 30);
        this.treePane.setViewportBorder(BorderFactory.createLineBorder(Color.lightGray.brighter(), 3));
        super.add((Component)this.treePane, "Center");
    }

    public final JComponent getRootComponent() {
        return this;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setFactory(ITreeNodeFactory iTreeNodeFactory) {
        this.factory = iTreeNodeFactory;
    }

    public XComparableTreeNode getParentNodeFromTreePath(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        return treePath2 != null ? (XComparableTreeNode)treePath2.getLastPathComponent() : null;
    }

    public XComparableTreeNode getParentNode(XComparableTreeNode xComparableTreeNode, int n) {
        if (xComparableTreeNode != null) {
            XComparableTreeNode xComparableTreeNode2;
            if (xComparableTreeNode.getNodeType() == n) {
                return xComparableTreeNode;
            }
            while ((xComparableTreeNode2 = (XComparableTreeNode)xComparableTreeNode.getParent()) != null) {
                if (xComparableTreeNode2.getNodeType() == n) {
                    return xComparableTreeNode2;
                }
                xComparableTreeNode = xComparableTreeNode2;
            }
        }
        return null;
    }

    public boolean isParentOver(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length == 0) {
            return false;
        }
        TreePath treePath = treePathArray[0].getParentPath();
        if (treePath == null) {
            return false;
        }
        for (int i = treePathArray.length - 1; i > 0; --i) {
            if (treePath == treePathArray[i].getParentPath()) continue;
            return true;
        }
        return false;
    }

    public final void sortChildren(XComparableTreeNode xComparableTreeNode) {
        int n = xComparableTreeNode.getChildCount();
        this.b_sorting = true;
        this.removeChildren(xComparableTreeNode);
        int[] nArray = this.tmp_indices;
        Comparable[] comparableArray = this.tmp_nodes;
        Utility.FqSort(comparableArray, 0, n - 1);
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
            xComparableTreeNode.add((MutableTreeNode)((Object)comparableArray[i]));
        }
        this.treeModel.nodesWereInserted(xComparableTreeNode, nArray);
        this.tmp_indices = null;
        this.tmp_nodes = null;
        this.b_sorting = false;
    }

    public final void removeChildren(XComparableTreeNode xComparableTreeNode) {
        int n = xComparableTreeNode.getChildCount();
        Object[] objectArray = new XComparableTreeNode[n];
        DefaultTreeModel defaultTreeModel = this.treeModel;
        int[] nArray = new int[n];
        Enumeration<TreeNode> enumeration = xComparableTreeNode.children();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n2] = n2;
            objectArray[n2++] = (XComparableTreeNode)enumeration.nextElement();
        }
        xComparableTreeNode.removeAllChildren();
        defaultTreeModel.nodesWereRemoved(xComparableTreeNode, nArray, objectArray);
        if (this.b_sorting) {
            this.tmp_indices = nArray;
            this.tmp_nodes = objectArray;
        }
    }

    public XComparableTreeNode getRootNode() {
        return this.root_node;
    }

    public boolean isRootNode(Object object) {
        if (object instanceof TreePath) {
            return ((TreePath)object).getLastPathComponent() == this.root_node;
        }
        return this.root_node == object;
    }

    public boolean isRootNodeEmpty() {
        return this.root_node.getChildCount() == 0;
    }

    public void removeNodeFromParent(XComparableTreeNode xComparableTreeNode) {
        this.treeModel.removeNodeFromParent(xComparableTreeNode);
    }

    public void addNode(XComparableTreeNode xComparableTreeNode, XComparableTreeNode xComparableTreeNode2, boolean bl) {
        if (xComparableTreeNode == null) {
            xComparableTreeNode = this.root_node;
        }
        this.treeModel.insertNodeInto(xComparableTreeNode2, xComparableTreeNode, xComparableTreeNode.getChildCount());
        if (bl) {
            TreePath treePath = new TreePath(xComparableTreeNode2.getPath());
            this.tree.setSelectionPath(treePath);
        }
    }

    public void addNodeToRoot(XComparableTreeNode xComparableTreeNode, boolean bl) {
        this.addNode(this.root_node, xComparableTreeNode, bl);
    }

    public void addNodeEx(XComparableTreeNode xComparableTreeNode, Object object, boolean bl, boolean bl2, int n) {
        XComparableTreeNode xComparableTreeNode2 = this.createNodeInstance(object, bl, n);
        this.addNode(xComparableTreeNode, xComparableTreeNode2, bl2);
    }

    public void addNodeToRootEx(Object object, boolean bl, boolean bl2, int n) {
        XComparableTreeNode xComparableTreeNode = this.createNodeInstance(object, bl, n);
        this.addNodeToRoot(xComparableTreeNode, bl2);
    }

    public void addNodesToRootEx(Object object, int n, Enumeration enumeration, boolean bl, boolean bl2, int n2) {
        XComparableTreeNode xComparableTreeNode = this.createNodeInstance(object, true, n);
        while (enumeration.hasMoreElements()) {
            XComparableTreeNode xComparableTreeNode2 = this.createNodeInstance(enumeration.nextElement(), bl, n2);
            xComparableTreeNode.add(xComparableTreeNode2);
        }
        this.addNodeToRoot(xComparableTreeNode, bl2);
    }

    public void addNodesEx(XComparableTreeNode xComparableTreeNode, Enumeration enumeration, boolean bl, boolean bl2, int n) {
        int n2 = 0;
        int[] nArray = new int[100];
        int n3 = nArray.length;
        while (enumeration.hasMoreElements()) {
            XComparableTreeNode xComparableTreeNode2 = this.createNodeInstance(enumeration.nextElement(), bl, n);
            xComparableTreeNode.add(xComparableTreeNode2);
            if (n2 >= n3) {
                nArray = (int[])Utility.GrowArray(nArray, n3, n3 << 1);
                n3 = nArray.length;
            }
            nArray[n2] = n2++;
        }
        if (n2 < n3) {
            nArray = (int[])Utility.TrimArray(nArray, n2);
        }
        this.treeModel.nodesWereInserted(xComparableTreeNode, nArray);
    }

    public XComparableTreeNode createNodeInstance(Object object, boolean bl, int n) {
        ITreeNodeFactory iTreeNodeFactory = this.factory;
        if (iTreeNodeFactory == null) {
            this.factory = iTreeNodeFactory = new TreeNodeFactory();
        }
        XComparableTreeNode xComparableTreeNode = iTreeNodeFactory.create();
        xComparableTreeNode.setUserObject(object);
        xComparableTreeNode.setAllowsChildren(bl);
        xComparableTreeNode.setNodeType(n);
        return xComparableTreeNode;
    }
}

