/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.util;

public final class CRC32 {
    private static int[] crc_table;
    private static boolean b_init;

    public static synchronized void Init() {
        if (!b_init) {
            crc_table = new int[256];
            CRC32.make_crc_table();
            b_init = true;
        }
    }

    public static synchronized void Release() {
        crc_table = null;
        b_init = false;
    }

    private static void make_crc_table() {
        long l = 3988292384L;
        long l2 = 0xFFFFFFFFL;
        for (int i = 0; i < 256; ++i) {
            long l3 = i;
            for (int j = 0; j < 8; ++j) {
                if ((l3 & 1L) == 1L) {
                    l3 = l ^ l3 >> 1;
                    continue;
                }
                l3 >>= 1;
            }
            CRC32.crc_table[i] = (int)(l3 & l2);
        }
    }

    public static long Update(long l, byte[] byArray, int n, int n2) {
        long l2 = l;
        long l3 = 255L;
        long l4 = 0xFFFFFFFFL;
        n2 += n;
        while (n < n2) {
            l2 = ((long)crc_table[(int)((l2 ^ (long)byArray[n]) & l3)] ^ l2 >> 8 & l4) & l4;
            ++n;
        }
        return l2;
    }

    public static long Sum(byte[] byArray, int n, int n2) {
        return CRC32.Update(0xFFFFFFFFL, byArray, n, n2) ^ 0xFFFFFFFFL;
    }

    static {
        b_init = false;
    }
}

