/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.util;

import com.mylyane.lang.CharsBuffer;
import com.mylyane.util.DictionaryX;
import com.mylyane.util.Enum;
import com.mylyane.util.IEnumEx;
import com.mylyane.util.MapEntry;
import com.mylyane.util.XEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class HashtableX
extends DictionaryX
implements Cloneable,
Serializable {
    protected static final boolean DEBUG = false;
    private transient XEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public HashtableX(int n, float f) {
        this.init(n, f);
    }

    public HashtableX(int n) {
        this(n, 0.75f);
    }

    public HashtableX() {
    }

    public void init(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.count > 0) {
            this.clear();
        }
        this.loadFactor = f;
        this.table = new XEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.count;
    }

    public void sizeVerify() {
        XEntry xEntry = null;
        XEntry[] xEntryArray = this.table;
        int n = xEntryArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            while (n-- > 0 && (xEntry = xEntryArray[n]) == null) {
                ++n2;
            }
            if (xEntry == null) continue;
            ++n3;
            while ((xEntry = xEntry.next) != null) {
                ++n3;
            }
        }
        CharsBuffer charsBuffer = CharsBuffer.GetShared(128);
        System.out.println(charsBuffer.append("sizeVerify :null_count=").append(n2).append(", count_entry=").append(n3).append(", size=").append(this.count).flushToString());
        CharsBuffer.Replace(charsBuffer);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized void restore(int n) {
        this.clear();
        if (n < this.table.length) {
            this.table = new XEntry[n];
            this.threshold = (int)((float)n * this.loadFactor);
        }
    }

    public synchronized void clear() {
        XEntry[] xEntryArray = this.table;
        if (xEntryArray == null) {
            return;
        }
        int n = xEntryArray.length;
        while (--n >= 0) {
            XEntry xEntry = xEntryArray[n];
            if (xEntry == null) continue;
            xEntry.release(true);
            xEntryArray[n] = null;
        }
        this.count = 0;
    }

    public void release() {
        this.clear();
        this.table = null;
    }

    public synchronized Enumeration keys() {
        return new Enum().setConditions(this.table, 1, this.count);
    }

    public synchronized Enumeration elements() {
        return new Enum().setConditions(this.table, 0, this.count);
    }

    public synchronized IEnumEx mapEntries() {
        return new Enum().setConditions(this.table, 2, this.count);
    }

    public synchronized boolean contains(Object object) {
        if (object != null) {
            XEntry[] xEntryArray = this.table;
            int n = xEntryArray.length;
            while (n-- > 0) {
                XEntry xEntry = xEntryArray[n];
                while (xEntry != null) {
                    if (xEntry.v.equals(object)) {
                        return true;
                    }
                    xEntry = xEntry.next;
                }
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        XEntry[] xEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % xEntryArray.length;
        XEntry xEntry = xEntryArray[n2];
        while (xEntry != null) {
            if (xEntry.hash == n && xEntry.k.equals(object)) {
                return true;
            }
            xEntry = xEntry.next;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        if (object != null) {
            XEntry[] xEntryArray = this.table;
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % xEntryArray.length;
            XEntry xEntry = xEntryArray[n2];
            while (xEntry != null) {
                if (xEntry.hash == n && xEntry.k.equals(object)) {
                    return xEntry.v;
                }
                xEntry = xEntry.next;
            }
        }
        return null;
    }

    protected void rehash() {
        XEntry[] xEntryArray = this.table;
        int n = xEntryArray.length;
        int n2 = (n << 1) + 1;
        XEntry[] xEntryArray2 = new XEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = xEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            XEntry xEntry = xEntryArray[n3];
            while (xEntry != null) {
                XEntry xEntry2 = xEntry;
                xEntry = xEntry.next;
                int n4 = (xEntry2.hash & Integer.MAX_VALUE) % n2;
                xEntry2.next = xEntryArray2[n4];
                xEntryArray2[n4] = xEntry2;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException("value is null");
        }
        XEntry[] xEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % xEntryArray.length;
        XEntry xEntry = xEntryArray[n2];
        while (xEntry != null) {
            if (xEntry.hash == n && xEntry.k.equals(object)) {
                Object object3 = xEntry.v;
                xEntry.v = object2;
                return object3;
            }
            xEntry = xEntry.next;
        }
        int n3 = this.count;
        if (n3 >= this.threshold) {
            this.rehash();
            xEntryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % xEntryArray.length;
        }
        XEntry xEntry2 = new XEntry(object, object2);
        xEntry2.hash = n;
        xEntry2.next = xEntryArray[n2];
        xEntryArray[n2] = xEntry2;
        this.count = n3 + 1;
        return null;
    }

    public synchronized Object remove(Object object) {
        XEntry[] xEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % xEntryArray.length;
        XEntry xEntry = xEntryArray[n2];
        XEntry xEntry2 = null;
        while (xEntry != null) {
            if (xEntry.hash == n && xEntry.k.equals(object)) {
                if (xEntry2 != null) {
                    xEntry2.next = xEntry.next;
                } else {
                    xEntryArray[n2] = xEntry.next;
                }
                --this.count;
                Object object2 = xEntry.v;
                xEntry.release();
                return object2;
            }
            xEntry2 = xEntry;
            xEntry = xEntry.next;
        }
        return null;
    }

    public synchronized Object clone() {
        try {
            HashtableX hashtableX = (HashtableX)super.clone();
            hashtableX.table = new XEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                XEntry xEntry = this.table[n];
                if (xEntry == null) continue;
                hashtableX.table[n] = (XEntry)xEntry.clone();
            }
            return hashtableX;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n = this.count - 1;
        CharsBuffer charsBuffer = new CharsBuffer(1024).append('{');
        IEnumEx iEnumEx = this.mapEntries();
        for (int i = 0; i <= n; ++i) {
            MapEntry mapEntry = iEnumEx.nextEntry();
            Object object = mapEntry.v;
            charsBuffer.append(mapEntry.k.toString()).append('=').append(object);
            if (i >= n) continue;
            charsBuffer.add(", ");
        }
        return charsBuffer.append('}').flushToString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            XEntry xEntry = this.table[i];
            while (xEntry != null) {
                objectOutputStream.writeObject(xEntry.k);
                objectOutputStream.writeObject(xEntry.v);
                xEntry = xEntry.next;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new XEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }
}

