/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.util;

import com.mylyane.util.QON;
import com.mylyane.util.XTokenizer;
import java.util.NoSuchElementException;

public final class StdTokenizerEx
extends XTokenizer {
    private static final char STD_TK_LIMIT_CHAR = '\u0080';
    private static final char STD_TK_COMMENT_LIMIT_CHAR = '<';
    private char[] m_comments_tbl = null;

    public StdTokenizerEx(String string, String string2) {
        super(string, string2, '\u0080');
    }

    public StdTokenizerEx(String string) {
        this(string, " \t\n\r");
    }

    public StdTokenizerEx() {
        this(null, " \t\n\r");
    }

    public void changeDelim(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        super.registDelimiters(string.toCharArray(), '\u0080');
        if (bl) {
            this.m_cp = 0;
        }
    }

    public boolean eol() {
        int n = this.m_cp;
        int n2 = this.m_limit;
        if (n >= n2) {
            return true;
        }
        char[] cArray = this.m_str;
        char[] cArray2 = this.m_delim_table;
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) == '\n') {
                this.m_cp = n;
                return true;
            }
            if (c <= this.m_max_delim_value && cArray2[c] != '\u0000') continue;
        }
        this.m_cp = n - 1;
        if (this.m_comments_tbl != null) {
            this.skipComments();
        }
        return false;
    }

    public boolean hasMoreTokens() {
        return this.m1() < this.m_limit;
    }

    public String currentToken() {
        int n = this.m1();
        if (n >= this.m_limit) {
            return null;
        }
        return new String(this.m_str, n, this.TE(n) - n);
    }

    public String nextToken() {
        int n = this.m1();
        if (n >= this.m_limit) {
            return null;
        }
        this.m_cp = this.TE(n);
        return new String(this.m_str, n, this.m_cp - n);
    }

    public int nextTokenHash() {
        int n;
        int n2 = this.m1();
        if (n2 >= this.m_limit) {
            throw new NoSuchElementException();
        }
        this.m_cp = n = this.TE(n2);
        return QON.StringHash(this.m_str, n2, n);
    }

    public int currentTokenHash() {
        int n = this.m1();
        if (n >= this.m_limit) {
            throw new NoSuchElementException();
        }
        return QON.StringHash(this.m_str, n, this.TE(n) - n);
    }

    public char tokenCharAt(int n, boolean bl) {
        int n2 = this.m1();
        if (n2 >= this.m_limit) {
            return '\u0000';
        }
        if (bl) {
            this.m_cp = this.TE(n2);
        }
        try {
            return this.m_str[n2 + n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            return '\u0000';
        }
    }

    public void setCommentChars(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = this.m_comments_tbl;
        if (cArray == null) {
            cArray = new char[60];
        }
        StdTokenizerEx.RegistDelimiters(cArray, string.toCharArray(), '<');
        this.m_comments_tbl = cArray;
    }

    public void skipComments() {
        char[] cArray = this.m_str;
        char[] cArray2 = this.m_delim_table;
        char[] cArray3 = this.m_comments_tbl;
        int n = cArray.length;
        char c = this.at(cArray, cArray2, 0);
        int n2 = this.m_cp;
        while (c < '<' && cArray3[c] != '\u0000') {
            while (n2 < n && cArray[n2++] != '\n') {
            }
            if ((n2 = this.NTO(n2)) >= n) break;
            c = cArray[n2];
        }
        this.m_cp = n2;
    }

    private char at(char[] cArray, char[] cArray2, int n) {
        char c;
        int n2;
        int n3 = cArray.length;
        for (n2 = this.m_cp; n2 < n3 && (c = cArray[n2]) <= this.m_max_delim_value && cArray2[c] != '\u0000'; ++n2) {
        }
        if (n2 >= n3) {
            return '<';
        }
        return cArray[n2 + n];
    }

    public void skip(int n) {
        int n2;
        int n3 = this.m_limit;
        while (n-- > 0 && (n2 = this.m1()) < n3) {
            this.m_cp = this.TE(n2);
        }
    }

    private int m1() {
        if (this.m_comments_tbl != null) {
            this.skipComments();
        }
        return this.NTO(this.m_cp);
    }

    public void reset() {
        this.m_cp = 0;
    }

    public int countTokens() {
        boolean bl;
        boolean bl2 = bl = this.m_comments_tbl != null;
        if (bl) {
            this.skipComments();
        }
        int n = this.m_cp;
        int n2 = 0;
        int n3 = this.m_limit;
        int n4 = n;
        while (n < n3 && (n = this.NTO(n)) < n3) {
            n = this.TE(n);
            ++n2;
            if (!bl) continue;
            this.m_cp = n;
            this.skipComments();
            n = this.m_cp;
        }
        this.m_cp = n4;
        return n2;
    }

    public String nextToken(String string) {
        if (string == null) {
            string = "";
        }
        super.registDelimiters(string.toCharArray(), '\u0080');
        return this.nextToken();
    }
}

