/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.util;

import com.mylyane.util.ITokenizer;
import java.util.NoSuchElementException;

public final class UniTokenizer
implements ITokenizer {
    private char[] m_str;
    private char[] m_delim;
    private int m_cp;
    private int m_limit;
    private boolean retDelim;

    private static boolean _checkDelimiters(char c, char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        do {
            if (cArray[n2++] != c) continue;
            return true;
        } while (n2 != n);
        return false;
    }

    public UniTokenizer(String string, String string2, boolean bl) {
        this.m_str = string != null ? string.toCharArray() : null;
        this.m_limit = string != null ? string.length() : 0;
        this.m_delim = string2.toCharArray();
        this.retDelim = bl;
    }

    public UniTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public UniTokenizer(String string) {
        this(string, " \t\n\r", false);
    }

    private int skipDelimiters() {
        if (!this.retDelim) {
            int n;
            char[] cArray = this.m_delim;
            int n2 = cArray.length;
            int n3 = this.m_limit;
            block0: for (n = this.m_cp; n < n3; ++n) {
                char c = this.m_str[n];
                int n4 = 0;
                do {
                    if (cArray[n4++] != c) continue;
                    continue block0;
                } while (n4 < n2);
            }
            return n;
        }
        return this.m_cp;
    }

    private int tokenEnd(int n) {
        char[] cArray = this.m_str;
        char[] cArray2 = this.m_delim;
        int n2 = cArray2.length;
        int n3 = this.m_limit;
        block0: while (n < n3) {
            char c = cArray[n];
            int n4 = 0;
            while (cArray2[n4++] != c) {
                if (n4 != n2) continue;
                ++n;
                continue block0;
            }
            break block0;
        }
        return n;
    }

    public void changeCond(String string) {
        this.m_str = string.toCharArray();
        this.m_limit = string.length();
        this.m_cp = 0;
    }

    public void changeDelim(String string, boolean bl) {
        this.m_delim = string.toCharArray();
        if (bl) {
            this.m_cp = 0;
        }
    }

    public boolean eol() {
        int n = this.m_cp;
        int n2 = this.m_limit;
        if (n >= n2) {
            throw new NoSuchElementException();
        }
        char[] cArray = this.m_str;
        char[] cArray2 = this.m_delim;
        int n3 = cArray2.length;
        block0: while (n < n2) {
            char c;
            if ((c = cArray[n++]) == '\n') {
                return true;
            }
            int n4 = 0;
            while (cArray2[n4++] != c) {
                if (n4 != n3) continue;
                break block0;
            }
        }
        return false;
    }

    public boolean hasMoreTokens() {
        return this.skipDelimiters() < this.m_limit;
    }

    public String currentToken() {
        int n = this.skipDelimiters();
        if (n >= this.m_limit) {
            throw new NoSuchElementException();
        }
        return new String(this.m_str, n, this.tokenEnd(n) - n);
    }

    public String nextToken() {
        int n;
        int n2;
        int n3 = this.skipDelimiters();
        if (n3 >= (n2 = this.m_limit)) {
            throw new NoSuchElementException();
        }
        char[] cArray = this.m_str;
        char[] cArray2 = this.m_delim;
        int n4 = cArray2.length;
        block0: for (n = n3; n < n2; ++n) {
            char c = cArray[n];
            int n5 = 0;
            while (cArray2[n5++] != c) {
                if (n5 < n4) continue;
                continue block0;
            }
            break block0;
        }
        if (this.retDelim && n3 == n && UniTokenizer._checkDelimiters(cArray[n], cArray2)) {
            ++n;
        }
        this.m_cp = n;
        return new String(cArray, n3, n - n3);
    }

    public void reset() {
        this.m_cp = 0;
    }

    public int countTokens() {
        int n = 0;
        int n2 = this.m_cp;
        int n3 = this.m_limit;
        char[] cArray = this.m_str;
        char[] cArray2 = this.m_delim;
        int n4 = cArray2.length;
        while (n2 < n3) {
            int n5;
            int n6;
            if (!this.retDelim) {
                block1: while (n2 < n3) {
                    n6 = cArray[n2];
                    n5 = 0;
                    do {
                        if (cArray2[n5++] != n6) continue;
                        ++n2;
                        continue block1;
                    } while (n5 < n4);
                }
            }
            if (n2 >= n3) break;
            n6 = n2;
            block3: while (n2 < n3) {
                n5 = cArray[n2];
                int n7 = 0;
                while (cArray2[n7++] != n5) {
                    if (n7 < n4) continue;
                    ++n2;
                    continue block3;
                }
                break block3;
            }
            if (this.retDelim && n6 == n2 && UniTokenizer._checkDelimiters(cArray[n2], cArray2)) {
                ++n2;
            }
            ++n;
        }
        return n;
    }

    public String nextToken(String string) {
        this.m_delim = string.toCharArray();
        return this.nextToken();
    }

    public void skip(int n) {
        if (n > 0) {
            while (n-- > 0 && this.hasMoreTokens()) {
                this.nextToken();
            }
        }
    }
}

