/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.tools.propedit.afx.model;

import com.mylyane.afx.IFileState;
import java.io.File;
import java.io.Serializable;

public final class PropertiesContext
implements IFileState,
Serializable {
    private static final int USER_MASK = 0x7FFFFF00;
    public String name;
    public String canonical_name;
    private int state = 1;

    public PropertiesContext() {
        this(null);
    }

    public PropertiesContext(String string) {
        if (string != null) {
            this.setCanonicalName(string);
        }
    }

    public void setCanonicalName(String string) {
        this.canonical_name = string;
        this.name = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        File file = new File(string);
        boolean bl = file.exists();
        this.setFileState(bl ? 64 : 32);
        if (bl && !file.canWrite()) {
            this.setFileStateOr(128);
        }
    }

    public String toString() {
        return this.name;
    }

    public void release() {
        this.name = null;
        this.canonical_name = null;
    }

    public int getState() {
        return this.state & 0x8000000F;
    }

    public void setState(int n) {
        this.state = n & 0x8000000F | this.state & 0xF0;
    }

    public int getFileState() {
        return this.state & 0xF0;
    }

    public void setFileState(int n) {
        this.state = n & 0xF0 | this.state & 0x8000000F;
    }

    public void setFileStateOr(int n) {
        this.state |= n & 0xF0;
    }

    public int getUserState() {
        return this.state & 0x7FFFFF00;
    }

    public void setUserState(int n) {
        this.state |= n & 0x7FFFFF00;
    }

    public boolean isReadOnly() {
        return (this.state & 0x80) != 0;
    }

    public boolean isNormal() {
        return (this.state & 0x40) != 0;
    }

    public boolean isUncertain() {
        return (this.state & 0x20) != 0;
    }

    public boolean isModified() {
        return (this.state & 0x10) != 0;
    }
}

