/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jrule;

import java.util.List;
import jp.sourceforge.jrule.Assert;
import jp.sourceforge.jrule.PropertyRule;
import jp.sourceforge.jrule.RuleException;
import org.apache.commons.collections.SequencedHashMap;

public class ClassRule {
    private String name;
    private String testcase;
    private SequencedHashMap propertyRuleMap = new SequencedHashMap();

    public void test(Object value) throws RuleException {
        if (value == null) {
            return;
        }
        if (!this.canSupport(value)) {
            throw new RuleException();
        }
        int i = 0;
        while (i < this.propertyRuleMap.size()) {
            PropertyRule rule = (PropertyRule)this.propertyRuleMap.getValue(i);
            rule.test(value);
            ++i;
        }
    }

    public void test(Object value, String propertyName) throws RuleException {
        Assert.assertNotNull(propertyName);
        if (value == null) {
            return;
        }
        if (!this.canSupport(value)) {
            throw new RuleException();
        }
        PropertyRule rule = (PropertyRule)this.propertyRuleMap.get((Object)propertyName);
        if (rule == null) {
            return;
        }
        rule.test(value);
    }

    public boolean canSupport(Object value) {
        Assert.assertNotNull(this.name);
        return value.getClass().getName().equals(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List listPropertyRule() {
        Assert.assertNotNull(this.propertyRuleMap);
        return this.propertyRuleMap.sequence();
    }

    public void addPropertyRule(PropertyRule propertyRule) {
        Assert.assertNotNull(propertyRule);
        Assert.assertNotNull(propertyRule.getName());
        this.propertyRuleMap.put((Object)propertyRule.getName(), (Object)propertyRule);
    }

    public String getTestcase() {
        return this.testcase;
    }

    public void setTestcase(String string) {
        this.testcase = string;
    }
}

