/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jrule;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import jp.sourceforge.jrule.Assert;
import jp.sourceforge.jrule.Rule;
import jp.sourceforge.jrule.RuleException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.LogFactory;

public class PropertyRule
implements Rule {
    private String name;
    private List ruleList = new Vector();

    public void test(Object value) throws RuleException {
        if (value == null) {
            return;
        }
        Object property = this.getPropertyValue(value);
        int i = 0;
        while (i < this.ruleList.size()) {
            Rule rule = (Rule)this.ruleList.get(i);
            rule.test(property);
            ++i;
        }
    }

    private Object getPropertyValue(Object value) {
        Assert.assertNotNull(value);
        Assert.assertNotNull(this.name);
        try {
            return PropertyUtils.getProperty((Object)value, (String)this.name);
        }
        catch (IllegalAccessException e) {
            LogFactory.getLog(this.getClass()).warn((Object)e);
        }
        catch (InvocationTargetException e) {
            LogFactory.getLog(this.getClass()).warn((Object)e);
        }
        catch (NoSuchMethodException e) {
            LogFactory.getLog(this.getClass()).warn((Object)e);
        }
        return null;
    }

    public void addRule(Rule rule) {
        this.ruleList.add(rule);
    }

    public List listRule() {
        return this.ruleList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

