/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jrule;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import jp.sourceforge.jrule.Assert;
import jp.sourceforge.jrule.ClassRule;
import jp.sourceforge.jrule.RuleException;

public class RuleRepository {
    private String namespace;
    private Hashtable rules = new Hashtable();

    public void addClassRule(ClassRule rule) {
        Assert.assertNotNull(rule);
        Assert.assertNotNull(rule.getName());
        this.rules.put(rule.getName(), rule);
    }

    public ClassRule getClassRule(String className) {
        Assert.assertNotNull(className);
        return (ClassRule)this.rules.get(className);
    }

    public ClassRule getClassRule(Object object) {
        Assert.assertNotNull(object);
        return this.getClassRule(object.getClass().getName());
    }

    public ClassRule removeClassRule(String className) {
        Assert.assertNotNull(className);
        return (ClassRule)this.rules.remove(className);
    }

    public Map getAllClassRule() {
        return Collections.unmodifiableMap(this.rules);
    }

    public void test(Object object) throws RuleException {
        if (object == null) {
            return;
        }
        this.getClassRule(object).test(object);
    }

    public void test(Object object, String propertyName) throws RuleException {
        Assert.assertNotNull(propertyName);
        if (object == null) {
            return;
        }
        ClassRule rule = this.getClassRule(object);
        if (rule == null) {
            return;
        }
        rule.test(object, propertyName);
    }

    public void clear() {
        this.rules = new Hashtable();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

