/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jrule.impl;

import java.util.Collection;
import java.util.Map;
import jp.sourceforge.jrule.RuleException;
import jp.sourceforge.jrule.impl.AbstractRule;

public class CardinalityRule
extends AbstractRule {
    private Integer from;
    private Integer to;

    public void test(Object test) throws RuleException {
        if (test == null) {
            return;
        }
        if (test instanceof Collection) {
            this.testCollection((Collection)test);
        } else if (test instanceof Map) {
            this.testMap((Map)test);
        } else if (test instanceof Object[]) {
            this.testArray((Object[])test);
        }
    }

    public void testCollection(Collection test) throws RuleException {
        if (test == null) {
            return;
        }
        this.testSizeBetween(test.size());
    }

    public void testMap(Map test) throws RuleException {
        if (test == null) {
            return;
        }
        this.testSizeBetween(test.size());
    }

    public void testArray(Object[] test) throws RuleException {
        if (test == null) {
            return;
        }
        this.testSizeBetween(test.length);
    }

    public void testSizeBetween(int size) throws RuleException {
        if (this.from == null || this.to == null) {
            return;
        }
        if (this.from > size || size > this.to) {
            throw new RuleException(this.getId(), this.getMessage());
        }
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getTo() {
        return this.to;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setTo(Integer to) {
        this.to = to;
    }
}

