/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#ifndef _OP_H_
#define _OP_H_

typedef enum {
C_void      = 0x01,
C_addA      = 0x02,
C_subA      = 0x03,
C_mulA      = 0x04,
C_divA      = 0x05,
C_modA      = 0x06,
C_powA      = 0x07,
C_bitandA   = 0x08,
C_bitorA    = 0x09,
C_bitsubA   = 0x0A,
C_bitxorA   = 0x0B,
C_bitshLA   = 0x0C,
C_bitshRA   = 0x0D,
C_andA      = 0x0E,
C_orA       = 0x0F,
C_inc       = 0x10,
C_dec       = 0x11,
C_echo      = 0x12,
C_doc       = 0x13,
C_crlf      = 0x14,
C_if        = 0x15,
C_else      = 0x16,
C_for       = 0x17,
C_while     = 0x18,
C_do        = 0x19,
C_foreach   = 0x1A,
C_switch    = 0x1B,
C_default   = 0x1C,
C_try       = 0x1D,
C_break     = 0x1E,
C_continue  = 0x1F,
C_in        = 0x20,
C_not       = '!',
C_string    = '"',
C_sharp     = '#',
C_case      = '$',
C_mod       = '%',
C_bitand    = '&',
C_char      = '\'',
C_paL       = '(',
C_paR       = ')',
C_mul       = '*',
C_add       = '+',
C_comma     = ',',
C_sub       = '-',
C_join      = '.',
C_div       = '/',
C_catch     = '0',
C_throw     = '1',
C_return    = '2',
C_exit      = '3',
C_goto      = '4',
C_Minclude  = '5',
C_Mdefine   = '6',
C_var       = '7',
C_label     = '8',
C_function  = '9',
C_colon     = ':',
C_semic     = ';',
C_lt        = '<',
C_store     = '=',
C_gt        = '>',
C_que       = '?',
C_class     = '@',
C_file      = 'A',
C_line      = 'B',
C_names     = 'C',
C_frameIn   = 'D',
C_frameOut  = 'E',
C_jump      = 'F',
C_load      = 'G',
C_copy      = 'H',
C_sand      = 'I',
C_pop       = 'J',
C_call      = 'K',
C_args      = 'L',
C_array     = 'M',
C_object    = 'N',
C_loop      = 'O',
C_plus      = 'P',
C_minus     = 'Q',
C_bitnot    = 'R',
C_toBool    = 'S',
C_toChar    = 'T',
C_toInt     = 'U',
C_toFloat   = 'V',
C_toString  = 'W',
C_toNumber  = 'X',
C_typeof    = 'Y',
C_delete    = 'Z',
C_sqL       = '[',
C_new       = '\\',
C_sqR       = ']',
C_bitxor    = '^',
C_null      = '_',
C_regex     = '`',
C_true      = 'a',
C_false     = 'b',
C_this      = 'c',
C_symbol    = 'd',
C_int       = 'e',
C_float     = 'f',
C_match     = 'g',
C_notmatch  = 'h',
C_and       = 'i',
C_or        = 'j',
C_eq        = 'k',
C_ne        = 'l',
C_cmp       = 'm',
C_bitshL    = 'n',
C_bitshR    = 'o',
C_pow       = 'p',
C_cuL       = '{',
C_bitor     = '|',
C_cuR       = '}',
C_bitsub    = '~',
} op_t;


#endif /* _OP_H_ */
