/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
static int _file_close(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	new_bool(res, fclose(fp) == 0);
	return 1;
}
static int _file_read(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	char *s;
	int n;
	
	warnif(argc != 1,  "invalid arguments");
	n = var_toInt(argv);
	warnif(n <= 0,  "invalid argument-0");
	
	s = malloc(n + 1);
	
	if (fread(s, 1, n, fp) != n) {
		free(s);
		return 0;
	}
	s[n] = 0;
	new_string_with(ex, res, s, n);
	
	return 1;
}
static int _file_write(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	char *s;
	int n;
	
	warnif (argc < 1,  "invalid arguments");
	warnif (!var_toString(argv, &s, &n), "invalid argument-0") ;
	
	if (argc >= 2) {
		n = var_toInt(argv + 1);
	}
	warnif(n <= 0,  "invalid argument-1");
	if (fwrite(s, 1, n, fp) != n) {
		return 0;
	}
	new_int(res, n);
	return 1;
}
static int _file_getc(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	int c;
	warnif(argc != 0,  "invalid arguments");
	if ((c = fgetc(fp)) < 0) {
		return 0;
	}
	new_char(res, c);
	return 1;
}
static int _file_putc(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	int c,i,m=0;
	warnif(argc < 1,  "invalid arguments");
	for (i = 0; i < argc; i++) {
		c = var_toChar(argv + i);
		if ((c < 0) || (fputc(c, fp) < 0)) {
			/* put error */
			return 0;
		}
		m++;
	}
	new_int(res, m);
	return 1;
}
static int _file_gets(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	char *s;
	int n, c;
	
	warnif(argc != 0,  "invalid arguments");
	
	s = malloc(BUFSIZ);
	n = 0;
	
	while ((c = fgetc(fp)) > 0) {
		if (c == 0xd) {
			c = fgetc(fp);
			if ((c > 0) && (c != 0xa)) {
				ungetc(c, fp);
			}
			c = 0xa;
		}
		s = realloc(s, n + 2);
		s[n++] = c;
		if (c == 0xa) {
			break;
		}
	}
	
	if (!n) {
		free(s);
		return 0;
	}
	s[n] = 0;
	new_string_with(ex, res, s, n);
	
	return 1;
}
static int _file_puts(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	char *s;
	int i, n, m = 0;
	warnif(argc < 1,  "invalid arguments");
	for (i = 0; i < argc; i++) {
		if (var_toString(argv + i, &s, &n)) {
			if (fwrite(s, 1, n, fp) != n) {
				/* fwrite error */
				return 0;
			}
			m += n;
		}
	}
	new_int(res, m);
	return 1;
}
static int _file_printf(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	char *s;
	warnif(argc < 1,  "invalid arguments");
	warnif (!(s = var_toChars(argv)), "invalid argument-0") ;
	new_int(res, printf_to_file(fp, s, argv + 1, argc - 1));
	return 1;
}
static int _file_tell(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	warnif(argc != 0,  "invalid arguments");
	new_int(res, ftell(fp));
	return 1;
}
static int _file_rewind(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	warnif(argc != 0,  "invalid arguments");
	rewind(fp);
	new_bool(res, 1);
	return 1;
}
static int _file_seek(exec_t* ex, FILE* fp, int argc, var_t* argv, var_t* res)
{
	int i = 0, w = SEEK_SET;
	warnif(argc < 1,  "invalid arguments");
	i = var_toInt(argv);
	if (argc >= 2) {
		switch (var_toInt(argv + 1)) {
		case 0: w = SEEK_SET; break;
		case 1: w = SEEK_CUR; break;
		case 2: w = SEEK_END; break;
		default:
			warns("invalid argument: %s\n", typeof_var(argv + 1));
			return 0;
		}
	}
	new_bool(res, fseek(fp, i, w) == 0);
	return 1;
}

/************************************************************
 *
 ************************************************************/
typedef int (*file_func)(exec_t*, FILE*, int, var_t*, var_t*);
static file_func is_file_func(int sym)
{
	switch (sym) {
#include "_file_call.h"
	}
	return NULL;
}
int file_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res)
{
	file_func f = is_file_func(sym);
	if (f) {
		return (*f)(ex, p, argc, argv, res);
	}
	return -1;
}
