/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
void* frame_alloc(exec_t* ex)
{
	return alloc_link(ex, sizeof(object_t), &frame_proto);
}
void frame_free(exec_t* ex, void *v)
{
	free_link(ex, v);
}
void frame_clear(exec_t* ex, void *p)
{
	object_clear(ex, p);
}
void frame_trace(void *p)
{
	object_trace(p);
}

/************************************************************
 *
 ************************************************************/
int frame_getLocal(exec_t* ex, object_t* fp, int k, var_t* v)
{
	return object_get(ex, fp, k, v);
}
int frame_delLocal(exec_t* ex, object_t* fp, int k, var_t* v)
{
	return object_del(ex, fp, k, v);
}
int frame_setLocal(exec_t* ex, object_t* fp, int k, var_t* v)
{
	return object_set(ex, fp, k, v);
}

/************************************************************
 *
 ************************************************************/
int frame_get(exec_t* ex, object_t* fp, int k, var_t* v)
{
	while (fp->p) {
		if (object_get(ex, fp, k, v)) {
			return 1;
		}
		fp = fp->p;
	}
	return object_get(ex, fp, k, v);
}
int frame_del(exec_t* ex, object_t* fp, int k, var_t* v)
{
	var_t x;
	while (fp->p) {
		if (object_get(ex, fp, k, &x)) {
			break;
		}
		fp = fp->p;
	}
	return object_del(ex, fp, k, v);
}
int frame_set(exec_t* ex, object_t* fp, int k, var_t* v)
{
	var_t x;
	while (fp->p) {
		if (object_get(ex, fp, k, &x)) {
			break;
		}
		fp = fp->p;
	}
	return object_set(ex, fp, k, v);
}

/************************************************************
 *
 ************************************************************/
int frame_getItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return frame_get(ex, p, var_toSymbol(k), v);
}
int frame_delItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return frame_del(ex, p, var_toSymbol(k), v);
}
int frame_setItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return frame_set(ex, p, var_toSymbol(k), v);
}
