/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
void* refer_alloc(exec_t* ex)
{
	return alloc_link(ex, sizeof(array_t), &refer_proto);
}
void refer_free(exec_t* ex, void *v)
{
	free_link(ex, v);
}
void refer_clear(exec_t* ex, void *p)
{
	array_clear(ex, p);
}
void refer_trace(void *p)
{
	array_trace(p);
}

/************************************************************
 *
 ************************************************************/
int refer_reserv(exec_t* ex, array_t *arr, var_t* obj, var_t* key)
{
	var_t val;
	array_get(ex, arr, 0, obj);
	while (arr->n > 2) {
		array_del(ex, arr, 1, key);
		if (!var_getItem(ex, obj, key, &val)) {
			array_get(ex, arr, 1, &val);
			switch (val.type) {
			case V_symbol:
			case V_string:
				new_object(ex, &val, 0);
				break;
			default:
				new_array(ex, &val, 0);
				break;
			}
			if (!var_setItem(ex, obj, key, &val)) {
				return 0;
			}
		}
		copy_var(obj, &val);
	}
	array_get(ex, arr, 1, key);
	return 1;
}
int refer_set(exec_t* ex, var_t* v, var_t* val)
{
	if (v->type == V_refer) {
		var_t r,k;
		if (refer_reserv(ex, v->u.p, &r, &k)) {
			return var_setItem(ex, &r, &k, val);
		}
	} else if (v->type == V_symbol) {
		return frame_set(ex, ex->fp, v->u.i, val);
	}
	return 0;
}

/************************************************************
 *
 ************************************************************/
int refer_resolv(exec_t* ex, array_t *arr, var_t* obj, var_t* key)
{
	var_t val;
	array_get(ex, arr, 0, obj);
	while (arr->n > 2) {
		array_del(ex, arr, 1, key);
		if (!var_getItem(ex, obj, key, &val)) {
			return 0;
		}
		copy_var(obj, &val);
	}
	array_get(ex, arr, 1, key);
	return 1;
}
int refer_get(exec_t* ex, var_t* v, var_t* res)
{
	if (v->type == V_refer) {
		var_t r,k;
		if (refer_resolv(ex, v->u.p, &r, &k)) {
			return var_getItem(ex, &r, &k, res);
		}
	} else if (v->type == V_symbol) {
		return frame_get(ex, ex->fp, v->u.i, res);
	}
	return 0;
}
int refer_del(exec_t* ex, var_t* v, var_t* res)
{
	if (v->type == V_refer) {
		var_t r,k;
		if (refer_resolv(ex, v->u.p, &r, &k)) {
			return var_delItem(ex, &r, &k, res);
		}
	} else if (v->type == V_symbol) {
		return frame_del(ex, ex->fp, v->u.i, res);
	}
	return 0;
}
int refer_call(exec_t* ex, var_t *v, int argc, var_t* argv, var_t* res)
{
	object_t *fp;
	var_t ref, key, fun;
	int r;
	if (v->type == V_refer) {
		if (refer_resolv(ex, v->u.p, &ref, &key)) {
			if (var_getItem(ex, &ref, &key, &fun) && (fun.type == V_function)) {
				fp = ref.u.p;
				fp->p = ex->gp;
				r = call_function(ex, fp, key.u.i, fun.u.p, argc, argv, res);
			} else {
				r = var_callFunc(ex, &ref, key.u.i, argc, argv, res);
			}
		}
	} else if (v->type == V_symbol) {
		if (frame_get(ex, ex->gp, v->u.i, &fun)) {
			if (fun.type == V_class) {
				fp = frame_alloc(ex);
				fp->p = ex->gp;
				r = call_function(ex, fp, v->u.i, fun.u.p, argc, argv, res);
				if (res->type == V_frame) {
					assert(res->u.p == fp);
					res->type = V_object;
				} else {
					frame_free(ex, fp);
				}
			} else if (fun.type == V_function) {
				r = call_function(ex, ex->gp, v->u.i, fun.u.p, argc, argv, res);
			}
		} else {
			r = var_callFunc(ex, NULL, v->u.i, argc, argv, res);
		}
	}
	return r;
}
