
/* define */
if (1)
{
	# define string
	#define  _DEF1_    "a"
	
	# define (defined + string)
	#define  _DEF2_    (_DEF1_ + "b")

	if (_DEF2_ != "ab") {
		exit("define error");
	}
}

/* constants */
if (1) {
	var s = "sample.js";
	if (__FILE__ != s) {
		exit("__FILE__ != " + s);
	}
	
	s = sprintf("_%.4f", M_PI);
	if (s != "_3.1415") {
		exit("M_PI != 3.1415");
	}
}

/* get / set env / popen */
if (1) {
	var p, s;
	var n = "sendmail";
	var v = "/usr/bin/sendmail";
	
	setenv(n, v);
	
	if (getenv(n) != v) {
		exit("env error");
	}
	if (!(p = popen("echo $" + n))) {
		exit("popen error");
	}
	s = p.gets().trim();
	pclose(p);
	
	if (s != v) {
		exit("popen error: " + s + " != " + v);
	}
}

/* include / load test */
if (1) {
	var s1, s2, f;
	var msg = "hello world";
	
	s1 = tempnam();
	f = fopen(s1, "w+");
	f.puts("msg1 = \"" + msg + "\";\n");
	f.close();
	
	s2 = tempnam();
	f = fopen(s2, "w+");
	f.puts("#include \""+s1+"\"\n");
	f.puts("msg2 = msg1;\n");
	f.close();
	
	load(s2);
	
	unlink(s1);
	unlink(s2);
	
	if ((msg1 != msg) || (msg2 != msg)) {
		exit("include error");
	}
}

/* statement */
if (1) {
	var i,s;
	
	/* while */
	s = "";
	i = 0;
	while (i++ < 5) {
		s += 'a';
	}
	if (s != "aaaaa") {
		exit("while error: " + s);
	}
	
	/* do ... while */
	s = "";
	i = 0;
	do {
		s += 'a';
	} while (++i < 5);
	if (s != "aaaaa") {
		exit("do error: " + s);
	}
	
	/* for and switch */
	for (i = 0, s = ""; i < 5; i++) {
		switch (i) {
		case 0: s += 'a'; break;
		case 1: s += 'b'; break;
		default: s[i] = 'a'+i; break;
		}
	}
	if (s != "abcde") {
		exit("for error: " + s);
	}
}

/* && || */
if (1) {
	var a = null;
	var b = "hello";
	var c = "world";
	
	if ((a || c) != "world") {
		exit("&& || error");
	}
	if ((a && c) != null) {
		exit("&& || error");
	}
	if ((b || c) != "hello") {
		exit("&& || error");
	}
	if ((b && c) != "world") {
		exit("&& || error");
	}
	a &&= c;
	if (a != null) {
		exit("&& || error");
	}
	a ||= c;
	if (a != "world") {
		exit("&& || error");
	}
}

/* string */
if (1)
{
	var a,b,c,d;
	a = "hello";
	b = "world";
	c = "world";
	
	if ((a.length != 5) || (a.length != b.length)) {
		exit("string error");
	}
	if ((a == b) || (b != c)) {
		exit("string error");
	}
	if (("hello" != a) || (a != "hello")) {
		exit("string error");
	}
	if (("world" == a) || (a == "world")) {
		exit("string error");
	}
	if ((('c' + c) != "cworld") || ("worldc" != (c + 'c'))) {
		exit("string error");
	}
	
	if ((a.index("ll") != 2) || (a.index("lll") >= 0)) {
		exit("indexOf error");
	}
	if ((a.substr(2,2) != "ll") || (a.substr(2) != "llo")) {
		exit("substr error");
	}
	
	c = a + " , " + b;
	d = c.split(`\s*,\s*`);
	if (d.join('') != (a + b)) {
		exit("split error");
	}
}

if (a || b || c || d) {
	exit("block error");
}

/* regex */
if (1) {
	var s, a;
	s = "Hello123 \n World456";
	if (!(a = s =~ `^([a-z]+)(\d+)\s+`i)
	|| (a[1] != "Hello") || (a[2] != 123)) {
		exit("match error");
	}
	if (!(a = s =~ `\s+([a-z]+)(\d+)$`i)
	|| (a[1] != "World") || (a[2] != 456)) {
		exit("match error");
	}
	a = s.replace(`^([a-z]{2})\w+\s+([a-z]{2})\w+$`i, "-$1-$2-");
	if (!a || (a[1] != "He") || (a[2] != "Wo") || (s != "-He-Wo-")) {
		exit("replace error");
	}
	if (!s.replace(`[a-z]+`, "*", &a[0]) || (a[0] != "-H*-W*-")) {
		exit("replace error:a-z " + a);
	}
	if (!s.replace(`[A-Z]+`, "*", &a[10]) || (a[10] != "-*e-*o-")) {
		exit("replace error:A-Z " + a);
	}
	if (!s.replace(`[a-z]+`i, "*", &a) || (a != "-*-*-")) {
		exit("replace error:a-z/i " + a);
	}
}

/* array */
if (1)
{
	var i,j,b;
	var arr = [0, 1, 2];
	
	if (arr.length != 3) {
		exit("array error");
	}
	i = j = 0;
	foreach (var k,v in arr) {
		if ((k != i++) || (v != j++)) {
			exit("array error");
		}
	}
	
	b = arr.splice(1, 2, 3, 4);
	if ((b.join('') + arr.join('')) != "12034") {
		exit("splice or join error");
	}
	
	arr.push(12);
	if (arr.sort().join("") != "01234") {
		exit("array sort error");
	}
	if (arr.sort("r").join("") != "43120") {
		exit("array sort 'r' error");
	}
	if (arr.sort("n").join("") != "03412") {
		exit("array sort 'n' error");
	}
}

/* object */
if (1)
{
	var obj,i,j;
	var arr1 = ["abc", "def", "ghi", "jkl"];
	var arr2 = ["mno", "pqr", "stu", "vwx"];
	obj = {abc:"vwx", def:"stu", ghi:"pqr", jkl:"mno"};
	
	if (obj.length != 4) {
		exit("object error");
	}
	i = 0;
	j = 3;
	foreach (var k,v in obj) {
		if ((k != arr1[i] || v != arr2[j])
		|| (k == arr1[j] || v == arr2[i])) {
			exit("object error");
		}
		i++;
		j--;
	}
	if (obj.sort().values().join("") != "mnopqrstuvwx") {
		exit("obj sort error");
	}
	if (obj.sort("k").values().join("") != "vwxstupqrmno") {
		exit("obj sort 'k' error");
	}
	if (obj.sort("kr").values().join("") != "mnopqrstuvwx") {
		exit("obj sort 'kr' error");
	}
}

/* function */
function my_func0()
{
	return 1;
}
function my_func1(a) 
{
	return (my_func0() + a);
}
function my_func2(a, b) 
{
	return (my_func1(a) + b);
}
function my_func3(a, b, c) 
{
	return (my_func2(a, b) + c);
}

if (my_func3(3, 2, 1) != 7) {
	exit("function error");
}

/* try / catch */
function defined_func()
{
	throw;
	undefined_func();
}

if (1) {
	var b;
	b = "world";
	try {
		throw("hello");
	} catch(a) {
		b = a;
	}
	if (b != "hello") {
		exit("try / catch error");
	}
	
	try {
		defined_func();
		b = "world";
	}
	
	if (b == "world") {
		exit("try error");
	}
}

/* class */
class MyClass(u, h)
{
	this.user = u;
	this.host = h;
	
	function email()
	{
		return (this.user + "@" + this.host);
	}
}

if (1) {
	var a = MyClass("hello", "world");
	
	if (a.email() != "hello@world") {
		exit("class error");
	}
}

/* typeof */
if (1) {
	var s = "1234.5";
	var f = (number)s;
	var n = (int)f;
	var a = [];
	if (typeof s != "string") {
		exit("typeof error");
	}
	if (typeof f != "float") {
		exit("typeof error");
	}
	if (typeof n != "int") {
		exit("typeof error");
	}
	if (typeof a != "array") {
		exit("typeof error");
	}
	if (typeof defined_func != "function") {
		exit("typeof error");
	}
	if (typeof MyClass != "class") {
		exit("typeof error");
	}
}

/* file */
if (1) {
	var fp, a, n;
	n = tempnam("./", "_", ".txt");
	if (!(n =~ /^\.\/\_[0-9]+\.txt$/)) {
		exit("tempnam error");
	}
	if (!(fp = fopen(n, "w+"))) {
		exit("fopen error");
	}
	if (fp.putc('h','e','l') != 3) {
		exit("file error");
	}
	if (fp.write("lo ") != 3) {
		exit("file error");
	}
	if (fp.puts("world\n") != 6) {
		exit("file error");
	}
	if (!fp.seek(0)) {
		exit("file error");
	}
	if (fp.tell() != 0) {
		exit("file error");
	}
	if (!fp.seek(0, 2)) {
		exit("file error");
	}
	if (fp.tell() != (3 + 3 + 6)) {
		exit("tell error");
	}
	if (!fp.close()) {
		exit("fclose error");
	}
	if (!(fp = fopen(n, "r"))) {
		exit("fopen error");
	}
	if ((fp.getc() != 'h')
	|| (fp.getc() != 'e')
	|| (fp.getc() != 'l')) {
		exit("getc error");
	}
	if (fp.read(3) != "lo ") {
		exit("read error");
	}
	if (fp.gets() != "world\n") {
		exit("gets error");
	}
	fp.close();
	n = "./_[0-9]*.txt";
	a = glob(n);
	if (!isArray(a) || !(a.length > 0)) {
		exit("glob error");
	}
	if (unlink(n) != a.length) {
		exit("unlink error");
	}
}

/* database test */
if (1) {
	var db, n;
	var a = [];
	n = tempnam("./", "_", ".db");
	db = dbopen(n, "rs");
	if (!db) {
		exit("dbopen error");
	}
	db["user"] = "hello";
	db["host"] = "world";
	foreach (var k,v in db) {
		a.push(k+":"+v);
	}
	if (!db.close()) {
		exit("db close error");
	}
	if (a.join(',') != "user:hello,host:world") {
		exit("db error");
	}
	if (!unlink("./_[0-9]*.db")) {
		exit("unlink error");
	}
}

/* eval */
if (1) {
	var a,b,c;
	a = 24;
	b = 12;
	eval("c = a + b");
	if (c != 36) {
		exit("eval error");
	}
	
	c = eval("a / b");
	if (c != 2) {
		exit("eval error");
	}
}

/* sprintf */
if (1) {
	var s = "hello";
	var x = 0x123;
	var n = 123;
	var f = 123.4;
	var k = 1234;
	var r;
	
	if ((r = sprintf("_%.3s", s)) != "_hel") {
		exit("sprintf error: " + r);
	}
	if ((r = sprintf("_%.*s", 3, s)) != "_hel") {
		exit("sprintf error: " + r);
	}
	if ((r = sprintf("_%#04x", x)) != "_0x0123") {
		exit("sprintf error: " + r);
	}
	if ((r = sprintf("_%04d", n)) != "_0123") {
		exit("sprintf error: " + r);
	}
	if ((r = sprintf("_%.3f", f)) != "_123.400") {
		exit("sprintf error: " + r);
	}
	if ((r = sprintf("_%.3g", f)) != "_123.4") {
		exit("sprintf error: " + r);
	}
	if ((r = sprintf("_%.2g", f)) != "_1.2e+02") {
		exit("sprintf error: " + r);
	}
	if ((r = sprintf("_%.2K", k)) != "_1.23K") {
		exit("sprintf error: " + r);
	}
}

/* serial */
if (1) {
	var a = {str:"str",num:123,flo:12.3,arr:[1,2,3]};
	var b = serial(a);
	var c = unserial(b);
	if (!isObject(c) || !isArray(c.arr)) {
		exit("serial error");
	}
	if (c.str != "str") {
		exit("serial error");
	}
	if (c.num != 123) {
		exit("serial error:"+c.num);
	}
	if (c.flo != 12.3) {
		exit("serial error:"+c.flo);
	}
	if (c.arr.join(",") != "1,2,3") {
		exit("serial error:"+c.flo);
	}
}

/* trace */
if (1) {
	var a = {str:"str",num:123,flo:12.3,arr:[1,2,3]};
	var b = trace(a);
	var c = untrace(b);
	if (b != "{\n\tstr:\"str\",\n\tnum:123,\n\tflo:12.3,\n\tarr:[\n\t\t1,\n\t\t2,\n\t\t3\n\t]\n}") {
		exit("trace error");
	}
	if (!isObject(c) || !isArray(c.arr)) {
		exit("serial error");
	}
	if (c.str != "str") {
		exit("serial error");
	}
	if (c.num != 123) {
		exit("serial error:"+c.num);
	}
	if (c.flo != 12.3) {
		exit("serial error:"+c.flo);
	}
	if (c.arr.join(",") != "1,2,3") {
		exit("serial error:"+c.flo);
	}
}


/* date */
if (1) {
	var s, n, r, z, Z, a, b, t, Y, D, f;
	s = "2007/03/08 21:58:50";
	n = time(s);
	z = date("z", n);
	Z = date("Z", n);
	a = date("a", n);
	b = date("b", n);
	Y = date("Y", n);
	D = date("D", n);
	f = date("Y-M-D", n);
	t = date("H:I:S", n);
	if ((r = date("w A", n)) != "4 Thursday") {
		exit("date error: " + r);
	}
	if ((r = date("B", n)) != "March") {
		exit("date error: " + r);
	}
	if ((r = date("y/m/d h p P", n)) != "07/3/8 9 pm PM") {
		exit("date error: " + r);
	}
	if (((r = date("c", n)) != a+" "+b+" "+D+" "+t+" "+Z+" "+Y)
	|| (time(r) != n)) {
		exit("date error: " + r);
	}
	if (((r = date("C", n)) != a+" "+b+" "+D+" "+t+" "+Y)
	|| (time(r) != n)) {
		exit("date error: " + r);
	}
	if (((r = date("r", n)) != a+", "+D+" "+b+" "+Y+" "+t+" "+z)
	|| (time(r) != n)) {
		exit("date error: " + r);
	}
	if (((r = date("R", n)) != D+" "+b+" "+Y+" "+t+" "+z)
	|| (time(r) != n)) {
		exit("date error: " + r);
	}
	if (((r = date("e", n)) != a+", "+D+"-"+b+"-"+Y+" "+t+" "+Z)
	|| (time(r) != n)) {
		exit("date error: " + r);
	}
	if (((r = date("f", n)) != f+" "+t)
	|| (time(r) != n)) {
		exit("date error: " + r);
	}
}

/* pack */
if (1)
{
	var c,h,v,s,r;
	c = 0x21;
	h = (1 << 8) | c;
	v = (1 << 16) | h;
	
	if ((length(r=pack(s="c",c)) != 1) || (unpack(s,r) != c))
		exit("pack error: "+s);
	if ((length(r=pack(s="s",v)) != 2) || (unpack(s,r) != h))
		exit("pack error: "+s);
	if ((length(r=pack(s="i",v)) != 4) || (unpack(s,r) != v))
		exit("pack error: "+s);
	if ((length(r=pack(s="l",v)) != 4) || (unpack(s,r) != v))
		exit("pack error: "+s);
	if ((length(r=pack(s="f",v)) != 4) || (unpack(s,r) != v))
		exit("pack error: "+s);
	if ((length(r=pack(s="d",v)) != 8) || (unpack(s,r) != v))
		exit("pack error: "+s);
	if ((length(r=pack(s="n",v)) != 2) || (unpack(s,r) != h))
		exit("pack error: "+s);
	if ((length(r=pack(s="v",v)) != 2) || (unpack(s,r) != h))
		exit("pack error: "+s);
	if ((length(r=pack(s="N",v)) != 4) || (unpack(s,r) != v))
		exit("pack error: "+s);
	if ((length(r=pack(s="V",v)) != 4) || (unpack(s,r) != v))
		exit("pack error: "+s);
	if ((length(r=pack(s="xx",v)) != 2) || (unpack(s,r) != 0))
		exit("pack error: "+s);
	
	c = pack("c", c);
	if ((length(r=unpack(s="B*",c)) != 8) || (pack(s,r) != c))
		exit("pack error: "+s);
	if ((length(r=unpack(s="b*",c)) != 8) || (pack(s,r) != c))
		exit("pack error: "+s);
	if ((length(r=unpack(s="H*",c)) != 2) || (pack(s,r) != c))
		exit("pack error: "+s);
	if ((length(r=unpack(s="h*",c)) != 2) || (pack(s,r) != c))
		exit("pack error: "+s);
}

/* encode / quote / jconv */
if (1) {
	var r, f, s;
	
	s = "hello \"日本語\" world!";
	
	if (((r = encode(s, f="b")) !~ `^[\w\+\/]+$`) || (decode(r,f) != s)) {
		exit("encode error:"+f+":"+r);
	}
	if (((r = encode(s, f="q")) !~ `(=[0-9a-f]{2})+`i) || (decode(r,f) != s)) {
		exit("encode error:"+f+":"+r);
	}
	if (((r = encode(s, f="m")) !~ `=?[\w\-]+\?b\?[\w\+\/]+\?=`i) || (decode(r,f) != s)) {
		exit("encode error:"+f+":"+r);
	}
	if (((r = encode(s, f="u")) !~ `(%[0-9a-f]{2})+`i) || (decode(r,f) != s)) {
		exit("encode error:"+f+":"+r);
	}
	if (((r = encode(s, f="h")) !~ `&[a-z]+;`) || (decode(r,f) != s)) {
		exit("encode error:"+f+":"+r);
	}
	if (((r = quote(s)) !~ `^"[^\\]+\\\"[^\\]+\\\"[^\"]+"$`) || (unquote(r) != s)) {
		exit("quote error: "+r);
	}
	if (((r=jconv(s, f="j")) !~ `"\x1b\$B[\x21-\x7e]{6}\x1b\(B"`) || (jconv(r) != s)) {
		exit("jconv error:"+f+":"+r);
	}
	if (((r=jconv(s, f="s")) !~ `"([\x81-\x9F\xe0-\xfC].){3}"`) || (jconv(r) != s)) {
		exit("jconv error:"+f+":"+r);
	}
	if (((r=jconv(s, f="e")) !~ `"[\xa1-\xfe]{6}"`) || (jconv(r) != s)) {
		exit("jconv error:"+f+":"+r);
	}
}

/* math */
if (1) {
	var r, i, j;
	var ex = [
	"sin(1)",     84,   "cos(1)",  54,   "tan(1)", 155,
	"asin(1)",   157,  "acos(0)", 157,  "atan(1)",  78,
	"atan2(1,1)", 78, "pow(2,2)", 400,  "sqrt(2)", 141,
	"exp(1)",    271,   "log(2)",  69, "log10(2)",  30 ];
	
	for (i=0; i < ex.length; i+=2) {
		if ((r = (int)(eval(ex[i]) * 100)) != ex[i+1]) {
			exit(ex[i]+":"+r+" != "+ex[i+1]);
		}
	}
	if (((r=ceil(0.01)) != 1) || ((r=ceil(1.01)) == 1)) {
		exit("ceil error: "+r);
	}
	if (((r=floor(1.99)) != 1) || ((r=floor(0.99)) == 1)) {
		exit("floor error: "+r);
	}
	if (((r=round(0.59)) != 1) || ((r=round(0.49)) == 1)) {
		exit("round error: "+r);
	}
	if (((r=abs(1)) != 1) || ((r=abs(-1.1)) != 1.1)) {
		exit("abs error: "+r);
	}
	if (!isinf(r=1.1/0.0) || isinf(r=0.0/0.0) || isinf(r=0.0)) {
		exit("isinf error: "+r);
	}
	if (!isnan(r=0.0/0.0) || isnan(r=1.1/0.0) || isnan(r=0.0)) {
		exit("isnan error: "+r);
	}
	if (!isfinite(r=0.0) || isfinite(r=1.1/0.0) || isfinite(r=0.0/0.0)) {
		exit("isfinite error: "+r);
	}
	if ((min(1, 2, 3) != 1) || (min(0.3, 0.2, 0.1) != 0.1)) {
		exit("min error: "+r);
	}
	if ((max(3, 2, 1) != 3) || (max(0.1, 0.2, 0.3) != 0.3)) {
		exit("max error: "+r);
	}
	for (i=0; i < 10; i++) {
		r = rand();
		if ((r < 0.0) || (r >= 1.0)) {
			exit("rand error: "+r);
		}
		if (rand() == r) {
			exit("rand error: "+r);
		}
	}
	for (i=0; i < 10; i++) {
		r = rand(0.1);
		if ((r < 0.0) || (r >= 0.1)) {
			exit("rand error: "+r);
		}
		if (rand() == r) {
			exit("rand error: "+r);
		}
	}
	for (i=0; i < 10; i++) {
		r = rand(2);
		if ((r != 0) && (r != 1)) {
			exit("rand error: "+r);
		}
	}
}

/* finish */
println("hello world!");

exit;
