/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"

static char* g_mons[] = {
"January",
"February",
"March",
"April",
"May",
"June",
"July",
"August",
"September",
"October",
"November",
"December"
};

static char* g_weeks[] = {
"Sunday",
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday"
};

int strtotime(char *src, int len, int gm)
{
	struct tm tm;
	struct { char *s; int n; } p[10];
	int i,j,n,Y,M,D,H,I,S;
	
	i = 0;
	while ((i < len) && !isalnum(src[i])) i++;
	for (n = 0; (i < len) && isalnum(src[i]) && (n < 10); n++) {
		j = i;
		while ((i < len) && isalnum(src[i])) i++;
		p[n].s = src + j;
		p[n].n = i - j;
		while ((i < len) && !isalnum(src[i])) i++;
	}
	Y = M = D = H = I = S = -1;
	if ((n >= 3) && (isalpha(*(p[0].s)) || isalpha(*(p[1].s)) || isalpha(*(p[2].s)))) {
		/* some == month and first digits == mday */
		Y = M = 0;
	}
	for (i=0; i < n; i++) {
		if (isalpha(*(p[i].s))) {
			if (M <= 0) {
				for (j=0; j < 12; j++) {
					if (!strnncasecmp(p[i].s, 3, g_mons[j], 3)) {
						M = j + 1;
						break;
					}
				}
			}
		} else if (*(p[i].s + p[i].n) == ':') {
			if (H < 0) {
				H = atoi(p[i].s);
				if (((i+1) < n) && isdigit(*(p[i+1].s))) {
					I = atoi(p[++i].s);
					if (((i+1) < n) && isdigit(*(p[i+1].s))) {
						S = atoi(p[++i].s);
					}
				}
			}
		} else {
			if (Y < 0) Y = atoi(p[i].s);
			else if (M < 0) M = atoi(p[i].s);
			else if (D < 0) D = atoi(p[i].s);
			else if (!Y) Y = atoi(p[i].s);
			else if (!M) M = atoi(p[i].s);
		}
	}
	
	memset(&tm, 0, sizeof(struct tm));
	if (Y >  0) tm.tm_year = (Y > 1900) ? (Y - 1900) : ((Y < 70) ? (Y + 100) : Y);
	if (M >  0) tm.tm_mon  = M - 1;
	if (D >  0) tm.tm_mday = D;
	if (H >= 0) tm.tm_hour = H;
	if (I >= 0) tm.tm_min  = I;
	if (S >= 0) tm.tm_sec  = S;
	
	S = mktime(&tm);
	if (gm) {
		S += tm.tm_gmtoff;
	}
	
	return S;
}

int timetostr(char dst[BUFSIZ], char *fmt, int n, int t, int gm)
{
	time_t tv;
	struct tm *tm;
	int c, len;
	int Y,y,M,D,H,h,I,S,w,z;
	char *A,*B,*Z,*P,*p;

	tv = t;
	if (gm) {
		tm = gmtime(&tv);
	} else {
		tm = localtime(&tv);
	}
	Y = tm->tm_year + 1900;
	M = tm->tm_mon + 1;
	D = tm->tm_mday;
	H = tm->tm_hour;
	I = tm->tm_min;
	S = tm->tm_sec;
	w = tm->tm_wday;
	Z = gm ? "GMT" : (char*)tm->tm_zone;
	z = gm ? 0 : (tm->tm_gmtoff / 36);
	
	y = Y % 100;
	h = H % 12;
	P = (H > 12) ? "PM" : "AM";
	p = (H > 12) ? "pm" : "am";
	A = g_weeks[w];
	B = g_mons[M - 1];
	
	len = 0;
	while ((c = *fmt++) != 0) {
		if (!isalpha(c)) {
			dst[len++] = c;
			continue;
		}
		switch (c) {
		case 'c': /* ctime */
			len += sprintf(dst + len,
			"%.3s %.3s %02d %02d:%02d:%02d %s %04d", A,B,D,H,I,S,Z,Y);
			break;
		case 'C': /* ctime (no Z) */
			len += sprintf(dst + len,
			"%.3s %.3s %02d %02d:%02d:%02d %04d", A,B,D,H,I,S,Y);
			break;
		case 'r': /* rfc822 */
			len += sprintf(dst + len,
			"%.3s, %02d %.3s %04d %02d:%02d:%02d %+05d", A,D,B,Y,H,I,S,z);
			break;
		case 'R': /* rfc822 (no A) */
			len += sprintf(dst + len,
			"%02d %.3s %04d %02d:%02d:%02d %+05d", D,B,Y,H,I,S,z);
			break;
		case 'e': /* cookie expire */
			len += sprintf(dst + len,
			"%.3s, %02d-%.3s-%04d %02d:%02d:%02d %s", A,D,B,Y,H,I,S,Z);
			break;
		case 'f':
			len += sprintf(dst + len, "%04d-%02d-%02d %02d:%02d:%02d", Y,M,D,H,I,S);
			break;
		case 't':
			len += sprintf(dst + len, "%02d:%02d:%02d", H,I,S);
			break;
		/* date part */
		case 'Y': len += sprintf(dst + len, "%04d", Y); break;
		case 'y': len += sprintf(dst + len, "%02d", y); break;
		case 'M': len += sprintf(dst + len, "%02d", M); break;
		case 'm': len += sprintf(dst + len, "%d"  , M); break;
		case 'D': len += sprintf(dst + len, "%02d", D); break;
		case 'd': len += sprintf(dst + len, "%d"  , D); break;
		/* time */
		case 'H': len += sprintf(dst + len, "%02d", H); break;
		case 'I': len += sprintf(dst + len, "%02d", I); break;
		case 'S': len += sprintf(dst + len, "%02d", S); break;
		case 'h': len += sprintf(dst + len, "%d",   h); break;
		case 'P': len += sprintf(dst + len, "%s"  , P); break;
		case 'p': len += sprintf(dst + len, "%s"  , p); break;
		/* wday */
		case 'w': len += sprintf(dst + len, "%d"  , w); break;
		/* time zone */
		case 'z': len += sprintf(dst + len, "%+05d", z); break;
		case 'Z': len += sprintf(dst + len, "%s"   , Z); break;
		/* week month string */
		case 'A': len += sprintf(dst + len, "%s"  , A); break;
		case 'a': len += sprintf(dst + len, "%.3s", A); break;
		case 'B': len += sprintf(dst + len, "%s"  , B); break;
		case 'b': len += sprintf(dst + len, "%.3s", B); break;
		}
	}
	dst[len] = 0;
	
	return len;
}

