/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"

FILE *g_stderr = stderr;
FILE *g_stdout = stdout;

/************************************************************
 *
 ************************************************************/
void trace(char* fmt, ...)
{
	va_list va;
	va_start(va, fmt);
	vfprintf(g_stdout, fmt, va);
	va_end(va);
}
void warns(char* fmt, ...)
{
	va_list va;
	va_start(va, fmt);
	vfprintf(g_stderr, fmt, va);
	va_end(va);
}

/************************************************************
 *
 ************************************************************/
char* tmpbuf()
{
	static char p[16][256];
	static int i = 0;
	if (i>=16) i=0;
	return p[i++];
}

/************************************************************
 *
 ************************************************************/
char* strndupok(char *s, int n)
{
	char *p = malloc(n + 1);
	/* strncpy */
	memcpy(p, s, n);
	p[n] = 0;
	return p;
}
int sputsn(char *d, char *s, int n)
{
	memcpy(d, s, n);
	/* d[n] = 0; */
	return n;
}
int sputs(char *d, char *s)
{
	int n = strlen(s);
	memcpy(d, s, n);
	/* d[n] = 0; */
	return n;
}
int strnncmp(char *s1, int n1, char* s2, int n2)
{
	int i,r;
	for (i=0; (i < n1) && (i < n2); i++) {
		if ((r = s1[i] - s2[i]) != 0) return r;
	}
	return (n1 - n2);
}
int strrnncmp(char *s1, int n1, char* s2, int n2)
{
	int i,r;
	if ((r = n1 - n2) != 0) return r;
	for (i=0; i < n1; i++) {
		if ((r = s1[i] - s2[i]) != 0) return r;
	}
	return 0;
}
int strnncasecmp(char *s1, int n1, char* s2, int n2)
{
	int i,r;
	for (i=0; (i < n1) && (i < n2); i++) {
		if ((r = tolower(s1[i]) - tolower(s2[i])) != 0) return r;
	}
	return (n1 - n2);
}
int strrnncasecmp(char *s1, int n1, char* s2, int n2)
{
	int i,r;
	if ((r = n1 - n2) != 0) return r;
	for (i=0; i < n1; i++) {
		if ((r = tolower(s1[i]) - tolower(s2[i])) != 0) return r;
	}
	return 0;
}
int strtoh(char *s, int n)
{
	int i, c, k = 0;
	for (k = i = 0; (i < n) && ((c = s[i]) > 0); i++) {
		k = ((k & 0xFFFFFF) << 7) ^ (k >> 24) ^ c;
	}
	return k;
}
int strtonum(char *s, int n, double *f, int *i)
{
	char *e;
	*f = *i = strtol(s, &e, 0);
	if ((e < (s + n)) && *e && strchr(".Ee", *e)) {
		*i = *f = strtod(s, &e);
		return 2;
	}
	return (e > s);
}
int isoctal(int c)
{
	return (c >= '0' && c <= '7');
}
int iscrlf(int c)
{
	return ((c == 0xa) || (c == 0xd));
}
int itoX(int c)
{
	if (c < 10) return (c + '0');
	if (c < 16) return ((c - 10) + 'A');
	return '0';
}
int xtoi(int c)
{
	return (isalpha(c) ? (10 + tolower(c) - 'a') : (isdigit(c) ? (c - '0') : 0));
}
int ischar(int c, char *s)
{
	return (c && (strchr(s, c) != NULL));
}
int metac(int* c, int q)
{
	if ((*c == q) || (*c == '\\')) {
		return 1;
	}
	if (((q == '`') || (q == '/'))
	&& *c && strchr("^.*+?[-](|){,}$", *c)) {
		return 1;
	}
	switch (*c) {
	case 0x0: *c = '0'; return 1;
	case 0x7: *c = 'a'; return 1;
	case 0x8: *c = 'b'; return 1;
	case 0x9: *c = 't'; return 1;
	case 0xa: *c = 'n'; return 1;
	case 0xb: *c = 'v'; return 1;
	case 0xc: *c = 'f'; return 1;
	case 0xd: *c = 'r'; return 1;
	}
	return 0;
}
int unmetac(char** s, int q)
{
	int c;
	if (!(c = *(*s))) {
		return '\\';
	} else if (c == 'x') {
		(*s)++;
		if (!isxdigit(*(*s))) return 0;
		c = xtoi(*(*s)++);
		if (!isxdigit(*(*s))) return c;
		return ((c << 4) | xtoi(*(*s)++));
	} else if (c == '0') {
		(*s)++;
		if (!isoctal(*(*s))) return 0;
		c = *(*s)++ - '0';
		if (!isoctal(*(*s))) return c;
		return ((c << 3) | (*(*s)++ - '0'));
	} else if ((c == q) || (c == '\\')) {
		return *(*s)++;
	}
	switch (c) {
	case 'a': (*s)++; return 0x7;
	case 'b': (*s)++; return 0x8;
	case 't': (*s)++; return 0x9;
	case 'n': (*s)++; return 0xa;
	case 'v': (*s)++; return 0xb;
	case 'f': (*s)++; return 0xc;
	case 'r': (*s)++; return 0xd;
	}
	return (q ? '\\' : *(*s)++);
}
int vmclose(char *mp, int sz, FILE* fp)
{
	int r1, r2;
	r1 = munmap(mp, sz) == 0;
	r2 = fclose(fp) == 0;
	return (r1 && r2);
}
char* vmopen(char *fn, int *sz, FILE **fp)
{
	char *mp;
	if (!(*fp = fopen(fn, "r"))) {
		return NULL;
	}
	fseek(*fp, 0, SEEK_END);
	*sz = ftell(*fp);
	rewind(*fp);
	mp = mmap(0, *sz, PROT_READ, MAP_SHARED, fileno(*fp), 0);
	if (mp == MAP_FAILED) {
		fclose(*fp);
		return NULL;
	}
	return mp;
}

/************************************************************
 *
 ************************************************************/
int stream_putc(stream_t* st, int c)
{
	if (st->fp) {
		if (fputc(c, st->fp) < 0) return 0;
	} else {
		st->sp = realloc(st->sp, st->len + 2);
		st->sp[st->len] = c;
	}
	st->len++;
	return 1;
}
int stream_write(stream_t* st, char *s, int n)
{
	if (st->fp) {
		if (fwrite(s, 1, n, st->fp) != 0) return 0;
	} else {
		st->sp = realloc(st->sp, st->len + n + 1);
		memcpy(st->sp + st->len, s, n);
	}
	st->len += n;
	return n;
}
int stream_flush(stream_t* st)
{
	if (st->fp) {
		if (fflush(st->fp) < 0) return 0;
	} else {
		if (!st->sp || !st->len) {
			if (st->sp) free(st->fp);
			st->fp = NULL;
			st->len = 0;
			return 0;
		}
		st->sp[st->len] = 0;
	}
	return st->len;
}
