/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#ifndef _VAR_H_
#define _VAR_H_

typedef enum {
V_null      ,
V_bool      ,
V_char      ,
V_int       ,
V_symbol    ,
V_float     ,
V_file      ,
V_dbm       ,
V_function  ,
V_class     ,
V_label     ,
V_frame     ,
V_string    ,
V_regex     ,
V_array     ,
V_refer     ,
V_object    ,
} vt_t;

typedef struct exec_t    exec_t;
typedef struct name_t    name_t;
typedef struct link_t    link_t;
typedef struct var_t     var_t;
typedef struct string_t  string_t;
typedef struct array_t   array_t;
typedef struct object_t  object_t;
typedef struct proto_t   proto_t;

struct name_t {
	int k;
	char *s;
	int n;
};

struct link_t {
	int lock;
	link_t* prev;
	link_t* next;
	proto_t* proto;
};

struct var_t {
	vt_t type;
	union {
		int i;
		double f;
		void* p;
	} u;
};

struct string_t {
	char* s;
	int n;
};

struct array_t {
	var_t* v;
	int n;
};

typedef struct {
	int k;
	var_t v;
} each_t;

struct object_t {
	each_t* e;
	int n;
	object_t* p;
};

struct exec_t {
	link_t* gc;
	object_t* gp;
	object_t* fp;
	char *bc;
	array_t* sp;
	int lc;
	int req;
	/* arg */
	int argc;
	var_t* argv;
	var_t* res;
	/* info */
	/* char* op; */
	char* func;
	char* file;
	int line;
};

struct proto_t {
	char*  typestr;
	int    lock;
	void   (*trace)      (void*);
	void   (*clear)      (exec_t*, void*);
	int    (*toBool)     (var_t*);
	int    (*toChar)     (var_t*);
	int    (*toInt)      (var_t*);
	double (*toFloat)    (var_t*);
	int    (*toString)   (var_t*, char **s, int *n);
	int    (*toNumber)   (var_t*, double*, int*);
	int    (*getLength)  (exec_t*, void*);
	int    (*setLength)  (exec_t*, void*, int);
	int    (*callFunc)   (exec_t*, void*, int, int, var_t*, var_t*);
	int    (*getItem)    (exec_t*, void*, var_t*, var_t*);
	int    (*setItem)    (exec_t*, void*, var_t*, var_t*);
	int    (*delItem)    (exec_t*, void*, var_t*, var_t*);
	int    (*eachItem)   (exec_t*, void*, int, var_t*, var_t*);
	int    reserve;
};

extern int compile_code_to_bytes(char* file, char *sc, int sz, char **bc, int* bn);
extern int compile_file_to_bytes(char *file, char **bc, int* bn);
extern int compile_file_to_file(char *scfile, char *bcfile);
extern int call_frame(exec_t* ex);
extern int call_bytes(exec_t* ex, char*, char*, int, var_t*, var_t*);
extern int call_function(exec_t* ex, object_t* gp, int sym, char*, int, var_t*, var_t*);
extern int eval_bytes(exec_t* ex, char *sc, int sz, var_t* res);
extern int exec_bytes(char *bc, int bn);
extern int exec_file(char *bcfile);
extern int exec_string(char *sc, int sz);
extern int exec_source(char *scfile);

extern proto_t null_proto;
extern proto_t bool_proto;
extern proto_t char_proto;
extern proto_t int_proto;
extern proto_t symbol_proto;
extern proto_t float_proto;
extern proto_t string_proto;
extern proto_t regex_proto;
extern proto_t array_proto;
extern proto_t refer_proto;
extern proto_t object_proto;
extern proto_t frame_proto;
extern proto_t file_proto;
extern proto_t dbm_proto;
extern proto_t function_proto;
extern proto_t class_proto;
extern proto_t label_proto;
extern proto_t* all_protos[];

#endif /* _VAR_H_ */
