/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
int string_add(string_t* str, char *s, int n)
{
	if (!s || (n <= 0)) {
		return 0;
	}
	str->s = realloc(str->s, str->n + n + 1);
	/* strn0cpy */
	memcpy(str->s + str->n, s, n);
	str->s[str->n += n] = 0;
	return 1;
}
int string_get(exec_t* ex, string_t* str, int i, var_t* v)
{
	if (i < 0) i += str->n;
	if ((i < 0) || (i >= str->n)) {
		new_null(v);
		return 0;
	}
	new_char(v, str->s[i]);
	return 1;
}
int string_del(exec_t* ex, string_t* str, int i, var_t* v)
{
	if (i < 0) i += str->n;
	if ((i < 0) || (i >= str->n)) {
		new_null(v);
		return 0;
	}
	if (v) {
		new_char(v, str->s[i]);
	}
	memmove(str->s + i, str->s + i + 1, --str->n - i);
	return 1;
}
int string_set(exec_t* ex, string_t* str, int i, var_t* v)
{
	int c;
	c = var_toChar(ex, v);
	if (i < 0) i += str->n + 1;
	if (i < 0) i = 0;
	if (i >= str->n) {
		str->s = realloc(str->s, i + 2);
		if (i > str->n) {
			memset(str->s + str->n, ' ', i - str->n);
		}
		str->s[str->n = i + 1] = 0;
	}
	str->s[i] = c;
	return 1;
}
#ifdef OLD_VERSION
int string_match(exec_t* ex, char *s1, int n1, var_t* val, var_t* res)
{
	int so[10], eo[10];
	char *s2;
	int i, n2, m;
	var_t v;
	
	if (val->p != regex_proto) {
		exerrif(ex, !s1 || !n1, "bad data");
		exerrif(ex, !var_toString(ex, val, &s2, &n2), "bad argument-0") ;
		for (i = 0; (i + n2) <= n1; i++) {
			if (!strncmp(s1 + i, s2, n2)) {
				/* what to return ? */
				if (res) {
					new_string_copy(ex, res, s1 + i, n1 - i);
				}
				return 1;
			}
		}
		return 0;
	}
	
	i = m = 0;
	while ((i = regex_exec(ex, val->u.p, s1, n1, i, so, eo)) > 0) {
		m = i;
		i = eo[0] + (eo[0] == so[0]);
	}
	if (!m) {
		return 0;
	}
	if (!res) {
		return m;
	}
	new_array(ex, res, NULL);
	for (i = 0; i < m; i++) {
		if (eo[i] > so[i]) {
			new_string_copy(ex, &v, s1 + so[i], eo[i] - so[i]);
		} else {
			new_null(&v);
		}
		array_push(ex, res->u.p, &v);
	}
	return m;
}
#else
int string_match(exec_t* ex, char *s1, int n1, var_t* val, var_t* res)
{
	int so[10], eo[10];
	char *s2;
	int i, n2, m;
	var_t v1, v2;
	
	if (val->p != regex_proto) {
		exerrif(ex, !s1 || !n1, "bad data");
		exerrif(ex, !var_toString(ex, val, &s2, &n2), "bad argument-0") ;
		for (i = 0; (i + n2) <= n1; i++) {
			if (!strncmp(s1 + i, s2, n2)) {
				/* what to return ? */
				if (res) {
					new_string_copy(ex, res, s1 + i, n1 - i);
				}
				return 1;
			}
		}
		return 0;
	}
	
	if (res) {
		new_array(ex, res, NULL);
	}
	i = m = 0;
	while ((i = regex_exec(ex, val->u.p, s1, n1, i, so, eo)) > 0) {
		m = i;
		if (res) {
			new_array(ex, &v1, NULL);
			for (i = 0; i < m; i++) {
				if (eo[i] > so[i]) {
					new_string_copy(ex, &v2, s1 + so[i], eo[i] - so[i]);
				} else {
					new_null(&v2);
				}
				array_push(ex, v1.u.p, &v2);
			}
			array_push(ex, res->u.p, &v1);
		}
		i = eo[0] + (eo[0] == so[0]);
	}
	if (!m) {
		if (res) {
			array_free(ex, res->u.p);
		}
		return 0;
	}
	return m;
}
#endif

/************************************************************
 *
 ************************************************************/
void* string_alloc(exec_t* ex)
{
	return alloc_link(ex, sizeof(string_t), string_proto);
}
void string_free(exec_t* ex, void *v)
{
	free_link(ex, v);
}

/************************************************************
 *
 ************************************************************/
void string_trace(exec_t* ex, void *p)
{
	string_t* str = p;
	fprintf(ex->out, " %.*s\n", str->n, str->s ? str->s : "");
}
void string_clear(exec_t* ex, void *p)
{
	string_t* str = p;
	if (str->s) {
		free(str->s);
		str->s = NULL;
	}
	str->n = 0;
}
int string_getItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return string_get(ex, p, var_toInt(ex, k), v);
}
int string_delItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return string_del(ex, p, var_toInt(ex, k), v);
}
int string_setItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return string_set(ex, p, var_toInt(ex, k), v);
}
int string_eachItem(exec_t* ex, void *p, int i, var_t* k, var_t* v)
{
	string_t* str = p;
	if ((i < 0) || (i >= str->n)) {
		return 0;
	}
	if (k) new_int(k, i);
	if (v) new_char(v, str->s[i]);
	return 1;
}
int string_setLength(exec_t* ex, void *p, int n)
{
	string_t* str = p;
	if (n < 0) n += str->n;
	if (n < 0) n=0;
	if (n > str->n) {
		str->s = realloc(str->s, n + 1);
		memset(str->s + str->n, ' ', n - str->n);
		str->s[str->n = n] = 0;
	} else if (n < str->n) {
		str->s[str->n = n] = 0;
	}
	return 1;
}
int string_getLength(exec_t* ex, void *p)
{
	return ((string_t*)p)->n;
}
int string_toBool(exec_t* ex, var_t* v)
{
	string_t* str = v->u.p;
	return (str->s && str->n);
}
int string_toChar(exec_t* ex, var_t* v)
{
	string_t* str = v->u.p;
	if (str->s && str->n) {
		return *str->s;
	}
	return 0;
}
int string_toInt(exec_t* ex, var_t* v)
{
	string_t* str = v->u.p;
	if (str->s && str->n) {
		return strtol(str->s, NULL, 0);
	}
	return 0;
}
double string_toFloat(exec_t* ex, var_t* v)
{
	string_t* str = v->u.p;
	if (str->s && str->n) {
		return strtod(str->s, NULL);
	}
	return 0;
}
int string_toString(exec_t* ex, var_t* v, char **s, int *n)
{
	string_t* str = v->u.p;
	if (str->s && str->n) {
		*s = str->s;
		*n = str->n;
		return *n;
	}
	*s = NULL;
	*n = 0;
	return 0;
}
int string_toNumber(exec_t* ex, var_t* v, double *f, int *i)
{
	string_t* str = v->u.p;
	if (str->s && str->n) {
		return strtonum(str->s, str->n, f, i);
	}
	*f = *i = 0;
	return 0;
}

/************************************************************
 *
 ************************************************************/
static int _string_trim(exec_t* ex, string_t* str, int argc, var_t* argv, var_t* res)
{
	char *s, *e;
	char *mode = NULL;
	exerrif(ex, argc > 1, "bad arguments");
	if (argc >= 1) {
		mode = var_toChars(ex, argv);
	}
	if (!str->s || !str->n) return 0;
	s = str->s;
	e = s + str->n;
	while ((s < e) && isspace(*s)) s++;
	while ((e > s) && isspace(*(e-1))) e--;
	if (e <= s) return 0;
	new_string_copy(ex, res, s, e - s);
	return 1;
}
static int _string_substr(exec_t* ex, string_t* str, int argc, var_t* argv, var_t* res)
{
	int i, n, m;
	exerrif(ex, argc < 1, "bad arguments") ;
	exerrif(ex, !str->s || !str->n, "bad data");
	i = var_toInt(ex, argv);
	if (i < 0) i += str->n;
	exerrif(ex, (i < 0) || (i >= str->n), "bad argument-0");
	m = n = str->n - i;
	if (argc >= 2) {
		n = var_toInt(ex, argv + 1);
		if (n < 0) n += m;
		if (n > m) n = m;
	} 
	exerrif(ex, n <= 0, "bad argument-1") ;
	new_string_copy(ex, res, str->s + i, n);
	return 1;
}
static int _string_index(exec_t* ex, string_t* str, int argc, var_t* argv, var_t* res)
{
	char *s;
	int n;
	int i;
	new_int(res, -1);
	
	exerrif(ex, argc < 1, "bad arguments");
	exerrif(ex, !str->s || !str->n, "bad data");
	i = 0;
	if (argc >= 2) {
		i = var_toInt(ex, argv + 1);
		if (i < 0) i += str->n;
		exerrif(ex, (i < 0) || (i >= str->n), "bad argument-1");
	}
	exerrif(ex, !var_toString(ex, argv, &s, &n), "bad argument-0") ;
	exerrif(ex, n > (str->n - i), "bad argument-0") ;
	
	for (; i <= (str->n - n); i++) {
		if (!strncmp(str->s + i, s, n)) {
			new_int(res, i);
			return 1;
		}
	}
	/* not found */
	return 1;
}
static int _string_rindex(exec_t* ex, string_t* str, int argc, var_t* argv, var_t* res)
{
	char *s;
	int n;
	int i;
	new_int(res, -1);
	
	exerrif(ex, argc < 1, "bad arguments");
	exerrif(ex, !str->s || !str->n, "bad data");
	i = 0;
	if (argc >= 2) {
		i = var_toInt(ex, argv + 1);
		if (i < 0) i += str->n;
		exerrif(ex, (i < 0) || (i >= str->n), "bad argument-1");
	}
	exerrif(ex, !var_toString(ex, argv, &s, &n), "bad argument-0") ;
	exerrif(ex, n > (str->n - i), "bad argument-0") ;
	
	i = (str->n - n) - i;
	for (; i >= 0; i--) {
		if (!strncmp(str->s + i, s, n)) {
			new_int(res, i);
			return 1;
		}
	}
	/* not found */
	return 1;
}
static int _string_match(exec_t* ex, string_t* str, int argc, var_t* argv, var_t* res)
{
	int n;
	
	exerrif(ex, argc < 1, "bad arguments") ;
	
	n = string_match(ex, str->s, str->n, argv, res);
	
	return (n > 0);
}
static int _string_repmatch(exec_t* ex, string_t* str, int argc, var_t* argv, var_t* res)
{
	string_t *newstr;
	var_t v1, v2;
	int so[10], eo[10];
	char *s, *r;
	int i,j,k,n,m;
	
	exerrif(ex, argc < 1, "bad arguments") ;
	
	if ((argc < 2) || !var_toString(ex, argv + 1, &r, &m)) {
		r = NULL;
		m = 0;
	}
	
	if (argv->p != regex_proto)
	{
		exerrif(ex, !str->s || !str->n, "bad data") ;
		exerrif(ex, !var_toString(ex, argv, &s, &n), "bad argument-0") ;
		newstr = string_alloc(ex);
		i = n = 0;
		for (j = 0; (j + n) <= str->n; j++) {
			if (!strncmp(str->s + j, s, n)) {
				if (j > i) {
					string_add(newstr, str->s + i, j - i);
				}
				if (m) {
					string_add(newstr, r, m);
				}
				j += n - 1;
				i = j + 1;
				n++;
			}
		}
		if (n <= 0) {
			string_free(ex, newstr);
			return 0;
		}
		if (i < str->n) {
			string_add(newstr, str->s + i, str->n - i);
		}
		
		new_int(res, n);
	}
	else
	{
		new_array(ex, res, NULL);
		newstr = string_alloc(ex);
		i = n = 0;
		while ((j = regex_exec(ex, argv->u.p, str->s, str->n, i, so, eo)) > 0) {
			n = j;
			if (so[0] > i) {
				string_add(newstr, str->s + i, so[0] - i);
			}
			i = 0;
			for (j = 0; j < (m - 1); j++) {
				if ((r[j] == '$') && (isdigit(r[j+1]) || (r[j+1]=='+'))) {
					if (j > i) {
						string_add(newstr, r + i, j - i);
					}
					k = isdigit(r[++j]) ? (r[j] - '0') : (n - 1);
					if ((k < n) && (eo[k] > so[k])) {
						string_add(newstr, str->s + so[k], eo[k] - so[k]);
					}
					i = j + 1;
				}
			}
			if (i < m) {
				string_add(newstr, r + i, m - i);
			}
			if (1) {
				new_array(ex, &v1, NULL);
				for (i = 0; i < n; i++) {
					if (eo[i] > so[i]) {
						new_string_copy(ex, &v2, str->s + so[i], eo[i] - so[i]);
					} else {
						new_null(&v2);
					}
					array_push(ex, v1.u.p, &v2);
				}
				array_push(ex, res->u.p, &v1);
			}
			i = eo[0] + (eo[0] == so[0]);
		}
		if (n <= 0) {
			string_free(ex, newstr);
			array_free(ex, res->u.p);
			return 0;
		}
		if (i < str->n) {
			string_add(newstr, str->s + i, str->n - i);
		}
	}
	
	free(str->s);
	memcpy(str, newstr, sizeof(string_t));
	memset(newstr, 0, sizeof(string_t));
	string_free(ex, newstr);
	
	return 1;
}
static int _string_replace(exec_t* ex, string_t* str, int argc, var_t* argv, var_t* res)
{
	int so[10], eo[10];
	char *s, *r;
	int i,j,k,n,m;
	
	exerrif(ex, argc < 1, "bad arguments") ;
	
	if ((argc < 2) || !var_toString(ex, argv + 1, &r, &m)) {
		r = NULL;
		m = 0;
	}
	
	if (argv->p != regex_proto)
	{
		exerrif(ex, !str->s || !str->n, "bad data") ;
		exerrif(ex, !var_toString(ex, argv, &s, &n), "bad argument-0") ;
		new_string(ex, res, NULL);
		i = 0;
		for (j = 0; (j + n) <= str->n; j++) {
			if (!strncmp(str->s + j, s, n)) {
				if (j > i) {
					string_add(res->u.p, str->s + i, j - i);
				}
				if (m) {
					string_add(res->u.p, r, m);
				}
				j += n - 1;
				i = j + 1;
			}
		}
		if (i < str->n) {
			string_add(res->u.p, str->s + i, str->n - i);
		}
	}
	else
	{
		new_string(ex, res, NULL);
		i = n = 0;
		while ((j = regex_exec(ex, argv->u.p, str->s, str->n, i, so, eo)) > 0) {
			n = j;
			if (so[0] > i) {
				string_add(res->u.p, str->s + i, so[0] - i);
			}
			i = 0;
			for (j = 0; j < (m - 1); j++) {
				if ((r[j] == '$') && (isdigit(r[j+1]) || (r[j+1]=='+'))) {
					if (j > i) {
						string_add(res->u.p, r + i, j - i);
					}
					k = isdigit(r[++j]) ? (r[j] - '0') : (n - 1);
					if ((k < n) && (eo[k] > so[k])) {
						string_add(res->u.p, str->s + so[k], eo[k] - so[k]);
					}
					i = j + 1;
				}
			}
			if (i < m) {
				string_add(res->u.p, r + i, m - i);
			}
			i = eo[0] + (eo[0] == so[0]);
		}
		if (i < str->n) {
			string_add(res->u.p, str->s + i, str->n - i);
		}
	}
	
	return 1;
}
static int _string_split(exec_t* ex, string_t* str, int argc, var_t* argv, var_t* res)
{
	int so[10], eo[10];
	char *s;
	int n,i,j;
	var_t v;
	
	exerrif(ex, argc < 1, "bad arguments");
	exerrif(ex, !str->s || !str->n, "bad data") ;
	
	if (argv->p != regex_proto)
	{
		exerrif(ex, !var_toString(ex, argv, &s, &n), "bad argument-0") ;
		new_array(ex, res, NULL);
		i = 0;
		for (j = 0; (j + n) <= str->n; j++) {
			if (!strncmp(str->s + j, s, n)) {
				if (j > i) {
					new_string_copy(ex, res->u.p, str->s + i, j - i);
				} else {
					new_null(&v);
				}
				j += n - 1;
				i = j + 1;
			}
		}
		if (i < str->n) {
			new_string_copy(ex, &v, str->s + i, str->n - i);
			array_push(ex, res->u.p, &v);
		}
	}
	else
	{
		new_array(ex, res, NULL);
		i = 0;
		while ((n = regex_exec(ex, argv->u.p, str->s, str->n, i, so, eo)) > 0) {
			if (so[0] > i) {
				new_string_copy(ex, &v, str->s + i, so[0] - i);
			} else {
				new_null(&v);
			}
			array_push(ex, res->u.p, &v);
			i = eo[0] + (eo[0] == so[0]);
		}
		if (i < str->n) {
			new_string_copy(ex, &v, str->s + i, str->n - i);
			array_push(ex, res->u.p, &v);
		}
	}
	return 1;
}

/************************************************************
 *
 ************************************************************/
int string_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res)
{
	switch (sym) {
#include "_string_call.h"
	}
	return -1;
}
