/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"

/**************************************************************************
 *
 **************************************************************************/
#ifdef  INDEP_TIME
int mdays(int y, int m)
{
	return ((m==2) ? (28+!(y%4)) : (30+((m<=7)==(m%2))));
}
int ydays(int y, int m, int d)
{
	d--;
	while (--m >= 1) d += mdays(y,m);
	return d;
}
int udays(int y, int m, int d)
{
	d = ydays(y,m,d);
	while (--y >= 1970) d+=365+!(y%4);
	return d;
}
int wday(int y, int m, int d)
{
	return ((4 + udays(y,m,d)) % 7);
}
int utime(int y, int m, int d, int h, int i, int s)
{
	return ((udays(y,m,d)*86400) + (h*3600) + (i*60) + s);
}
void gdate(int t, int *y, int *m, int *d, int *h, int *i, int *s)
{
	int e;
	*s = t % 60; t /= 60;
	*i = t % 60; t /= 60;
	*h = t % 24; t /= 24;
	for (*y=1970; t > (e = 356+!(*y%4)); (*y)++, t-=e) ;
	for (*m=1; t > (e = mdays(*y,*m)); (*m)++, t-=e) ;
	*d = t+1;
}
#endif

int datetotime(int y, int m, int d, int h, int i, int s, int g)
{
	struct tm tm;
	
	memset(&tm, 0, sizeof(struct tm));
	if (y >  0) tm.tm_year = (y >= 1900) ? (y - 1900) : ((y < 70) ? (y + 100) : y);
	if (m >  0) tm.tm_mon  = m - 1;
	if (d >  0) tm.tm_mday = d;
	if (h >= 0) tm.tm_hour = h;
	if (i >= 0) tm.tm_min  = i;
	if (s >= 0) tm.tm_sec  = s;
	
	if (g) {
		s = timegm(&tm);
		/*
		s = mktime(&tm);
		s += tm.tm_gmtoff;
		*/
	} else {
		s = mktime(&tm);
	}
	
	return s;
}

/**************************************************************************
 *
 **************************************************************************/

static char* g_mons[] = {
"January",
"February",
"March",
"April",
"May",
"June",
"July",
"August",
"September",
"October",
"November",
"December"
};

static char* g_weeks[] = {
"Sunday",
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday"
};

int strtotime(char *src, int len, int g)
{
	struct { char *s; int n; } arr[10];
	int i,j,n, Y,M,D,H,I,S;
	
	Y = M = D = H = I = S = -1;
	
	i = 0;
	while ((i < len) && !isalnum(src[i])) i++;
	for (n = 0; (i < len) && isalnum(src[i]) && (n < 10); n++) {
		j = i;
		while ((i < len) && isalnum(src[i])) i++;
		arr[n].s = src + j;
		arr[n].n = i - j;
		while ((i < len) && !isalnum(src[i])) i++;
	}
	
	if ((n >= 3) && (isalpha(*(arr[0].s)) || isalpha(*(arr[1].s)) || isalpha(*(arr[2].s)))) {
		/* some == month and first digits == mday */
		Y = M = 0;
	}
	for (i=0; i < n; i++) {
		if (isalpha(*(arr[i].s))) {
			if (M <= 0) {
				for (j=0; j < 12; j++) {
					if (!strnncasecmp(arr[i].s, 3, g_mons[j], 3)) {
						M = j + 1;
						break;
					}
				}
			} else {
				if (!strnncasecmp(arr[i].s, 3, "gmt", 3)) {
					g = 1;
				}
			}
		} else if (*(arr[i].s + arr[i].n) == ':') {
			if (H < 0) {
				H = atoi(arr[i].s);
				if (((i+1) < n) && isdigit(*(arr[i+1].s))) {
					I = atoi(arr[++i].s);
					if (((i+1) < n) && isdigit(*(arr[i+1].s))) {
						S = atoi(arr[++i].s);
					}
				}
			}
		} else {
			if (Y < 0) Y = atoi(arr[i].s);
			else if (M < 0) M = atoi(arr[i].s);
			else if (D < 0) D = atoi(arr[i].s);
			else if (!Y) Y = atoi(arr[i].s);
			else if (!M) M = atoi(arr[i].s);
		}
	}
	
	return datetotime(Y, M, D, H, I, S, g);
}

int timetostr(char dst[BUFSIZ], char *fmt, int n, int t, int g)
{
	time_t tv;
	struct tm *tm;
	int c, len;
	int Y,y,M,D,H,h,I,S,w,z;
	char *A,*B,*Z,*P,*p;

	tv = t;
	if (g) {
		tm = gmtime(&tv);
	} else {
		tm = localtime(&tv);
	}
	Y = tm->tm_year + 1900;
	M = tm->tm_mon + 1;
	D = tm->tm_mday;
	H = tm->tm_hour;
	I = tm->tm_min;
	S = tm->tm_sec;
	w = tm->tm_wday;
	Z = g ? "GMT" : (char*)tm->tm_zone;
	z = g ? 0 : (tm->tm_gmtoff / 36);
	
	y = Y % 100;
	h = H % 12;
	P = (H > 12) ? "PM" : "AM";
	p = (H > 12) ? "pm" : "am";
	A = g_weeks[w];
	B = g_mons[M - 1];
	
	len = 0;
	while ((c = *fmt++) != 0) {
		if (!isalpha(c)) {
			dst[len++] = c;
			continue;
		}
		switch (c) {
		case 'c': /* ctime */
			len += sprintf(dst + len,
			"%.3s %.3s %02d %02d:%02d:%02d %s %04d", A,B,D,H,I,S,Z,Y);
			break;
		case 'C': /* ctime (no Z) */
			len += sprintf(dst + len,
			"%.3s %.3s %02d %02d:%02d:%02d %04d", A,B,D,H,I,S,Y);
			break;
		case 'r': /* rfc822 */
			len += sprintf(dst + len,
			"%.3s, %02d %.3s %04d %02d:%02d:%02d %+05d", A,D,B,Y,H,I,S,z);
			break;
		case 'R': /* rfc822 (no A) */
			len += sprintf(dst + len,
			"%02d %.3s %04d %02d:%02d:%02d %+05d", D,B,Y,H,I,S,z);
			break;
		case 'e': /* cookie expire */
			len += sprintf(dst + len,
			"%.3s, %02d-%.3s-%04d %02d:%02d:%02d %s", A,D,B,Y,H,I,S,Z);
			break;
		case 'f':
			len += sprintf(dst + len, "%04d-%02d-%02d %02d:%02d:%02d", Y,M,D,H,I,S);
			break;
		case 't':
			len += sprintf(dst + len, "%02d:%02d:%02d", H,I,S);
			break;
		/* date part */
		case 'Y': len += sprintf(dst + len, "%04d", Y); break;
		case 'y': len += sprintf(dst + len, "%02d", y); break;
		case 'M': len += sprintf(dst + len, "%02d", M); break;
		case 'm': len += sprintf(dst + len, "%d"  , M); break;
		case 'D': len += sprintf(dst + len, "%02d", D); break;
		case 'd': len += sprintf(dst + len, "%d"  , D); break;
		/* time */
		case 'H': len += sprintf(dst + len, "%02d", H); break;
		case 'I': len += sprintf(dst + len, "%02d", I); break;
		case 'S': len += sprintf(dst + len, "%02d", S); break;
		case 'h': len += sprintf(dst + len, "%d",   h); break;
		case 'P': len += sprintf(dst + len, "%s"  , P); break;
		case 'p': len += sprintf(dst + len, "%s"  , p); break;
		/* wday */
		case 'w': len += sprintf(dst + len, "%d"  , w); break;
		/* time zone */
		case 'z': len += sprintf(dst + len, "%+05d", z); break;
		case 'Z': len += sprintf(dst + len, "%s"   , Z); break;
		/* week month string */
		case 'A': len += sprintf(dst + len, "%s"  , A); break;
		case 'a': len += sprintf(dst + len, "%.3s", A); break;
		case 'B': len += sprintf(dst + len, "%s"  , B); break;
		case 'b': len += sprintf(dst + len, "%.3s", B); break;
		}
	}
	dst[len] = 0;
	
	return len;
}

