/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#ifndef _VAR_H_
#define _VAR_H_

typedef struct exec_t    exec_t;
typedef struct name_t    name_t;
typedef struct link_t    link_t;
typedef union  data_t    data_t;
typedef struct var_t     var_t;
typedef struct string_t  string_t;
typedef struct array_t   array_t;
typedef struct each_t    each_t;
typedef struct object_t  object_t;
typedef struct proto_t   proto_t;

struct name_t {
	int k;
	char *s;
	int n;
};

struct link_t {
	int lock;
	link_t* prev;
	link_t* next;
	proto_t* proto;
};

union data_t {
	int i;
	double f;
	void* p;
};

struct var_t {
	proto_t* p;
	data_t u;
};

struct string_t {
	char* s;
	int n;
};

struct array_t {
	var_t* v;
	int n;
};

struct each_t {
	int k;
	var_t v;
};

struct object_t {
	each_t* e;
	int n;
	object_t* p;
};

struct exec_t {
	name_t* ns; /* names */
	link_t* gc; /* garbage collection */
	object_t* gp; /* global frame pointer */
	object_t* fp; /* local frame pointer */
	char *bc; /* byte code */
	array_t* sp; /* stack pointer */
	int lc; /* loop counter */
	/* arg */
	int argc;
	var_t* argv;
	var_t* res; /* result var */
	int jmp; /* requested label */
	/* info */
	/* char* op; */
	char* func;
	char* file;
	int line;
	FILE* out;
	FILE* err;
	FILE* in;
};

#define exerrif(ex, exp, s) { \
	if (exp) {  \
		fprintf(ex->err, "%s: `%s` [%s:%d]\n", s, #exp, __FILE__, __LINE__); \
		return 0; \
	}\
}

struct proto_t {
	char*  typestr;
	int    lock;
	void   (*trace)      (exec_t*, void*);
	void   (*clear)      (exec_t*, void*);
	int    (*toBool)     (exec_t*, var_t*);
	int    (*toChar)     (exec_t*, var_t*);
	int    (*toInt)      (exec_t*, var_t*);
	double (*toFloat)    (exec_t*, var_t*);
	int    (*toNumber)   (exec_t*, var_t*, double*, int*);
	int    (*toString)   (exec_t*, var_t*, char **s, int *n);
	int    (*getLength)  (exec_t*, void*);
	int    (*setLength)  (exec_t*, void*, int);
	int    (*callFunc)   (exec_t*, void*, int, int, var_t*, var_t*);
	int    (*getItem)    (exec_t*, void*, var_t*, var_t*);
	int    (*setItem)    (exec_t*, void*, var_t*, var_t*);
	int    (*delItem)    (exec_t*, void*, var_t*, var_t*);
	int    (*eachItem)   (exec_t*, void*, int, var_t*, var_t*);
	int    reserve;
};

extern int compile_code(exec_t* ex, char* file, char *sc, int sz, char **bc, int* bn);
extern int compile_file(exec_t* ex, char *file, char **bc, int* bn);
extern int compile_file_to_file(exec_t* ex, char *scfile, char *bcfile);
extern int call_frame(exec_t* ex);
extern int call_bytes(exec_t* ex, char*, char*, int, var_t*, var_t*);
extern int call_function(exec_t* ex, object_t* gp, int sym, char*, int, var_t*, var_t*);
extern int eval_bytes(exec_t* ex, char *sc, int sz, var_t* res);
extern int exec_bytes(exec_t* ex, char *bc, int bn);
extern int exec_code(exec_t* ex, char *sc, int sz);
extern int exec_file(exec_t* ex, char *file);
extern int exec_init(exec_t* ex);
extern int exec_clear(exec_t* ex);

extern proto_t* bool_proto;
extern proto_t* char_proto;
extern proto_t* int_proto;
extern proto_t* symbol_proto;
extern proto_t* float_proto;
extern proto_t* string_proto;
extern proto_t* regex_proto;
extern proto_t* array_proto;
extern proto_t* refer_proto;
extern proto_t* object_proto;
extern proto_t* frame_proto;
extern proto_t* file_proto;
extern proto_t* dbm_proto;
extern proto_t* xml_proto;
extern proto_t* function_proto;
extern proto_t* class_proto;
extern proto_t* label_proto;

#endif /* _VAR_H_ */
