/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#ifndef _EXT_H_
#define _EXT_H_

extern int _global_length(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isNull(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isBool(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isChar(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isNumber(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isInt(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isFloat(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isString(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isArray(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isObject(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toBool(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toChar(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toInt(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toFloat(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toNumber(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toString(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int global_callFunc(exec_t* ex, int sym, int argc, var_t* argv, var_t* res);
extern int string_add(string_t* str, char *s, int n);
extern int string_get(exec_t* ex, string_t* str, int i, var_t* v);
extern int string_del(exec_t* ex, string_t* str, int i, var_t* v);
extern int string_set(exec_t* ex, string_t* str, int i, var_t* v);
extern int string_match(exec_t* ex, char *s1, int n1, var_t* val, var_t* res);
extern int string_match(exec_t* ex, char *s1, int n1, var_t* val, var_t* res);
extern void* string_alloc(exec_t* ex);
extern void string_free(exec_t* ex, void *v);
extern void string_trace(exec_t* ex, void *p);
extern void string_clear(exec_t* ex, void *p);
extern int string_getItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int string_delItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int string_setItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int string_eachItem(exec_t* ex, void *p, int i, var_t* k, var_t* v);
extern int string_setLength(exec_t* ex, void *p, int n);
extern int string_getLength(exec_t* ex, void *p);
extern int string_toBool(exec_t* ex, var_t* v);
extern int string_toChar(exec_t* ex, var_t* v);
extern int string_toInt(exec_t* ex, var_t* v);
extern double string_toFloat(exec_t* ex, var_t* v);
extern int string_toString(exec_t* ex, var_t* v, char **s, int *n);
extern int string_toNumber(exec_t* ex, var_t* v, double *f, int *i);
extern int string_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern int regex_comp(exec_t *ex, void *p, char *s, int n, int f);
extern int regex_exec(exec_t *ex, void *p, char *s, int n, int i, int so[10], int eo[10]);
extern void regex_trace(exec_t* ex, void *p);
extern void regex_free(exec_t* ex, void *p);
extern void regex_clear(exec_t* ex, void* p);
extern int new_regex (exec_t* ex, var_t* v, char *s, int n, int i);
extern void* array_alloc(exec_t* ex);
extern void array_free(exec_t* ex, void *v);
extern int array_push(exec_t* ex, array_t* arr, var_t* v);
extern int array_pop(exec_t* ex, array_t* arr, var_t* v);
extern int array_get(exec_t* ex, array_t* arr, int i, var_t* v);
extern int array_del(exec_t* ex, array_t* arr, int i, var_t* v);
extern int array_set(exec_t* ex, array_t* arr, int i, var_t* v);
extern int array_add(exec_t* ex, array_t* arr, int i, var_t* v);
extern void array_trace(exec_t* ex, void *p);
extern void array_clear(exec_t* ex, void *p);
extern int array_getItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int array_delItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int array_setItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int array_eachItem(exec_t* ex, void *p, int i, var_t* k, var_t* v);
extern int array_setLength(exec_t* ex, void *p, int n);
extern int array_getLength(exec_t* ex, void *p);
extern int array_toBool(exec_t* ex, var_t* v);
extern int array_toChar(exec_t* ex, var_t* v);
extern int array_toInt(exec_t* ex, var_t* v);
extern double array_toFloat(exec_t* ex, var_t* v);
extern int array_toString(exec_t *ex, var_t* v, char **s, int *n);
extern int array_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern void* refer_alloc(exec_t* ex);
extern void refer_free(exec_t* ex, void *v);
extern void refer_clear(exec_t* ex, void *p);
extern void refer_trace(exec_t* ex, void *p);
extern int refer_reserv(exec_t* ex, array_t *arr, var_t* obj, var_t* key);
extern int refer_set(exec_t* ex, var_t* v, var_t* val);
extern int is_refer_var(var_t* v);
extern int refer_resolv(exec_t* ex, array_t *arr, var_t* obj, var_t* key);
extern int refer_get(exec_t* ex, var_t* v, var_t* res);
extern int refer_del(exec_t* ex, var_t* v, var_t* res);
extern int refer_call(exec_t* ex, var_t *v, int argc, var_t* argv, var_t* res);
extern void* object_alloc(exec_t* ex);
extern void object_free(exec_t* ex, void *v);
extern int object_get(exec_t* ex, object_t* obj, int k, var_t* v);
extern int object_del(exec_t* ex, object_t* obj, int k, var_t* v);
extern int object_set(exec_t* ex, object_t* obj, int k, var_t* v);
extern int object_each(object_t* obj, int i, each_t* e);
extern void object_trace(exec_t* ex, void *p);
extern void object_clear(exec_t* ex, void *p);
extern int object_getItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int object_setItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int object_delItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int object_eachItem(exec_t* ex, void *p, int i, var_t* k, var_t* v);
extern int object_setLength(exec_t* ex, void *p, int n);
extern int object_getLength(exec_t* ex, void *p);
extern int object_toBool(exec_t* ex, var_t* v);
extern int object_toChar(exec_t* ex, var_t* v);
extern int object_toInt(exec_t* ex, var_t* v);
extern double object_toFloat(exec_t* ex, var_t* v);
extern int object_toString(exec_t* ex, var_t* v, char **s, int *n);
extern int object_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern void frame_trace(exec_t* ex, void *p);
extern void frame_clear(exec_t* ex, void *p);
extern void* frame_alloc(exec_t* ex);
extern void frame_free(exec_t* ex, void *v);
extern int frame_getLocal(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_delLocal(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_setLocal(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_get(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_del(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_set(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_getItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int frame_delItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int frame_setItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int new_file(exec_t* ex, var_t* v, FILE* fp, int (*xp)(FILE*));
extern void file_clear(exec_t* ex, void* p);
extern void file_trace(exec_t* ex, void *p);
extern int file_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern int new_dbm(exec_t* ex, var_t* v, char* path, char* mode);
extern void dbm_clear(exec_t* ex, void *p);
extern void dbm_trace(exec_t* ex, void *p);
extern int dbm_getItem(exec_t* ex, void* p, var_t* k, var_t* v);
extern int dbm_setItem(exec_t* ex, void* p, var_t* k, var_t* v);
extern int dbm_delItem(exec_t* ex, void* p, var_t* k, var_t* v);
extern int dbm_eachItem(exec_t* ex, void* p, int i, var_t* k, var_t* v);
extern int dbm_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern int new_xml_from_string(exec_t* ex, var_t* v, char *s, int n, char *f);
extern int new_xml_from_file(exec_t* ex, var_t* v, char *filename, char* mode);
extern void xml_clear(exec_t* ex, void *p);
extern void xml_trace(exec_t* ex, void *p);
extern int xml_toString(exec_t* ex, var_t* v, char **s, int *n);
extern int xml_getLength(exec_t* ex, void *p);
extern int xml_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern int string_to_symbol(exec_t* ex, char *s, int n);
extern int chars_to_symbol(exec_t* ex, char* s);
extern int symbol_to_string(exec_t* ex, int k, char** s, int *n);
extern char* symbol_to_chars(exec_t* ex, int k);
extern void free_names(exec_t* ex);
extern void trace_links(exec_t* ex);
extern void* alloc_link(exec_t* ex, size_t sz, proto_t* proto);
extern void free_link(exec_t* ex, void *p);
extern void free_links(exec_t* ex, void *p);
extern void trace_var(exec_t* ex, var_t* v);
extern int lock_var(exec_t* ex, var_t* v);
extern int unlock_var(exec_t* ex, var_t* v);
extern int delete_var(exec_t* ex, var_t* v);
extern void copy_var(var_t* v1, var_t* v2);
extern char* typeof_var(exec_t* ex, var_t* v);
extern int cat_vars(exec_t* ex, var_t* v1, var_t* v2, var_t* v3);
extern int cmp_vars_asNumber(exec_t* ex, var_t* v1, var_t* v2);
extern int cmp_vars_asString(exec_t* ex, var_t* v1, var_t* v2);
extern int cmp_vars(exec_t* ex, var_t* v1, var_t* v2);
extern int var_toBool(exec_t* ex, var_t* v);
extern int var_toChar(exec_t* ex, var_t* v);
extern int var_toInt(exec_t* ex, var_t* v);
extern double var_toFloat(exec_t* ex, var_t* v);
extern int var_toString(exec_t* ex, var_t* v, char **s, int *n);
extern int var_toNumber(exec_t* ex, var_t* v, double *f, int *i);
extern char* var_toChars(exec_t* ex,var_t* v);
extern int var_toSymbol(exec_t* ex, var_t* v);
extern int var_getLength(exec_t* ex, var_t* v, var_t* res);
extern int var_setLength(exec_t* ex, var_t* v, var_t* val);
extern int var_getItem(exec_t* ex, var_t* v, var_t* key, var_t* res);
extern int var_setItem(exec_t* ex, var_t* v, var_t* key, var_t* val);
extern int var_delItem(exec_t* ex, var_t* v, var_t* key, var_t* res);
extern int var_eachItem(exec_t* ex, var_t* v, int i, var_t* key, var_t* val);
extern int var_callFunc(exec_t* ex, var_t* v, int sym, int argc, var_t* argv, var_t* res);
extern int new_null (var_t* v);
extern int new_bool(var_t* v, int i);
extern int new_char (var_t* v, int i);
extern int new_int (var_t* v, int i);
extern int new_symbol (var_t* v, int i);
extern int new_float (var_t* v, double f);
extern int new_label (var_t* v, char *p);
extern int new_function (var_t* v, char *p);
extern int new_class (var_t* v, char *p);
extern int new_string_with (exec_t* ex, var_t* v, char *s, int n);
extern int new_string_copy (exec_t* ex, var_t* v, char *s, int n);
extern int new_string (exec_t* ex, var_t* v, void *p);
extern int new_array (exec_t* ex, var_t* v, void *p);
extern int new_refer (exec_t* ex, var_t* v, void *p);
extern int new_object (exec_t* ex, var_t* v, void* p);
extern int new_frame (exec_t* ex, var_t* v, void *p);
extern int serial_to_bytes(exec_t* ex, var_t* v, char **s, int *n);
extern int unserial_from_bytes(exec_t* ex, var_t* v, char *s, int n);
extern int echo_to_file(exec_t* ex, FILE* fp, char *s, int n);
extern int echo_to_bytes(exec_t* ex, char **d, char *s, int n);
extern int printf_to_file(exec_t* ex, FILE* fp, char *s, var_t* va, int vn);
extern int printf_to_bytes(exec_t* ex, char **d, char *s, var_t* va, int vn);
extern int trace_to_file(exec_t* ex, var_t* v, FILE* fp);
extern int trace_to_bytes(exec_t* ex, var_t* v, char **d);
extern int untrace_from_bytes(exec_t* ex, var_t* v, char *s, int n);
extern int mdays(int y, int m);
extern int ydays(int y, int m, int d);
extern int udays(int y, int m, int d);
extern int wday(int y, int m, int d);
extern int utime(int y, int m, int d, int h, int i, int s);
extern void gdate(int t, int *y, int *m, int *d, int *h, int *i, int *s);
extern int datetotime(int y, int m, int d, int h, int i, int s, int g);
extern int strtotime(char *src, int len, int g);
extern int timetostr(char dst[BUFSIZ], char *fmt, int t, int g);
extern int pack_to_bytes(exec_t* ex, char **dst, char* fmt, var_t* va, int vn);
extern int unpack_from_bytes(exec_t* ex, char *fmt, char *src, int len, var_t* res);
extern int strnmd5(char *d, char *s, unsigned long n);
extern char* strcrypt(char* pw, char* salt);
extern int base64_encode(char *d, char *s, int n);
extern int base64_decode(char *d, char *s, int n);
extern int quotedprintable_encode(char *d, char* s, int n);
extern int quotedprintable_decode(char *d, char* s, int n);
extern int url_encode(char *d, char *s, int n);
extern int url_decode(char *d, char *s, int n);
extern int encode(char **d, char *s, int n, int q);
extern int decode(char **d, char *s, int n, int q);
extern int entity(char **d, char *s, int n);
extern int unentity(char **d, char *s, int n);
extern int quote(char **d, char *s, int n, int q);
extern int unquote(char **d, char *s, int n);
extern int jcodeof(char *s, int n);
extern int jconv(char **d, char *s, int n, int j);
extern int jtrim(char **d, char *s, int n);
extern int setupcgi(exec_t* ex, FILE* in);
extern int flushcgi(exec_t* ex, FILE* out);
extern void close_connect(int sig);
extern int popmail(char *user, char *pass, FILE* out, FILE* err);
extern int sendmail(char *to, char* data, FILE* err);
extern int httpget(char *url, char *head, char* data, FILE* out, FILE* err);
extern int ftpsite(char *user, char* pass, char *cmd, FILE* err);

#endif /* _EXT_H_ */
