/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#ifndef _OP_H_
#define _OP_H_

typedef enum {
C_eof   = -1,
C_error =  0,
C_void      = 1,
C_addA      = 2,
C_subA      = 3,
C_mulA      = 4,
C_divA      = 5,
C_modA      = 6,
C_powA      = 7,
C_bitandA   = 8,
C_bitorA    = 9,
C_bitsubA   = 10,
C_bitxorA   = 11,
C_bitshLA   = 12,
C_bitshRA   = 13,
C_andA      = 14,
C_orA       = 15,
C_inc       = 16,
C_dec       = 17,
C_echo      = 18,
C_doc       = 19,
C_crlf      = 20,
C_if        = 21,
C_else      = 22,
C_for       = 23,
C_while     = 24,
C_do        = 25,
C_foreach   = 26,
C_switch    = 27,
C_default   = 28,
C_try       = 29,
C_break     = 30,
C_continue  = 31,
C_in        = 32,
C_not       = '!',
C_string    = '"',
C_sharp     = '#',
C_case      = '$',
C_mod       = '%',
C_bitand    = '&',
C_char      = '\'',
C_paL       = '(',
C_paR       = ')',
C_mul       = '*',
C_add       = '+',
C_comma     = ',',
C_sub       = '-',
C_join      = '.',
C_div       = '/',
C_catch     = '0',
C_throw     = '1',
C_return    = '2',
C_exit      = '3',
C_goto      = '4',
C_Minclude  = '5',
C_Mdefine   = '6',
C_var       = '7',
C_label     = '8',
C_function  = '9',
C_colon     = ':',
C_semic     = ';',
C_lt        = '<',
C_store     = '=',
C_gt        = '>',
C_que       = '?',
C_class     = '@',
C_file      = 'A',
C_line      = 'B',
C_names     = 'C',
C_stdin     = 'D',
C_stdout    = 'E',
C_stderr    = 'F',
C_tmpout    = 'G',
C_tmperr    = 'H',
C_frameIn   = 'I',
C_frameOut  = 'J',
C_jump      = 'K',
C_load      = 'L',
C_copy      = 'M',
C_sand      = 'N',
C_pop       = 'O',
C_call      = 'P',
C_args      = 'Q',
C_array     = 'R',
C_object    = 'S',
C_loop      = 'T',
C_plus      = 'U',
C_minus     = 'V',
C_bitnot    = 'W',
C_toBool    = 'X',
C_toChar    = 'Y',
C_toInt     = 'Z',
C_sqL       = '[',
C_toFloat   = '\\',
C_sqR       = ']',
C_bitxor    = '^',
C_toString  = '_',
C_regex     = '`',
C_toNumber  = 'a',
C_typeof    = 'b',
C_delete    = 'c',
C_new       = 'd',
C_null      = 'e',
C_true      = 'f',
C_false     = 'g',
C_this      = 'h',
C_symbol    = 'i',
C_int       = 'j',
C_float     = 'k',
C_match     = 'l',
C_notmatch  = 'm',
C_and       = 'n',
C_or        = 'o',
C_eq        = 'p',
C_ne        = 'q',
C_cmp       = 'r',
C_bitshL    = 's',
C_bitshR    = 't',
C_pow       = 'u',
C_cuL       = '{',
C_bitor     = '|',
C_cuR       = '}',
C_bitsub    = '~',
} op_t;


#endif /* _OP_H_ */
