/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"

void usage(char *cmd)
{
	printf("[usage]\n");
	printf("%s <source-file>\n", cmd);
	printf("%s <compiled-file>\n", cmd);
	printf("%s -c <source-file>\n", cmd);
	printf("%s -o <output-file> <source-file>\n", cmd);
	printf("%s -e \"<eval-code>\"\n", cmd);
}

int main(int argc, char *argv[])
{
	exec_t ex;
	char buf[BUFSIZ];
	char *s, *o;
	int r, i, c, e;
	s = o = NULL;
	c = e = 0;
	
	i = 1;
	while ((i < argc) && (*(s = argv[i]) == '-')) {
		i++;
		switch (*(++s)) {
		case 'e':
			/* eval */
			e = 1;
			break;
		case 'c':
			/* compile file */
			c = 1;
			break;
		case 'o':
			/* output file */
			if (i < argc) o = argv[i++];
			break;
		}
	}
	
	if (i >= argc) {
		usage(argv[0]);
		return -1;
	}
	
	exec_init(&ex);
	if (o) {
		s = argv[i++];
		r = compile_file_to_file(&ex, s, o);
	} else if (c) {
		s = argv[i++];
		o = strrchr(strcpy(buf, s), '.');
		if (!o) o = strchr(buf, 0);
		strcpy(o, ".jsc");
		r = compile_file_to_file(&ex, s, buf);
	} else if (e) {
		s = argv[i++];
		r = exec_code(&ex, s, strlen(s));
	} else {
		do {
			s = argv[i++];
			r = exec_file(&ex, s);
		} while ((r == 0) && (i < argc));
	}
	exec_clear(&ex);
	
	return r;
}
