/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: clause.cpp,v 1.3 2003/12/15 07:32:13 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/clause.cpp,v 1.3 2003/12/15 07:32:13 takayuki Exp $

#include "base/clause.h"
#include "base/message.h"

using namespace std;

/*
 *   ʸΰ륯饹
 */

    //ꤷ֤̾ޥåפ
Clause::map_type * Clause::getClauseMap(string name) throw()
{
    map_type * result = NULL;
    Namespace::iterator scope;

    Namespace * const ns = Singleton<Namespace>::getInstance(nothrow);
    if(ns!= 0) {
        scope = ns->find(name);
        if(scope != ns->end())
            result = &(scope->second);
    }

    return result;
}

    //Ͽ
void Clause::addClause(string _namespace, string _identifier) throw()
{
    if(isValid()) {
        Namespace * const ns = Singleton<Namespace>::getInstance(nothrow);
        if(ns != 0)
            (*ns)[_namespace][_identifier] = this;
//          ns->operator [](_namespace).insert(map_type::value_type(_identifier, this));        //񤭤ʤ
    }
}

    //ȡФἱ̾
string Clause::getClauseIdentifier(Token token) throw()
{
    string result;

    switch(token.getType()) {
        case Token::IDENTIFIER:
        case Token::PUNCTUATOR:
            result = token.getLiteral();    
            break;
        case Token::INTEGER:
            result.assign(INTEGER_CLAUSE_IDENTIFIER);
            break;
        case Token::LITERAL:
            result.assign(LITERAL_CLAUSE_IDENTIFIER);
            break;
        case Token::OPERATOR:
            result.assign(OPERATOR_CLAUSE_IDENTIFIER);
            break;
        default:
            result = string();
    }

    return result;
}

    //β
bool Clause::parseClause(string ns, Parser & p)
{
    bool result = false;
    map_type::iterator scope;
    map_type * clause = getClauseMap(ns);

        //
    if(clause == 0 || p.eof())
        return false;

        //ȡ󤫤鼱̾Ф
    Token  token;
    string identifier;

    token      = p.getToken();
    identifier = getClauseIdentifier(token);
    
        //μ¹
    scope = clause->find(identifier);
    if(scope != clause->end()) {

            //ǥХåѥå
        DebugMessage("Clause::parseClause(%) - %\n") << ns << identifier;

        try {
            scope->second->before(token, p);
            scope->second->body(token, p);  //ҥåȤΤ¹
            scope->second->after(token, p);
            result = true;
        }
        catch(...) {
            scope->second->onFail(token, p);    //ԤȤθ򤪴ꤤ
            throw;
        }
    }
    else
        p.putback(token);   //̻Ҥ˥ޥåΤϿƤʤ

    return result;
}

    //firstǻϤޤ᤬뤫
bool Clause::hasClause(string ns, string first) throw()
{
    map_type * clause = getClauseMap(ns);
    if(clause == 0)
        return false;

    return clause->find(first) != clause->end();
}

    //ѡ
void Clause::before(const Token &, Parser &)
{}

    //ѡ
void Clause::after(const Token &, Parser &)
{}

    //ɸ㳰ȯθ롼
void Clause::onFail(const Token &, Parser & p) throw()
{
    Token token;

        //Ǹޤɤߤ
    while(!p.eof())
        token = p.getToken();
}

    //ʣμ̾бդ
void Clause::addMultipleClauses(string ns, string id_list) throw()
{
    string            id;
    string::size_type pos;
    string::size_type prev;

        //ޤǶڤ줿addClauseȯ
    if(isValid()) {
        prev = 0;
        do {
            pos = id_list.find_first_of(',', prev);
            id  = id_list.substr(prev, pos - prev);

            addClause(ns, id);

            prev = pos + 1;
        } while(pos != string::npos);
    }
}

    //[إ] ϿƤΰ
std::string Clause::makeClauseList(string ns, int width) throw()
{
    string result;
    map_type::iterator scope;
    map_type * clause = getClauseMap(ns);
    size_t max_length = 0;

        //ʸĹ
    scope = clause->begin();
    while(scope != clause->end()) {
        size_t i = scope->first.size();
        if(i > max_length)
            max_length = i;
        ++ scope;
    }

        //
    size_t max_column = width/(max_length+1);
    size_t column = 0;
    scope = clause->begin();
    while(scope != clause->end()) {
        size_t i = scope->first.size();

        result += scope->first;

        ++ column;
        ++ scope;

            //
        if(column == max_column || scope == clause->end())
            result += '\n';
        else {
            result += ',';
            result += string(max_length - i, ' ');
        }
    }

    return result;
}


    /*
     *   ŪAPI
     */

    //ѡ
void StaticAPI::before(const Token & first, Parser & p)
{
    Token token = p.getToken();
    if(token != Token::LPAREN) {
        ExceptionMessage("StaticAPI [%] lacks left-parenthesis '('.","ŪAPI[%]ˤϳ'('礱Ƥ") << first.getLiteral() << throwException;
    }
}

    //ѡ
void StaticAPI::after(const Token & first, Parser & p)
{
    Token token = p.getToken();
    if(token != Token::RPAREN) {
        ExceptionMessage("StaticAPI [%] lacks right-parenthesis ')'.","ŪAPI[%]ˤϳ')'礱Ƥ") << first.getLiteral() << throwException;
    }
    else {
        token = p.getToken();
        if(token != ";")
            ExceptionMessage("StaticAPI [%] lacks ';' at the end of declaration.","ŪAPI[%]';'礱Ƥ") << first.getLiteral() << throwException;
    }
}

    //Իβ
void StaticAPI::onFail(const Token & , Parser & p) throw()
{   skip(p, false);   }


    //å
    //   invalid_api : ˺ǽɤ߽ФAPI̵
void StaticAPI::skip(Parser & p, bool invalid_api) throw()
{
        //ߥ or ŪAPIνиޤ
    Token token;
    bool  condition; //к

    if(invalid_api)
        token = p.getToken();   //API̾ɤФ

    do {
        token = p.getToken(true);

        condition = (!token.isValid()) ||                                                   //̵ʥȡ
                    (token == Token::PUNCTUATOR && token == ";") ||                         //ߥ
                    (token == Token::IDENTIFIER && hasStaticAPI(token.getLiteral()));       //ŪAPI

    } while(!condition);

    if(token == Token::IDENTIFIER)
        p.putback(token);
}

    /*
     *   ץץǥ쥯ƥ
     */

    //ѡ
void Directives::after(const Token & first, Parser & p) throw(Exception)
{
    Token token = p.getToken(true);
    if(!token.isValid() || !p.isLocatedonHeadofLine())
        ExceptionMessage("Directive [%] has a wrong parameter or misses a new-line.","ǥ쥯ƥ[%]ʰ뤫Ԥʤ") << first.getLiteral() << throwException;
}

    //ѡԻβ
void Directives::onFail(const Token & , Parser & p) throw()
{
        //βԤޤɤФ
    Token token;

    do {
        token = p.getToken(true);
    } while(token.isValid() && !p.isLocatedonHeadofLine());
}

/************************************************* ƥȥ *************************************************/

#ifdef TESTSUITE

#include "coverage_undefs.h"
#include <sstream>

namespace {
    class Clause_test : public Clause
    {
    public:
        Token        first;
        Token        second;
        bool         throw_exception;

        Clause_test(void) throw() : first(Token::ERROR), throw_exception(false) {}

        void body(const Token & _first, Parser & _p)
        {
            TestSuite::check("Clause_test::body");
            first = _first;
            second = _p.getToken();
            if(throw_exception)
                throw 0;
        }

        void before(const Token & , Parser & )
        {
            TestSuite::check("Clause_test::before");
        }

        void after(const Token &, Parser &)
        {
            TestSuite::check("Clause_test::after");
        }

        void onFail(const Token & _first, Parser & p) throw()
        {
            TestSuite::check("Clause_test::onFail");
            first = _first;
        }

        void onFail_super(const Token & _first, Parser & p) throw()
        {   Clause::onFail(_first, p);   }
    };
}

TESTSUITE(main, Clause)
{
    SingletonBase::ContextChain chain;
    chain.saveContext<Namespace>();

    BEGIN_CASE("getClauseIdentifier","getClauseIdentifier") {
        BEGIN_CASE("1","̤μ̻ҤϤΤޤޤȤˤʤ") {
            Token token(Token::IDENTIFIER, "test");

            if(getClauseIdentifier(token).compare("test") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ͤȤ˴طʤ" INTEGER_CLAUSE_IDENTIFIER "֤") {
            Token token(Token::INTEGER, "", "", 0);

            if(getClauseIdentifier(token).compare(INTEGER_CLAUSE_IDENTIFIER) != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","ƥȤ˴طʤ" LITERAL_CLAUSE_IDENTIFIER "֤") {
            Token token(Token::LITERAL, "");

            if(getClauseIdentifier(token).compare(LITERAL_CLAUSE_IDENTIFIER) != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","黻ҤȤ˴طʤ" OPERATOR_CLAUSE_IDENTIFIER "֤") {
            Token token(Token::OPERATOR);

            if(getClauseIdentifier(token).compare(OPERATOR_CLAUSE_IDENTIFIER) != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("5","Υȡˤ϶ʸ(==)֤") {
            Token token(Token::SPACE);

            if(!getClauseIdentifier(token).empty())
                TEST_FAIL;
        } END_CASE;

        TEST_CASE("6","顼ȡˤ϶ʸ(==)֤", getClauseIdentifier(Token(Token::ERROR)).empty());
        TEST_CASE("7","EOSȡˤ϶ʸ(==)֤",   getClauseIdentifier(Token(Token::END_OF_STREAM)).empty());

    } END_CASE;

    BEGIN_CASE("getClauseMap","getClauseMap") {
        BEGIN_CASE("1","ϿƤʤ֤ˤNULL֤") {
            chain.renewInstance();
            if(Clause::getClauseMap("unknown") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","Ǥ0֤") {
            chain.renewInstance();
            Singleton<Namespace>::getInstance()->operator []("test");

            if(Clause::getClauseMap("test") == 0)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("addClause","addClause") {
        BEGIN_CASE("1","֥ȤϿǤ") {
            chain.renewInstance();
            Clause_test ct;
            Clause_test ct2;

            BEGIN_CASE("1","̤Ͽ") {
                ct.addClause("test","first_literal");

                TEST_CASE("1","֤̾Ƥ", Singleton<Namespace>::getInstance()->size() == 1);
                TEST_CASE("2","\"test\"Ȥ֤", Singleton<Namespace>::getInstance()->find("test") != Singleton<Namespace>::getInstance()->end());
                TEST_CASE("3","getClauseǥɥ쥹", Clause::getClauseMap("test") != 0); 
                TEST_CASE("4","֤̾ο1",  Clause::getClauseMap("test")->size() == 1);
                TEST_CASE("5","\"first_literal\"ΥΡɤ", Clause::getClauseMap("test")->find("first_literal") != Clause::getClauseMap("test")->end());
                TEST_CASE("6","Ϣդ줿ͤ", (*Clause::getClauseMap("test"))["first_literal"] == &ct);
            } END_CASE;

            BEGIN_CASE("2","2ܤϿ") {
                ct2.addClause("test","second_literal");

                TEST_CASE("1","֤̾Ƥʤ", Singleton<Namespace>::getInstance()->size() == 1);
                TEST_CASE("2","\"test\"Ȥ֤", Singleton<Namespace>::getInstance()->find("test") != Singleton<Namespace>::getInstance()->end());
                TEST_CASE("3","֤̾ο2",  Clause::getClauseMap("test")->size() == 2);
                TEST_CASE("4","\"second_literal\"ΥΡɤ", Clause::getClauseMap("test")->find("second_literal") != Clause::getClauseMap("test")->end());
                TEST_CASE("5","Ϣդ줿ͤ", (*Clause::getClauseMap("test"))["second_literal"] == &ct2);
            } END_CASE;

            BEGIN_CASE("3","2ܤ1ܤǾϿ") {
                ct.addClause("test","second_literal");
                TEST_CASE("1","񤭤Ƥ", (*Clause::getClauseMap("test"))["second_literal"] == &ct);
            } END_CASE;

            BEGIN_CASE("4","㤦֤̾Ͽ") {
                ct.addClause("TEST","first_literal");

                TEST_CASE("1","֤̾Ƥ", Singleton<Namespace>::getInstance()->size() == 2);
                TEST_CASE("2","\"TEST\"Ȥ֤", Singleton<Namespace>::getInstance()->find("TEST") != Singleton<Namespace>::getInstance()->end());
                TEST_CASE("3","getClauseǥɥ쥹", Clause::getClauseMap("TEST") != 0); 
                TEST_CASE("4","֤̾ο1",  Clause::getClauseMap("TEST")->size() == 1);
                TEST_CASE("5","\"first_literal\"ΥΡɤ", Clause::getClauseMap("TEST")->find("first_literal") != Clause::getClauseMap("TEST")->end());
                TEST_CASE("6","Ϣդ줿ͤ", (*Clause::getClauseMap("TEST"))["first_literal"] == &ct);
            } END_CASE;

        } END_CASE;

        BEGIN_CASE("2","̵ʥ֥ȤϿʤ") {
            chain.renewInstance();

            ((Clause_test *)0)->addClause("test","first_literal");

            TEST_CASE("1","֤̾Ƥʤ", Singleton<Namespace>::getInstance()->size() == 0);
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("hasClause","hasClause") {
        Clause_test ct;
        chain.renewInstance();

        TEST_CASE("1","ǤʤȤˤư", !Clause::hasClause("dummy","null"));

        ct.addClause("test","first_literal");

        TEST_CASE("2","ϿǤõtrue֤", Clause::hasClause("test","first_literal"));
        TEST_CASE("3","¸ߤʤǤfalse֤", !Clause::hasClause("dummy","null"));
    } END_CASE;

    BEGIN_CASE("addMultipleClauses","addMultipleClauses") {
        BEGIN_CASE("1","ñϿǤ") {
            chain.renewInstance();
            Clause_test ct;

            ct.addMultipleClauses("test","first");

            TEST_CASE("1","Ͽ᤬", Clause::hasClause("test","first"));
        } END_CASE;

        BEGIN_CASE("2","ʣϿ") {
            chain.renewInstance();
            Clause_test ct;

            ct.addMultipleClauses("test","first,second,third");

            TEST_CASE("1","Ͽ᤬", Clause::hasClause("test","first"));
            TEST_CASE("2","Ͽ᤬", Clause::hasClause("test","second"));
            TEST_CASE("3","Ͽ᤬", Clause::hasClause("test","third"));
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("Clause::onFail","Clause::onFail") {
        stringstream buf;
        Parser p(&buf, "test");
        Token token;
        Clause_test ct;

        buf.str("first second third 4 5 6 siebt acht neunt 0xa");

        ct.onFail_super(token, p);
        TEST_CASE("1","ȥ꡼ϺǸޤǿʤǤ", p.eof());
    } END_CASE;

    BEGIN_CASE("parseClause","parseClause") {
        chain.renewInstance();
        Clause_test ct;

        ct.addClause("test","first");

        BEGIN_CASE("1","֤̾򤷤¹ԤǤ") {
            stringstream buf;
            Parser p(&buf, "test");
            buf.str("first second");

            TestSuite::clearCheckpoints();
            TEST_CASE("1","ؿ", Clause::parseClause("test", p));
            TEST_CASE("2","Clause::before¹ԤƤ", TestSuite::isReached("Clause_test::before"));
            TEST_CASE("3","Clause::body¹ԤƤ", TestSuite::isReached("Clause_test::body"));
            TEST_CASE("4","bodyfirst", ct.first == "first");
            TEST_CASE("5","bodyɤ߽Фȡ", ct.second == "second");
            TEST_CASE("6","Clause::after¹ԤƤ", TestSuite::isReached("Clause_test::after"));
        } END_CASE;

        BEGIN_CASE("2","ν㳰onFailƤФ") {
            stringstream buf;
            Parser p(&buf, "test");
            buf.str("first second");

            ct.throw_exception = true;
            TestSuite::clearCheckpoints();

            bool result = false;
            try { Clause::parseClause("test", p); }
            catch(...){ result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","Clause::body¹ԤƤ", TestSuite::isReached("Clause_test::body"));
            TEST_CASE("3","Clause::onFail¹ԤƤ", TestSuite::isReached("Clause_test::onFail"));
        } END_CASE;

        BEGIN_CASE("3","¸ߤʤ֤̾ꤹ") {
            stringstream buf;
            Parser p(&buf, "test");
            buf.str("first second");

            TEST_CASE("1","ؿϼԤ", !Clause::parseClause("unknown", p));
        } END_CASE;

        BEGIN_CASE("4","EOFãȥ꡼ꤹ") {
            stringstream buf;
            Parser p(&buf, "test");
            buf.str("");
            buf.get();

            TEST_CASE("0","[]ȥ꡼ϽüãƤ", buf.eof());
            TEST_CASE("1","ؿϼԤ", !Clause::parseClause("unknown", p));
        } END_CASE;
    } END_CASE;

    chain.restoreContext();
}




namespace {
    class StaticAPI_test : public StaticAPI
    {
    public:
        StaticAPI_test(void) throw() : StaticAPI() {}
        StaticAPI_test(string src) throw() : StaticAPI(src) {}

        void body(const Token & , Parser &) { TestSuite::check("StaticAPI::body"); }
        void onFail_super(const Token & first, Parser & p) throw() { StaticAPI::onFail(first, p); }
    };
}

TESTSUITE(main, StaticAPI)
{
    Singleton<Namespace>::Context context;
    Singleton<Namespace>::saveContext(context);

    Exception::setThrowControl(true);

    BEGIN_CASE("regist","regist") {
        BEGIN_CASE("1","ñ̾ꤷϿǤ") {
            Singleton<Namespace>::renewInstance();
            StaticAPI_test api;

            api.regist("VTST_API");

            TEST_CASE("1","APIϿǤƤ",StaticAPI::hasStaticAPI("VTST_API"));
        } END_CASE;

        BEGIN_CASE("2","ʣ̾ꤷϿ") {
            Singleton<Namespace>::renewInstance();
            StaticAPI_test api;

            api.regist("API_1,API_2,API_3");

            TEST_CASE("1","APIϿǤƤ",StaticAPI::hasStaticAPI("API_1"));
            TEST_CASE("2","APIϿǤƤ",StaticAPI::hasStaticAPI("API_2"));
            TEST_CASE("3","APIϿǤƤ",StaticAPI::hasStaticAPI("API_3"));
        } END_CASE;

        BEGIN_CASE("3","񤭤") {
            Singleton<Namespace>::renewInstance();
            StaticAPI_test api;
            StaticAPI_test api2;
            StaticAPI_test api3;

            api.regist("test");
            TEST_CASE("1","APIϿǤƤ",StaticAPI::hasStaticAPI("test"));
            TEST_CASE("2","APIϥɥ餬", (*StaticAPI::getClauseMap(NAMESPACE_STATICAPI))["test"] == &api);

            api2.regist("test");
            TEST_CASE("3","APIϥɥ餬񤭤Ƥ", (*StaticAPI::getClauseMap(NAMESPACE_STATICAPI))["test"] == &api2);

            api3.regist("test");
            TEST_CASE("4","APIϥɥ餬񤭤Ƥ", (*StaticAPI::getClauseMap(NAMESPACE_STATICAPI))["test"] == &api3);
        } END_CASE;

        BEGIN_CASE("4","󥹥ȥ饯Ͽ") {
            Singleton<Namespace>::renewInstance();
            StaticAPI_test api("API1,API2,API3");

            TEST_CASE("1","APIϿǤƤ",StaticAPI::hasStaticAPI("API1"));
            TEST_CASE("2","APIϿǤƤ",StaticAPI::hasStaticAPI("API2"));
            TEST_CASE("3","APIϿǤƤ",StaticAPI::hasStaticAPI("API3"));
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("parseStaticAPI","parseStaticAPI") {
        BEGIN_CASE("1","ŪAPIǤ") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            StaticAPI_test api("API");

            buf.str("API();");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = true;
            try { StaticAPI::parseStaticAPI(p); }
            catch(...) { result = false; }

            TEST_CASE("1","㳰ϵʤ", result);
            TEST_CASE("2","ŪAPIΤƤФƤ", TestSuite::isReached("StaticAPI::body"));
        } END_CASE;

        BEGIN_CASE("2","'('˺㳰") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            StaticAPI_test api("API");

            buf.str("API);");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { StaticAPI::parseStaticAPI(p); }
            catch(...) { result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","ŪAPIΤƤФʤ", !TestSuite::isReached("StaticAPI::body"));
        } END_CASE;

        BEGIN_CASE("3","')'˺㳰") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            StaticAPI_test api("API");

            buf.str("API(; NEXT");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { StaticAPI::parseStaticAPI(p); }
            catch(...) { result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","ŪAPIΤƤФƤ", TestSuite::isReached("StaticAPI::body"));
        } END_CASE;

        BEGIN_CASE("4","';'˺㳰") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            StaticAPI_test api("API");

            buf.str("API() NEXT");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { StaticAPI::parseStaticAPI(p); }
            catch(...) { result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","ŪAPIΤƤФƤ", TestSuite::isReached("StaticAPI::body"));
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("onFail","onFail") {
        BEGIN_CASE("1","ߥޤɤФ") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api;
            Token token;
            buf.str("api parameter;next_api next_api_parameter;");

            api.onFail_super(Token(), p);

            TEST_CASE("1","ߥμɤ", p.getToken() == "next_api");
        } END_CASE;

        BEGIN_CASE("2","APIޤɤФ") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api("api,next_api");
            buf.str("api parameter_1 parameter_2 next_api next_api_parameter;");

            api.onFail_super(p.getToken(), p);

            TEST_CASE("1","API̾ɤ", p.getToken() == "next_api");
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("skip","skip") {
        BEGIN_CASE("1","ߥޤɤФ") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api;
            Token token;
            buf.str("api parameter;next_api next_api_parameter;");

            StaticAPI::skip(p);

            TEST_CASE("1","ߥμɤ", p.getToken() == "next_api");
        } END_CASE;

        BEGIN_CASE("2","APIޤɤФ") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api("api,next_api");
            buf.str("parameter_1 parameter_2 next_api next_api_parameter;");

            StaticAPI::skip(p);

            TEST_CASE("1","API̾ɤ", p.getToken() == "next_api");
        } END_CASE;

        BEGIN_CASE("3","ƬAPI̾ǤɤФǤ") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api("api,next_api");
            buf.str("api parameter_1 parameter_2 next_api next_api_parameter;");

            StaticAPI::skip(p);

            TEST_CASE("1","API̾ɤ", p.getToken() == "next_api");
        } END_CASE;
    } END_CASE;
    
    Singleton<Namespace>::restoreContext(context);
}


namespace {
    class Directives_test : public Directives
    {
    public:
        bool throws;

        Directives_test(void) throw() : Directives(), throws(false) {}
        Directives_test(string src) throw() : Directives(src), throws(false)  {}

        void body(const Token & , Parser & ) throw(int)
        {
            TestSuite::check("Directives::body");
            if(throws)
                throw 0;
        }
    };
}

TESTSUITE(main, Directives)
{
    Singleton<Namespace>::Context context;
    Singleton<Namespace>::saveContext(context);

    Exception::setThrowControl(true);

    BEGIN_CASE("regist","regist") {
        BEGIN_CASE("1","ñ̾ꤷϿǤ") {
            Singleton<Namespace>::renewInstance();
            Directives_test api;

            api.regist("include");

            TEST_CASE("1","APIϿǤƤ",Directives::hasDirectives("include"));
        } END_CASE;

        BEGIN_CASE("2","ʣ̾ꤷϿ") {
            Singleton<Namespace>::renewInstance();
            Directives_test api;

            api.regist("pragma,define,endif");

            TEST_CASE("1","ǥ쥯ƥ֤ϿǤƤ",Directives::hasDirectives("pragma"));
            TEST_CASE("2","ǥ쥯ƥ֤ϿǤƤ",Directives::hasDirectives("define"));
            TEST_CASE("3","ǥ쥯ƥ֤ϿǤƤ",Directives::hasDirectives("endif"));
        } END_CASE;

        BEGIN_CASE("3","񤭤") {
            Singleton<Namespace>::renewInstance();
            Directives_test api;
            Directives_test api2;
            Directives_test api3;

            api.regist("test");
            TEST_CASE("1","ǥ쥯ƥ֤ϿǤƤ",Directives::hasDirectives("test"));
            TEST_CASE("2","ǥ쥯ƥ֥ϥɥ餬", (*Directives::getClauseMap(NAMESPACE_DIRECTIVES))["test"] == &api);

            api2.regist("test");
            TEST_CASE("3","ǥ쥯ƥ֥ϥɥ餬񤭤Ƥ", (*Directives::getClauseMap(NAMESPACE_DIRECTIVES))["test"] == &api2);

            api3.regist("test");
            TEST_CASE("4","ǥ쥯ƥ֥ϥɥ餬񤭤Ƥ", (*Directives::getClauseMap(NAMESPACE_DIRECTIVES))["test"] == &api3);
        } END_CASE;

        BEGIN_CASE("4","󥹥ȥ饯Ͽ") {
            Singleton<Namespace>::renewInstance();
            Directives_test api("pragma,define,endif");

            TEST_CASE("1","ǥ쥯ƥ֤ϿǤƤ",Directives::hasDirectives("pragma"));
            TEST_CASE("2","ǥ쥯ƥ֤ϿǤƤ",Directives::hasDirectives("define"));
            TEST_CASE("3","ǥ쥯ƥ֤ϿǤƤ",Directives::hasDirectives("endif"));
        } END_CASE;
    } END_CASE;
    
    BEGIN_CASE("parseDirectives","parseDirectives") {
        BEGIN_CASE("1","ǥ쥯ƥ֤Ǥ") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Directives_test api("pragma");

            buf.str("pragma\nnext\n");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = true;
            try { Directives::parseDirectives(p); }
            catch(...) { result = false; }

            TEST_CASE("1","㳰ϵʤ", result);
            TEST_CASE("2","ǥ쥯ƥ֤ΤƤФƤ", TestSuite::isReached("Directives::body"));
        } END_CASE;

        BEGIN_CASE("2","Ԥʤ(ѥ᡼)㳰") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Directives_test api("pragma");

            buf.str("pragma next\n");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { Directives::parseDirectives(p); }
            catch(...) { result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","ǥ쥯ƥ֤ΤƤФƤ", TestSuite::isReached("Directives::body"));
        } END_CASE;

        BEGIN_CASE("3","Ԥʤ(EOF)㳰") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Directives_test api("pragma");

            buf.str("pragma");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { Directives::parseDirectives(p); }
            catch(...) { result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","ǥ쥯ƥ֤ΤƤФƤ", TestSuite::isReached("Directives::body"));
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("onFail","onFail") {
        BEGIN_CASE("1","body㳰onFailβԤޤɤФ") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Directives_test api("pragma");
            buf.str("pragma parameter\nnext\n");
            Parser p(&buf, "test");

            api.throws = true;
            bool result = false;
            try { Directives::parseDirectives(p); }
            catch(...) { result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","ĤäƤ", p.getToken() == "next");
            TEST_CASE("3","ȡϹƬ", p.isHeadofLine());
        } END_CASE;
    } END_CASE;
            
    Singleton<Namespace>::restoreContext(context);
}

#endif



