/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by Advanced Data Controls, Corp
 *  Copyright (C) 2009 by Suikan
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */


/*
 *  åȥåװ¸⥸塼LPC2388ѡ
 *
 *  Υ󥯥롼ɥեϡsys_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */


#ifndef _CHIP_CONFIG_H_
#define _CHIP_CONFIG_H_


/*
 * ߥϥɥκ
 */
#define MAX_INT_NUM 31

/*
 *  vxget_tim 򥵥ݡȤ뤫ɤ
 */
#define  SUPPORT_VXGET_TIM



/*
 *  Ԥ֤Ǥμ¹ԥ롼
 */
#ifdef ARM920T_CORE
#define WAIT_INTERRUPT  mcr p15, 0, r3, c7, c0, 4
#else
#define WAIT_INTERRUPT  nop
#endif

/*
 *  ץåΥǥ
 */
#define SIL_ENDIAN  SIL_ENDIAN_LITTLE  /* ȥ륨ǥ */


/*
 * ----------------------- ߥ٥ȥ --------------------
 * INTNO_UART0 ǤϤʤ INTO_U0 ȤΤϡUARTTOPPERS/JSPΥǥХ̾Ȥ
 * ȤäƤꡢUARTֹLPC2388Ʊ̿ǥХֹ椬פʤǤ롣
 *
 */
#define	INTNO_WDT		0
/*reserverved interrupt 1*/
#define	INTNO_ARM0		2
#define	INTNO_ARM1		3
#define	INTNO_TIMER0	4
#define	INTNO_TIMER1	5
#define	INTNO_U0		6
#define	INTNO_U1		7
#define	INTNO_PWM1		8
#define	INTNO_I2C0		9
#define	INTNO_SSP0		10
#define	INTNO_SSP1		11
#define	INTNO_PLL		12
#define	INTNO_RTC		13
#define	INTNO_EINT0		14
#define	INTNO_EINT1		15
#define	INTNO_EINT2		16
#define	INTNO_EINT3		17
#define	INTNO_ADC0		18
#define	INTNO_I2C1		19
#define	INTNO_BOD		20
#define	INTNO_ETHERNET	21
#define	INTNO_USB		22
#define	INTNO_CAN		23
#define	INTNO_SD		24
#define	INTNO_GPDMA		25
#define	INTNO_TIMER2	26
#define	INTNO_TIMER3	27
#define	INTNO_U2		28
#define	INTNO_U3		29
#define	INTNO_I2C2		30
#define	INTNO_I2S		31

#define	INHNO_WDT		0
/*reserverved interrupt 1*/
#define	INHNO_ARM0		2
#define	INHNO_ARM1		3
#define	INHNO_TIMER0	4
#define	INHNO_TIMER1	5
#define	INHNO_U0		6
#define	INHNO_U1		7
#define	INHNO_PWM1		8
#define	INHNO_I2C0		9
#define	INHNO_SSP0		10
#define	INHNO_SSP1		11
#define	INHNO_PLL		12
#define	INHNO_RTC		13
#define	INHNO_EINT0		14
#define	INHNO_EINT1		15
#define	INHNO_EINT2		16
#define	INHNO_EINT3		17
#define	INHNO_ADC0		18
#define	INHNO_I2C1		19
#define	INHNO_BOD		20
#define	INHNO_ETHERNET	21
#define	INHNO_USB		22
#define	INHNO_CAN		23
#define	INHNO_SD		24
#define	INHNO_GPDMA		25
#define	INHNO_TIMER2	26
#define	INHNO_TIMER3	27
#define	INHNO_U2		28
#define	INHNO_U3		29
#define	INHNO_I2C2		30
#define	INHNO_I2S		31

/*
 * SIO1,2,3ˤU0,U2,U3Ƥ
 */
#define INHNO_SIO		INHNO_U0
#define INHNO_SIO2		INHNO_U2
#define INHNO_SIO3		INHNO_U3

/*
 * ----------------------- UART  ---------------------------
 */

/*
 *     UARTΤĤΥݡȤPDICȤƻѤ뤫롣
 *     LPC2388ǤǤϺ3
 */
#define TNUM_SIOP_UART	TNUM_SIOP

/*
 *    UARTΥ쥸Хȶ֤Ƥ뤫ꤹ롣Ǥͤ1,2,4Τ줫
 */
#define UART_BOUNDARY	4

/*
 * UART 쥸ؤΥsil_xxb_iop()ȤˤϤΥޥ롣
 * ͤסʤ硢sil_xxb_mem()ˤäƥ롣LPC2388
 * ǤmemѤ롣
 */
/* #define UART_IOP_ACCESS */

/*
 *     UARTΥ١ɥ쥹ꤹ롣١ɥ쥹ȤTHRΥɥ쥹Τȡ
 *     U0,2,3ȤΤϡLPC2388ˤU1̰Τ
 */
#define UART0_ADDRESS 0xE000C000
#define UART1_ADDRESS 0xE0078000	/*U2*/
#define UART2_ADDRESS 0xE007C000	/*U3*/

/*
 * UARTʬϩͤꤹ롣16ӥåȤ͡lpc2388uart.c
 * ̤Ȳ̤ʬ䤷DLM/DLL쥸ꤵ롣
 *
 * UARTΥǥХνϤϽ˾ܡ졼Ȥ16ܤǤʤФʤʤ
 * U0,2,3ȤΤϡLPC2388ˤU1̰Τ
 */
#define UART0_DIVISOR (LP2388_SYSTEM_UART0_CLOCK/16/UART0_BAUD_RATE)
#define UART1_DIVISOR (LP2388_SYSTEM_UART1_CLOCK/16/UART2_BAUD_RATE) /*U2*/
#define UART2_DIVISOR (LP2388_SYSTEM_UART1_CLOCK/16/UART3_BAUD_RATE) /*U3*/


/*
 * ----------------------- UART ꤪ ---------------------------
 */


#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void    sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥ƽФǼ¸뤳Ȥꤷ
 *  Ƥ롥
 */
extern void    sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥ƽФǼ¸뤳
 *  ȤꤷƤ롥
 */
extern void    sys_putc(char c);



/*
 *  IRQϥɥ(sys_support.S)
 */
extern void IRQ_Handler(void);

/*
 *  ߥϥɥνޥ
 *
 */
#define INTHDR_ENTRY(inthdr)  extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

/*
 *  ߥϥɥ
 *
 *  ֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
extern void define_inh(INHNO inhno, FP inthdr);

extern void undef_interrupt();

extern void init_IRQ();
extern void init_vector();
extern void init_uart0();

/*
 * ߤΥ֥͡롢ǥ֥
 */

extern ER dis_int(INTNO intno);
extern ER ena_int(INTNO intno);
extern ER chg_ims(unsigned int enableMask);
extern ER get_ims(unsigned int *p_enableMask);

#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */
