/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2006 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2006 by Logic Research Co., Ltd.
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *  åȥƥ¸⥸塼FRK_ADuCѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */


#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_


/*
 *  ͥ̾Υ͡
 */
#include <sys_rename.h>

/*
 * ߥϥɥκ
 */
#define MAX_INT_NUM 24

/*
 *  vxget_tim 򥵥ݡȤ뤫ɤ
 */
#define  SUPPORT_VXGET_TIM


/*
 *  ꥢݡֹ˴ؤ
 */
#define TNUM_PORT   1   /* ݡȤ륷ꥢݡȤο */
#define TNUM_SIOP   1   /* ݡȤ륷ꥢI/OݡȤο */

/*
 *  ꥢݡֹ˴ؤ
 */
#define LOGTASK_PORTID  1   /* ƥѤ륷ꥢݡֹ */


/*
 *  Ԥ֤Ǥμ¹ԥ롼
 */
//#ifdef ARM920T_CORE
//#define WAIT_INTERRUPT  mcr p15, 0, r3, c7, c0, 4
//#else
#define WAIT_INTERRUPT  nop
//#endif


/*
 *  ץåΥǥ
 */
#define SIL_ENDIAN  SIL_ENDIAN_LITTLE  /* ȥ륨ǥ */

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void    sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥ƽФǼ¸뤳Ȥꤷ
 *  Ƥ롥
 */
extern void    sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥ƽФǼ¸뤳
 *  ȤꤷƤ롥
 */
extern void    sys_putc(char c);


/*
 *  ѤΥơ֥
 */
extern FP   int_table[MAX_INT_NUM];


/*
 *  IRQϥɥ(sys_support.S)
 */
extern void IRQ_Handler(void);

/*
 *  ߥϥɥνޥ
 *
 */
#define INTHDR_ENTRY(inthdr)  extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

/*
 *  ߥϥɥ
 *
 *  ֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
extern void define_inh(INHNO inhno, FP inthdr);


#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */

